/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.HandlerMapping;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.CatalogRefBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.client.catalog.writer.CatalogXmlWriter;
import thredds.server.admin.DebugController;
import thredds.server.config.TdsContext;
import thredds.server.radarServer2.RadarDataInventory;
import thredds.server.radarServer2.RadarServerConfig;
import thredds.server.radarServer2.StationList;
import thredds.servlet.ThreddsConfig;
import ucar.nc2.constants.CDM;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

@Controller
@RequestMapping(value={"/radarServer"})
public class RadarServerController {
    Map<String, RadarDataInventory> data;
    static final String appName = "/thredds/";
    static final String entryPoint = "radarServer/";
    static final String URLbase = "/thredds/radarServer/";
    static Map<String, List<RadarServerConfig.RadarConfigEntry.VarInfo>> vars;
    boolean enabled = false;
    @Autowired
    TdsContext tdsContext;

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public String handleException(Exception exc) {
        StringWriter sw = new StringWriter(5000);
        exc.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    @ResponseBody
    public String badQuery(Exception exc) {
        return exc.getMessage();
    }

    void setupDebug() {
        DebugController.Category debugHandler = DebugController.find("RadarServer");
        DebugController.Action act = new DebugController.Action("showDatasets", "Show Datasets"){

            @Override
            public void doAction(DebugController.Event e) {
                try {
                    for (Map.Entry<String, RadarDataInventory> ent : RadarServerController.this.data.entrySet()) {
                        e.pw.println(ent.getKey());
                        RadarDataInventory di = ent.getValue();
                        if (di == null) {
                            e.pw.println("Dataset is null");
                            continue;
                        }
                        e.pw.printf("Collection Dir: %s%n", di.getCollectionDir().toString());
                        e.pw.printf("Last Update: %s%n", di.getLastUpdate());
                        e.pw.println("Dates:");
                        for (String item : di.listItems(RadarDataInventory.DirType.Date)) {
                            e.pw.println("\t" + item);
                        }
                        e.pw.println("Stations:");
                        for (String item : di.listItems(RadarDataInventory.DirType.Station)) {
                            e.pw.println("\t" + item);
                        }
                        e.pw.println("Vars:");
                        for (String item : di.listItems(RadarDataInventory.DirType.Variable)) {
                            e.pw.println("\t" + item);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(e.pw);
                }
            }
        };
        debugHandler.addAction(act);
    }

    @PostConstruct
    public void init() {
        this.enabled = ThreddsConfig.getBoolean("RadarServer.allow", false);
        if (!this.enabled) {
            return;
        }
        this.setupDebug();
        this.data = new TreeMap<String, RadarDataInventory>();
        vars = new TreeMap<String, List<RadarServerConfig.RadarConfigEntry.VarInfo>>();
        String contentPath = this.tdsContext.getContentDirectory().getPath();
        List<RadarServerConfig.RadarConfigEntry> configs = RadarServerConfig.readXML(contentPath + "/radar/radarCollections.xml");
        for (RadarServerConfig.RadarConfigEntry conf : configs) {
            RadarDataInventory di = new RadarDataInventory(Paths.get(conf.diskPath, new String[0]));
            di.setName(conf.name);
            di.setDescription(conf.doc);
            if (!conf.dataFormat.equals("NEXRAD2")) {
                di.addVariableDir();
            }
            di.addStationDir();
            di.addDateDir("yyyyMMdd");
            di.addFileTime(conf.dataFormat.equals("NEXRAD2") ? "yyyyMMdd_HHmm#.ar2v#" : "yyyyMMdd_HHmm#.nids#");
            di.setNearestWindow(CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Hour));
            di.setDataFormat(conf.dataFormat);
            this.data.put(conf.urlPath, di);
            vars.put(conf.urlPath, conf.vars);
            StationList sl = di.getStationList();
            sl.loadFromXmlFile(contentPath + "/" + conf.stationFile);
        }
    }

    @RequestMapping(value={"catalog.xml"})
    @ResponseBody
    public HttpEntity<byte[]> topLevelCatalog() throws IOException {
        if (!this.enabled) {
            return null;
        }
        CatalogBuilder cb = new CatalogBuilder();
        cb.addService(new Service("radarServer", URLbase, "QueryCapability", null, null, new ArrayList(), new ArrayList()));
        cb.setName("THREDDS Radar Server");
        DatasetBuilder mainDB = new DatasetBuilder(null);
        mainDB.setName("Radar Data");
        for (Map.Entry<String, RadarDataInventory> ent : this.data.entrySet()) {
            RadarDataInventory di = ent.getValue();
            CatalogRefBuilder crb = new CatalogRefBuilder(mainDB);
            crb.setName(di.getName());
            crb.setTitle(di.getName());
            crb.setHref(ent.getKey() + "/dataset.xml");
            mainDB.addDataset((DatasetBuilder)crb);
        }
        cb.addDataset(mainDB);
        CatalogXmlWriter writer = new CatalogXmlWriter();
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        writer.writeXML(cb.makeCatalog(), (OutputStream)os);
        byte[] xmlBytes = os.toByteArray();
        HttpHeaders header = new HttpHeaders();
        header.setContentType(new MediaType("application", "xml"));
        header.setContentLength((long)xmlBytes.length);
        return new HttpEntity((Object)xmlBytes, (MultiValueMap)header);
    }

    private String idvDatasetCatalog(String xml) {
        String ret = xml.replace("variables", "Variables");
        ret = ret.replace("timeCoverage", "TimeSpan");
        StringBuilder sub = new StringBuilder(ret.substring(0, ret.indexOf("<geospatialCoverage>")));
        sub.append("<LatLonBox>\n\t<north>90.0</north>\n\t<south>-90.0</south>");
        sub.append("\n\t<east>180.0</east>\n\t<west>-180.0</west></LatLonBox>");
        String endCoverage = "</geospatialCoverage>";
        sub.append(ret.substring(ret.indexOf(endCoverage) + endCoverage.length()));
        return sub.toString();
    }

    private String parseDatasetFromURL(HttpServletRequest request) {
        String match = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        return match.substring(match.indexOf(entryPoint) + entryPoint.length());
    }

    private String parseDatasetFromURL(HttpServletRequest request, String ending) {
        String match = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        return match.substring(match.indexOf(entryPoint) + entryPoint.length(), match.indexOf(ending));
    }

    @RequestMapping(value={"**/dataset.xml"})
    @ResponseBody
    public HttpEntity<byte[]> datasetCatalog(HttpServletRequest request) throws IOException {
        byte[] xmlBytes;
        if (!this.enabled) {
            return null;
        }
        String agent = request.getHeader("user-agent");
        boolean makeIDVCatalog = false;
        if (agent != null && agent.startsWith("Java/1.")) {
            makeIDVCatalog = true;
        }
        String dataset = this.parseDatasetFromURL(request, "/dataset.xml");
        RadarDataInventory di = this.getInventory(dataset);
        CatalogBuilder cb = new CatalogBuilder();
        cb.addService(new Service("radarServer", URLbase, "DQC", null, null, new ArrayList(), new ArrayList()));
        cb.setName("Radar Data");
        DatasetBuilder mainDB = new DatasetBuilder(null);
        mainDB.setName(di.getName());
        mainDB.put("Id", (Object)dataset);
        mainDB.put("UrlPath", (Object)dataset);
        mainDB.put("DataFormatType", (Object)di.getDataFormat());
        mainDB.put("FeatureType", (Object)di.getFeatureType().toString());
        mainDB.put("ServiceName", (Object)"radarServer");
        ThreddsMetadata tmd = new ThreddsMetadata();
        Map metadata = tmd.getFlds();
        metadata.put("Documentation", new Documentation(null, null, null, "summary", di.getDescription()));
        metadata.put("GeospatialCoverage", new ThreddsMetadata.GeospatialCoverage(new ThreddsMetadata.GeospatialRange(20.0, 40.0, 0.0, "degrees_north"), new ThreddsMetadata.GeospatialRange(-135.0, 70.0, 0.0, "degrees_east"), new ThreddsMetadata.GeospatialRange(0.0, 70.0, 0.0, "km"), new ArrayList(), null));
        CalendarDate now = CalendarDate.present();
        CalendarDate start = now.subtract(CalendarPeriod.of((int)14, (CalendarPeriod.Field)CalendarPeriod.Field.Day));
        metadata.put("TimeCoverage", new DateRange(start.toDate(), now.toDate()));
        ArrayList<ThreddsMetadata.Variable> catalogVars = new ArrayList<ThreddsMetadata.Variable>();
        for (RadarServerConfig.RadarConfigEntry.VarInfo vi : vars.get(dataset)) {
            catalogVars.add(new ThreddsMetadata.Variable(vi.name, null, vi.vocabName, vi.units, null));
        }
        ThreddsMetadata.VariableGroup vg = new ThreddsMetadata.VariableGroup("DIF", null, null, catalogVars);
        metadata.put("VariableGroups", vg);
        mainDB.put("ThreddsMetadataInheritable", (Object)tmd);
        cb.addDataset(mainDB);
        CatalogXmlWriter writer = new CatalogXmlWriter();
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        writer.writeXML(cb.makeCatalog(), (OutputStream)os);
        if (makeIDVCatalog) {
            String xml = os.toString("UTF-8");
            xml = this.idvDatasetCatalog(xml);
            xmlBytes = xml.getBytes(CDM.utf8Charset);
        } else {
            xmlBytes = os.toByteArray();
        }
        HttpHeaders header = new HttpHeaders();
        header.setContentType(new MediaType("application", "xml"));
        header.setContentLength((long)xmlBytes.length);
        return new HttpEntity((Object)xmlBytes, (MultiValueMap)header);
    }

    @RequestMapping(value={"**/{dataset}"}, params={"station=all"})
    @ResponseBody
    public StationList stations(@PathVariable String dataset, HttpServletRequest request) {
        if (!this.enabled) {
            return null;
        }
        dataset = this.parseDatasetFromURL(request);
        return this.listStations(dataset);
    }

    @RequestMapping(value={"**/stations.xml"})
    @ResponseBody
    public StationList stationsFile(HttpServletRequest request) {
        if (!this.enabled) {
            return null;
        }
        String dataset = this.parseDatasetFromURL(request, "/stations.xml");
        return this.listStations(dataset);
    }

    StationList listStations(String dataset) {
        RadarDataInventory di = this.getInventory(dataset);
        return di.getStationList();
    }

    RadarDataInventory getInventory(String dataset) {
        return this.data.get(dataset);
    }

    HttpEntity<byte[]> simpleString(String str) {
        byte[] bytes = str.getBytes(CDM.utf8Charset);
        HttpHeaders header = new HttpHeaders();
        header.setContentType(new MediaType("application", "text"));
        header.setContentLength((long)bytes.length);
        return new HttpEntity((Object)bytes, (MultiValueMap)header);
    }

    @RequestMapping(value={"**/{dataset}"})
    HttpEntity<byte[]> handleQuery(@PathVariable String dataset, @RequestParam(value="stn", required=false) String[] stations, @RequestParam(value="longitude", required=false) Double lon, @RequestParam(value="latitude", required=false) Double lat, @RequestParam(value="east", required=false) Double east, @RequestParam(value="west", required=false) Double west, @RequestParam(value="north", required=false) Double north, @RequestParam(value="south", required=false) Double south, @RequestParam(value="time", required=false) String time, @RequestParam(value="time_start", required=false) String start, @RequestParam(value="time_end", required=false) String end, @RequestParam(value="time_duration", required=false) String period, @RequestParam(value="temporal", required=false) String temporal, @RequestParam(value="var", required=false) String[] vars, HttpServletRequest request) throws ParseException, UnsupportedOperationException, IOException {
        if (!this.enabled) {
            return null;
        }
        dataset = this.parseDatasetFromURL(request);
        RadarDataInventory di = this.getInventory(dataset);
        if (di == null) {
            return this.simpleString("Could not find dataset: " + dataset);
        }
        RadarDataInventory.Query q = di.newQuery();
        if (!this.setTimeLimits(q, time, start, end, period, temporal)) {
            throw new UnsupportedOperationException("Either a single time argument, temporal=all, or a combination of time_start, time_end, and time_duration must be provided.");
        }
        StringBuilder queryString = new StringBuilder();
        this.addQueryElement(queryString, "time", time);
        this.addQueryElement(queryString, "time_start", start);
        this.addQueryElement(queryString, "time_end", end);
        this.addQueryElement(queryString, "time_duration", period);
        this.addQueryElement(queryString, "temporal", temporal);
        if (stations == null) {
            try {
                stations = this.getStations(di.getStationList(), lon, lat, north, south, east, west);
                this.addQueryElement(queryString, "longitude", lon);
                this.addQueryElement(queryString, "latitude", lat);
                this.addQueryElement(queryString, "north", north);
                this.addQueryElement(queryString, "south", south);
                this.addQueryElement(queryString, "east", east);
                this.addQueryElement(queryString, "west", west);
            }
            catch (UnsupportedOperationException e) {
                throw new UnsupportedOperationException("Either a list of stations, a lat/lon point, or a box defined by north, south, east, and west parameters must be provided.");
            }
        } else {
            this.addQueryElement(queryString, "stn", stations);
        }
        this.setStations(q, stations);
        if (di.needsVar()) {
            if (!this.setVariables(q, vars)) {
                throw new UnsupportedOperationException("One or more variables required.");
            }
            this.addQueryElement(queryString, "var", vars);
        }
        return this.makeCatalog(dataset, di, q, queryString.toString());
    }

    private void addQueryElement(StringBuilder sb, String name, String[] values) {
        if (values != null) {
            this.addQueryElement(sb, name, StringUtils.join((Object[])values, (char)','));
        }
    }

    private void addQueryElement(StringBuilder sb, String name, Double value) {
        if (value != null) {
            this.addQueryElement(sb, name, value.toString());
        }
    }

    private void addQueryElement(StringBuilder sb, String name, String value) {
        if (value != null) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(name).append('=').append(value);
        }
    }

    private HttpEntity<byte[]> makeCatalog(String dataset, RadarDataInventory inv, RadarDataInventory.Query query, String queryString) throws IOException, ParseException {
        List<RadarDataInventory.Query.QueryResultItem> res = query.results();
        CatalogBuilder cb = new CatalogBuilder();
        cb.addService(new Service("OPENDAP", "/thredds/dodsC/" + dataset, ServiceType.OPENDAP.toString(), null, null, new ArrayList(), new ArrayList()));
        cb.setName("Radar " + inv.getName() + " datasets in near real time");
        DatasetBuilder mainDB = new DatasetBuilder(null);
        mainDB.setName("Radar" + inv.getName() + " datasets for available stations and times");
        mainDB.put("CollectionType", (Object)"TimeSeries");
        mainDB.put("Id", (Object)queryString);
        ThreddsMetadata tmd = new ThreddsMetadata();
        Map metadata = tmd.getFlds();
        metadata.put("DataFormatType", inv.getDataFormat());
        metadata.put("FeatureType", inv.getFeatureType().toString());
        metadata.put("ServiceName", "OPENDAP");
        metadata.put("Documentation", new Documentation(null, null, null, null, res.size() + " datasets found for query"));
        mainDB.put("ThreddsMetadataInheritable", (Object)tmd);
        for (RadarDataInventory.Query.QueryResultItem i : res) {
            DatasetBuilder fileDB = new DatasetBuilder(mainDB);
            fileDB.setName(i.file.getFileName().toString());
            fileDB.put("Id", (Object)String.valueOf(i.file.hashCode()));
            fileDB.put("Dates", (Object)new DateType(i.time.toString(), null, "start of ob", i.time.getCalendar()));
            fileDB.put("UrlPath", (Object)inv.getCollectionDir().relativize(i.file).toString());
            mainDB.addDataset(fileDB);
        }
        cb.addDataset(mainDB);
        CatalogXmlWriter writer = new CatalogXmlWriter();
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        writer.writeXML(cb.makeCatalog(), (OutputStream)os);
        byte[] xmlBytes = os.toByteArray();
        HttpHeaders header = new HttpHeaders();
        header.setContentType(new MediaType("application", "xml"));
        header.setContentLength((long)xmlBytes.length);
        return new HttpEntity((Object)xmlBytes, (MultiValueMap)header);
    }

    boolean setTimeLimits(RadarDataInventory.Query query, String timePoint, String start, String end, String period, String temporal) throws ParseException {
        CalendarDate time = this.parseTime(timePoint);
        if (time != null) {
            query.addDateRange(CalendarDateRange.of((CalendarDate)time, (CalendarDate)time));
            return true;
        }
        CalendarDate timeStart = this.parseTime(start);
        CalendarDate timeEnd = this.parseTime(end);
        TimeDuration duration = null;
        if (period != null) {
            duration = TimeDuration.parseW3CDuration((String)period);
        }
        if (timeStart != null) {
            if (timeEnd != null) {
                query.addDateRange(CalendarDateRange.of((CalendarDate)timeStart, (CalendarDate)timeEnd));
                return true;
            }
            if (duration != null) {
                query.addDateRange(new CalendarDateRange(timeStart, (long)duration.getValueInSeconds()));
                return true;
            }
        } else if (timeEnd != null && duration != null) {
            query.addDateRange(new CalendarDateRange(timeEnd.add((double)((long)(-duration.getValueInSeconds())), CalendarPeriod.Field.Second), (long)duration.getValueInSeconds()));
            return true;
        }
        if (temporal != null) {
            query.addDateRange(null);
            return true;
        }
        return false;
    }

    CalendarDate parseTime(String timeString) {
        if (timeString == null) {
            return null;
        }
        if (timeString.equalsIgnoreCase("present")) {
            return CalendarDate.present();
        }
        return CalendarDate.parseISOformat(null, (String)timeString);
    }

    void setStations(RadarDataInventory.Query query, String[] stations) {
        for (String stid : stations) {
            query.addCriteria(RadarDataInventory.DirType.Station, stid);
        }
    }

    String[] getStations(StationList stations, Double lon, Double lat, Double north, Double south, Double east, Double west) {
        if (lat != null && lon != null) {
            StationList.Station nearest = stations.getNearest(lon, lat);
            if (nearest == null) {
                throw new UnsupportedOperationException("No stations available to search for nearest.");
            }
            return new String[]{nearest.getStid()};
        }
        if (north != null && south != null && east != null && west != null) {
            List<StationList.Station> inBox = stations.getStations(east, west, north, south);
            ArrayList<String> stIds = new ArrayList<String>(inBox.size());
            for (StationList.Station s : inBox) {
                stIds.add(s.getStid());
            }
            return stIds.toArray(new String[stIds.size()]);
        }
        throw new UnsupportedOperationException("Either station, a lat/lon point, or a box defined by north, south, east, and west parameters must be provided.");
    }

    boolean setVariables(RadarDataInventory.Query query, String[] variables) {
        if (variables == null) {
            return false;
        }
        for (String var : variables) {
            query.addCriteria(RadarDataInventory.DirType.Variable, var);
        }
        return true;
    }
}

