/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Service;
import thredds.core.AllowedServices;
import thredds.core.DataRoot;
import thredds.core.DatasetHandler;
import thredds.server.catalog.ConfigCatalog;
import thredds.server.catalog.DatasetRootConfig;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollection;
import thredds.server.catalog.builder.ConfigCatalogBuilder;
import thredds.server.config.TdsContext;
import thredds.servlet.PathMatcher;
import thredds.servlet.ThreddsConfig;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.util.StringUtil2;

@Component(value="ConfigCatalogManager")
public class ConfigCatalogManager {
    private static Logger log = LoggerFactory.getLogger(ConfigCatalogManager.class);
    private static Logger logCatalogInit = LoggerFactory.getLogger((String)(ConfigCatalogManager.class.getName() + ".catalogInit"));
    private static Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private static final String ERROR = "*** ERROR ";
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private PathMatcher<DataRoot> pathMatcher;
    private HashMap<String, ConfigCatalog> staticCatalogHash;
    private Set<String> staticCatalogNames;
    private HashSet<String> idHash = new HashSet();
    private boolean cacheStaticCatalogs;
    private AllowedServices allowedServices;

    public ConfigCatalog getStaticCatalog(String path) {
        return this.staticCatalogHash.get(path);
    }

    public List<String> getStaticCatalogPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.staticCatalogNames) {
            result.add(s);
        }
        return result;
    }

    public boolean isStaticCatalogNotInCache(String path) {
        return !this.cacheStaticCatalogs && this.staticCatalogNames.contains(path);
    }

    void initCatalogs() {
        ArrayList<String> catList = new ArrayList<String>();
        catList.add("catalog.xml");
        catList.addAll(ThreddsConfig.getCatalogRoots());
        logCatalogInit.info("initCatalogs(): initializing " + catList.size() + " root catalogs.");
        this.initCatalogs(catList);
    }

    void initCatalogs(List<String> configCatalogRoots) {
        this.allowedServices = new AllowedServices();
        this.cacheStaticCatalogs = ThreddsConfig.getBoolean("Catalog.cache", true);
        startupLog.info("DataRootHandler: staticCache= " + this.cacheStaticCatalogs);
        this.staticCatalogNames = new HashSet<String>();
        this.staticCatalogHash = new HashMap();
        for (String path : configCatalogRoots) {
            try {
                path = StringUtils.cleanPath((String)path);
                logCatalogInit.info("\n**************************************\nCatalog init " + path + "\n[" + CalendarDate.present() + "]");
                this.initCatalog(path, true, true);
            }
            catch (Throwable e) {
                logCatalogInit.error("*** ERROR initializing catalog " + path + "; " + e.getMessage(), e);
            }
        }
    }

    private void initCatalog(String path, boolean recurse, boolean cache) throws IOException {
        int pos;
        ConfigCatalog cat;
        path = StringUtils.cleanPath((String)path);
        File f = this.tdsContext.getConfigFileSource().getFile(path);
        if (f == null) {
            logCatalogInit.error("*** ERROR initCatalog(): Catalog [" + path + "] does not exist in config directory.");
            return;
        }
        System.out.printf("initCatalog %s%n", f.getPath());
        if (this.staticCatalogNames.contains(path)) {
            logCatalogInit.error("*** ERROR initCatalog(): Catalog [" + path + "] already seen, possible loop (skip).");
            return;
        }
        this.staticCatalogNames.add(path);
        if (logCatalogInit.isDebugEnabled()) {
            logCatalogInit.debug("initCatalog {} -> {}", (Object)path, (Object)f.getAbsolutePath());
        }
        if ((cat = this.readCatalog(path, f.getPath())) == null) {
            logCatalogInit.error("*** ERROR initCatalog(): failed to read catalog <" + f.getPath() + ">.");
            return;
        }
        for (DatasetRootConfig p : cat.getDatasetRoots()) {
            this.addRoot(p, true);
        }
        List<String> disallowedServices = this.allowedServices.getDisallowedServices((Catalog)cat);
        if (!disallowedServices.isEmpty()) {
            logCatalogInit.error("*** ERROR initCatalog(): declared services: " + disallowedServices.toString() + " in catalog: " + f.getPath() + " are disallowed in threddsConfig file");
        }
        String dirPath = (pos = path.lastIndexOf("/")) > 0 ? path.substring(0, pos + 1) : "";
        boolean needsCache = this.initSpecialDatasets(cat.getDatasets());
        if (this.cacheStaticCatalogs || cache || needsCache) {
            this.staticCatalogHash.put(path, cat);
            if (logCatalogInit.isDebugEnabled()) {
                logCatalogInit.debug("  add static catalog to hash=" + path);
            }
        }
        if (recurse) {
            this.initFollowCatrefs(dirPath, cat.getDatasets());
        }
    }

    private ConfigCatalog readCatalog(String path, String catalogFullPath) {
        URI uri;
        try {
            uri = new URI("file:" + StringUtil2.escape((String)catalogFullPath, (String)"/:-_."));
        }
        catch (URISyntaxException e) {
            logCatalogInit.error("*** ERROR readCatalog(): URISyntaxException=" + e.getMessage());
            return null;
        }
        ConfigCatalogBuilder builder = new ConfigCatalogBuilder();
        try {
            logCatalogInit.info("\n-------readCatalog(): full path=" + catalogFullPath + "; path=" + path);
            ConfigCatalog cat = (ConfigCatalog)builder.buildFromURI(uri);
            if (builder.hasFatalError()) {
                logCatalogInit.error("*** ERROR    invalid catalog -- " + builder.getErrorMessage());
                return null;
            }
            if (builder.getErrorMessage().length() > 0) {
                logCatalogInit.debug(builder.getErrorMessage());
            }
            return cat;
        }
        catch (Throwable t) {
            logCatalogInit.error("*** ERROR   Exception on catalog=" + catalogFullPath + " " + t.getMessage() + "\n log=" + builder.getErrorMessage(), t);
            return null;
        }
    }

    private boolean initSpecialDatasets(List<Dataset> dsList) {
        boolean needsCache = false;
        Iterator<Dataset> iter = dsList.iterator();
        while (iter.hasNext()) {
            Dataset dataset = iter.next();
            String id = dataset.getID();
            if (id != null) {
                if (this.idHash.contains(id)) {
                    logCatalogInit.error("*** ERROR Duplicate id on  '" + dataset.getName() + "' id= '" + id + "'");
                } else {
                    this.idHash.add(id);
                }
            }
            if (dataset instanceof DatasetScan) {
                DatasetScan ds = (DatasetScan)dataset;
                Service service = ds.getServiceDefault();
                if (service == null) {
                    logCatalogInit.error("*** ERROR DatasetScan " + ds.getName() + " has no default Service - skipping");
                    continue;
                }
                if (!this.addRoot(ds)) {
                    iter.remove();
                }
            } else if (dataset instanceof FeatureCollection) {
                FeatureCollection fc = (FeatureCollection)dataset;
                this.addRoot(fc);
                needsCache = true;
            } else if (dataset.getNcmlElement() != null) {
                DatasetHandler.putNcmlDataset(dataset.getUrlPath(), dataset);
            }
            if (dataset instanceof CatalogRef) continue;
            this.initSpecialDatasets(dataset.getDatasets());
        }
        return needsCache;
    }

    private void initFollowCatrefs(String dirPath, List<Dataset> datasets) throws IOException {
        for (Dataset Dataset2 : datasets) {
            if (Dataset2 instanceof CatalogRef && !(Dataset2 instanceof DatasetScan) && !(Dataset2 instanceof FeatureCollection)) {
                String path;
                String contextPathPlus;
                CatalogRef catref = (CatalogRef)Dataset2;
                String href = catref.getXlinkHref();
                if (logCatalogInit.isDebugEnabled()) {
                    logCatalogInit.debug("  catref.getXlinkHref=" + href);
                }
                if (href.startsWith("http:")) continue;
                if (href.startsWith("./")) {
                    href = href.substring(2);
                }
                if (href.startsWith(contextPathPlus = this.tdsContext.getContextPath() + "/")) {
                    path = href.substring(contextPathPlus.length());
                } else {
                    if (href.startsWith("/")) {
                        logCatalogInit.error("*** ERROR Skipping catalogRef <xlink:href=" + href + ">. Reference is relative to the server outside the context path [" + contextPathPlus + "]. Parent catalog info: Name=\"" + catref.getParentCatalog().getName() + "\"; Base URI=\"" + catref.getParentCatalog().getUriString() + "\"; dirPath=\"" + dirPath + "\".");
                        continue;
                    }
                    path = dirPath + href;
                }
                this.initCatalog(path, true, false);
                continue;
            }
            if (Dataset2 instanceof DatasetScan || Dataset2 instanceof FeatureCollection) continue;
            this.initFollowCatrefs(dirPath, Dataset2.getDatasets());
        }
    }

    private boolean addRoot(DatasetScan dscan) {
        String path = dscan.getPath();
        if (path == null) {
            logCatalogInit.error(ERROR + dscan.getName() + " missing a path attribute.");
            return false;
        }
        DataRoot droot = this.pathMatcher.get(path);
        if (droot != null) {
            if (!droot.getDirLocation().equals(dscan.getScanLocation())) {
                logCatalogInit.error("*** ERROR DatasetScan already have dataRoot =<" + path + ">  mapped to directory= <" + droot.getDirLocation() + "> wanted to map to fmrc=<" + dscan.getScanLocation() + "> in catalog " + dscan.getParentCatalog().getUriString());
            }
            return false;
        }
        droot = new DataRoot(dscan);
        this.pathMatcher.put(path, droot);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for directory= <" + dscan.getScanLocation() + ">");
        return true;
    }

    public List<FeatureCollection> getFeatureCollections() {
        ArrayList<FeatureCollection> result = new ArrayList<FeatureCollection>();
        Iterator<DataRoot> iter = this.pathMatcher.iterator();
        while (iter.hasNext()) {
            DataRoot droot = iter.next();
            if (droot.getFeatureCollection() == null) continue;
            result.add(droot.getFeatureCollection());
        }
        return result;
    }

    public FeatureCollection findFcByCollectionName(String collectionName) {
        Iterator<DataRoot> iter = this.pathMatcher.iterator();
        while (iter.hasNext()) {
            DataRoot droot = iter.next();
            if (droot.getFeatureCollection() == null || !droot.getFeatureCollection().getCollectionName().equals(collectionName)) continue;
            return droot.getFeatureCollection();
        }
        return null;
    }

    private boolean addRoot(FeatureCollection fc) {
        File file;
        String path = fc.getPath();
        if (path == null) {
            logCatalogInit.error(ERROR + fc.getName() + " missing a path attribute.");
            return false;
        }
        DataRoot droot = this.pathMatcher.get(path);
        if (droot != null) {
            logCatalogInit.error("*** ERROR FeatureCollection already have dataRoot =<" + path + ">  mapped to directory= <" + droot.getDirLocation() + "> wanted to use by FeatureCollection Dataset =<" + fc.getName() + ">");
            return false;
        }
        droot = new DataRoot(fc);
        if (droot.getDirLocation() != null && !(file = new File(droot.getDirLocation())).exists()) {
            logCatalogInit.error("*** ERROR FeatureCollection = '" + fc.getName() + "' directory= <" + droot.getDirLocation() + "> does not exist\n");
            return false;
        }
        this.pathMatcher.put(path, droot);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for feature collection= <" + fc.getName() + ">");
        return true;
    }

    private boolean addRoot(String path, String dirLocation, boolean wantErr) {
        DataRoot droot = this.pathMatcher.get(path);
        if (droot != null) {
            if (wantErr) {
                logCatalogInit.error("*** ERROR already have dataRoot =<" + path + ">  mapped to directory= <" + droot.getDirLocation() + "> wanted to map to <" + dirLocation + ">");
            }
            return false;
        }
        File file = new File(dirLocation);
        if (!file.exists()) {
            logCatalogInit.error("*** ERROR Data Root =" + path + " directory= <" + dirLocation + "> does not exist");
            return false;
        }
        droot = new DataRoot(path, dirLocation);
        this.pathMatcher.put(path, droot);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for directory= <" + dirLocation + ">");
        return true;
    }

    private boolean addRoot(DatasetRootConfig config, boolean wantErr) {
        String path = config.getPath();
        String location = config.getLocation();
        DataRoot droot = this.pathMatcher.get(path);
        if (droot != null) {
            if (wantErr) {
                logCatalogInit.error("*** ERROR DataRootConfig already have dataRoot =<" + path + ">  mapped to directory= <" + droot.getDirLocation() + "> wanted to map to <" + location + ">");
            }
            return false;
        }
        File file = new File(location = ConfigCatalog.translateAlias((String)location));
        if (!file.exists()) {
            logCatalogInit.error("*** ERROR DataRootConfig path =" + path + " directory= <" + location + "> does not exist");
            return false;
        }
        droot = new DataRoot(path, location);
        this.pathMatcher.put(path, droot);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for directory= <" + location + ">");
        return true;
    }
}

