/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.servlet.ThreddsConfig;

public enum AllowableService {
    CDMREMOTE(InvService.wms, ThreddsConfig.getBoolean("CdmRemote.allow", true)),
    NCSS(InvService.ncss, ThreddsConfig.getBoolean("NetcdfSubsetService.allow", true)),
    WMS(InvService.wms, ThreddsConfig.getBoolean("WMS.allow", false)),
    WCS(InvService.wcs, ThreddsConfig.getBoolean("WCS.allow", false)),
    ISO(InvService.iso, ThreddsConfig.getBoolean("NCISO.isoAllow", false)),
    UDDC(InvService.uddc, ThreddsConfig.getBoolean("NCISO.uddcAllow", false)),
    NCML(InvService.ncml, ThreddsConfig.getBoolean("NCISO.ncmlAllow", false));

    private Boolean allowed;
    private InvService service;

    private AllowableService(InvService service, boolean allowed) {
        this.allowed = allowed;
        this.service = service;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public InvService getService() {
        return this.service;
    }

    public static List<String> checkCatalogServices(InvCatalog catalog) {
        ArrayList<String> disallowedServices = new ArrayList<String>();
        List services = catalog.getServices();
        for (InvService s : services) {
            disallowedServices.addAll(AllowableService.checkService(s));
        }
        return disallowedServices;
    }

    private static List<String> checkService(InvService service) {
        ArrayList<String> disallowedServices = new ArrayList<String>();
        if (service.getServiceType() == ServiceType.COMPOUND) {
            for (InvService s : service.getServices()) {
                disallowedServices.addAll(AllowableService.checkService(s));
            }
        } else if (!AllowableService.isServiceAllowed(service)) {
            disallowedServices.add(service.getName());
        }
        return disallowedServices;
    }

    private static boolean isServiceAllowed(InvService service) {
        AllowableService as = AllowableService.findAllowableService(service);
        if (as == null) {
            return true;
        }
        return as.isAllowed();
    }

    private static AllowableService findAllowableService(InvService service) {
        boolean found = false;
        List<AllowableService> allServices = Arrays.asList(AllowableService.values());
        Iterator<AllowableService> it = allServices.iterator();
        AllowableService as = null;
        while (!found && it.hasNext()) {
            as = it.next();
            if (!as.getService().equals((Object)service)) continue;
            found = true;
        }
        if (found) {
            return as;
        }
        return null;
    }
}

