/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs.v1_0_0_1;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.wcs.VersionHandler;
import thredds.server.wcs.v1_0_0_1.WcsRequestParser;
import thredds.servlet.ServletUtil;
import thredds.util.ContentType;
import thredds.util.Version;
import thredds.wcs.Request;
import thredds.wcs.v1_0_0_1.DescribeCoverage;
import thredds.wcs.v1_0_0_1.ExceptionReport;
import thredds.wcs.v1_0_0_1.GetCapabilities;
import thredds.wcs.v1_0_0_1.GetCoverage;
import thredds.wcs.v1_0_0_1.WcsCoverage;
import thredds.wcs.v1_0_0_1.WcsException;
import thredds.wcs.v1_0_0_1.WcsRequest;
import ucar.nc2.util.DiskCache2;

public class WcsHandler
implements VersionHandler {
    private static Logger log = LoggerFactory.getLogger(WcsHandler.class);
    private Version version;
    private boolean deleteImmediately = true;

    public WcsHandler(String verString) {
        this.version = new Version(verString);
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public VersionHandler setDiskCache(DiskCache2 diskCache) {
        WcsCoverage.setDiskCache((DiskCache2)diskCache);
        return this;
    }

    @Override
    public VersionHandler setDeleteImmediately(boolean deleteImmediately) {
        this.deleteImmediately = deleteImmediately;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleKVP(HttpServlet servlet, HttpServletRequest req, HttpServletResponse res) throws IOException {
        block15: {
            WcsRequest request = null;
            try {
                URI serverURI = new URI(req.getRequestURL().toString());
                request = WcsRequestParser.parseRequest(this.getVersion().getVersionString(), serverURI, req, res);
                if (request.getOperation().equals((Object)Request.Operation.GetCapabilities)) {
                    res.setContentType(ContentType.xml.getContentHeader());
                    res.setStatus(200);
                    PrintWriter pw = res.getWriter();
                    ((GetCapabilities)request).writeCapabilitiesReport(pw);
                    pw.flush();
                    break block15;
                }
                if (request.getOperation().equals((Object)Request.Operation.DescribeCoverage)) {
                    res.setContentType(ContentType.xml.getContentHeader());
                    res.setStatus(200);
                    res.setCharacterEncoding("UTF-8");
                    PrintWriter pw = res.getWriter();
                    ((DescribeCoverage)request).writeDescribeCoverageDoc(pw);
                    pw.flush();
                    break block15;
                }
                if (!request.getOperation().equals((Object)Request.Operation.GetCoverage)) break block15;
                File covFile = ((GetCoverage)request).writeCoverageDataToFile();
                if (covFile != null && covFile.exists()) {
                    int pos = covFile.getPath().lastIndexOf(".");
                    String suffix = covFile.getPath().substring(pos);
                    String resultFilename = request.getDataset().getDatasetName();
                    if (!resultFilename.endsWith(suffix)) {
                        resultFilename = resultFilename + suffix;
                    }
                    res.setHeader("Content-Disposition", "attachment; filename=\"" + resultFilename + "\"");
                    ServletUtil.returnFile(servlet, "", covFile.getPath(), req, res, ((GetCoverage)request).getFormat().getMimeType());
                    if (this.deleteImmediately) {
                        covFile.delete();
                    }
                    break block15;
                }
                log.error("handleKVP(): Failed to create coverage file" + (covFile == null ? "" : ": " + covFile.getAbsolutePath()));
                throw new WcsException("Problem creating requested coverage.");
            }
            catch (WcsException e) {
                this.handleExceptionReport(res, e);
            }
            catch (URISyntaxException e) {
                this.handleExceptionReport(res, new WcsException("Bad URI: " + e.getMessage()));
            }
            catch (Throwable t) {
                log.error("Unknown problem.", t);
                this.handleExceptionReport(res, new WcsException("Unknown problem", t));
            }
            finally {
                if (request != null && request.getDataset() != null) {
                    request.getDataset().close();
                }
            }
        }
    }

    public GetCapabilities.ServiceInfo getServiceInfo() {
        GetCapabilities.ResponsibleParty.ContactInfo contactInfo = new GetCapabilities.ResponsibleParty.ContactInfo(Collections.singletonList("voice phone"), Collections.singletonList("voice phone"), new GetCapabilities.ResponsibleParty.Address(Collections.singletonList("address"), "city", "admin area", "postal code", "country", Collections.singletonList("email")), new GetCapabilities.ResponsibleParty.OnlineResource(null, "title"));
        GetCapabilities.ResponsibleParty respParty = new GetCapabilities.ResponsibleParty("indiv name", "org name", "position", contactInfo);
        GetCapabilities.ServiceInfo sid = new GetCapabilities.ServiceInfo("name", "label", "description", Collections.singletonList("keyword"), respParty, "no fees", Collections.singletonList("no access constraints"));
        return sid;
    }

    public void handleExceptionReport(HttpServletResponse res, WcsException exception) throws IOException {
        res.setContentType(ContentType.ogc_exception.getContentHeader());
        res.setStatus(400);
        ExceptionReport exceptionReport = new ExceptionReport(exception);
        PrintWriter pw = res.getWriter();
        exceptionReport.writeExceptionReport(pw);
        pw.flush();
    }

    @Override
    public void handleExceptionReport(HttpServletResponse res, String code, String locator, String message) throws IOException {
        WcsException exception;
        try {
            WcsException.Code c = WcsException.Code.valueOf((String)code);
            exception = new WcsException(c, locator, message);
        }
        catch (IllegalArgumentException e) {
            exception = new WcsException(message);
            log.debug("handleExceptionReport(): bad code given [" + code + "].");
        }
        this.handleExceptionReport(res, exception);
    }

    public void handleExceptionReport(HttpServletResponse res, String code, String locator, Throwable t) throws IOException {
        this.handleExceptionReport(res, code, locator, t.getMessage());
        if (t instanceof FileNotFoundException) {
            log.info("handleExceptionReport", (Object)t.getMessage());
        } else {
            log.info("handleExceptionReport", t);
        }
    }
}

