/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.net.URI;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.servlet.ModelAndView;
import thredds.server.catalogservice.LocalCatalogRequest;
import thredds.server.catalogservice.LocalCatalogRequestDataBinder;
import thredds.server.catalogservice.LocalCatalogRequestValidator;
import thredds.server.catalogservice.RemoteCatalogRequest;
import thredds.server.catalogservice.RemoteCatalogRequestDataBinder;
import thredds.server.catalogservice.RemoteCatalogRequestValidator;
import thredds.server.config.HtmlConfig;

public class CatalogServiceUtils {
    private CatalogServiceUtils() {
    }

    public static BindingResult bindAndValidateRemoteCatalogRequest(HttpServletRequest request) {
        RemoteCatalogRequest rcr = new RemoteCatalogRequest();
        RemoteCatalogRequestDataBinder db = new RemoteCatalogRequestDataBinder(rcr, "request");
        db.setAllowedFields(new String[]{"catalogUri", "command", "dataset", "verbose", "htmlView"});
        db.bind(request);
        BindingResult bindingResult = db.getBindingResult();
        ValidationUtils.invokeValidator((Validator)new RemoteCatalogRequestValidator(), (Object)bindingResult.getTarget(), (Errors)bindingResult);
        return bindingResult;
    }

    public static BindingResult bindAndValidateLocalCatalogRequest(HttpServletRequest request, boolean htmlView) {
        LocalCatalogRequest rcr = new LocalCatalogRequest();
        LocalCatalogRequestDataBinder db = new LocalCatalogRequestDataBinder(rcr, "request");
        db.setAllowedFields(new String[]{"path", "command", "dataset"});
        db.bind(request);
        BindingResult bindingResult = db.getBindingResult();
        LocalCatalogRequestValidator validator = new LocalCatalogRequestValidator();
        validator.setHtmlView(htmlView);
        ValidationUtils.invokeValidator((Validator)validator, (Object)bindingResult.getTarget(), (Errors)bindingResult);
        return bindingResult;
    }

    public static ModelAndView constructValidationMessageModelAndView(URI uri, String validationMessage, HtmlConfig htmlConfig) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("catalogUrl", uri);
        model.put("message", validationMessage);
        htmlConfig.addHtmlConfigInfoToModel(model);
        return new ModelAndView("/thredds/server/catalogservice/validationMessage", model);
    }

    public static ModelAndView constructValidationErrorModelAndView(URI uri, String validationMessage, HtmlConfig htmlConfig) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("catalogUrl", uri);
        model.put("message", validationMessage);
        htmlConfig.addHtmlConfigInfoToModel(model);
        return new ModelAndView("/thredds/server/catalogservice/validationError", model);
    }
}

