/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.gridaspoint.netcdf;

import java.io.IOException;
import java.util.List;
import thredds.server.ncss.view.gridaspoint.netcdf.CFPointWriterWrapper;
import thredds.server.ncss.view.gridaspoint.netcdf.CFStationCollectionWriterWrapper;
import thredds.server.ncss.view.gridaspoint.netcdf.CFTimeSeriesProfileCollectionWriterWrapper;
import thredds.server.ncss.view.gridaspoint.netcdf.PointCollectionNoTimeWriterWrapper;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.constants.CF;

public final class CFPointWriterWrapperFactory {
    private CFPointWriterWrapperFactory() {
    }

    public static CFPointWriterWrapper getWriterForFeatureType(NetcdfFileWriter.Version version, CF.FeatureType featureType, String filePath, List<Attribute> atts) throws IOException {
        if (featureType == CF.FeatureType.timeSeries) {
            return CFStationCollectionWriterWrapper.factory(version, filePath, atts);
        }
        if (featureType == CF.FeatureType.point) {
            return PointCollectionNoTimeWriterWrapper.createWrapper(version, filePath, atts);
        }
        if (featureType == CF.FeatureType.timeSeriesProfile) {
            return CFTimeSeriesProfileCollectionWriterWrapper.createWrapper(version, filePath, atts);
        }
        throw new UnsupportedOperationException("Unsupported FeatureType: " + featureType.name());
    }
}

