/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin;

import com.coverity.security.Escape;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.CollectionUpdater;
import thredds.monitor.FmrcCacheMonitorImpl;
import thredds.server.admin.DebugController;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.util.ContentType;
import thredds.util.TdsPathUtils;
import ucar.unidata.util.StringUtil2;

@Controller
@RequestMapping(value={"/admin"})
public class CollectionController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String PATH = "/admin/collection";
    private static final String COLLECTION = "collection";
    private static final String SHOW = "showStatus";
    private static final String TRIGGER = "trigger";
    @Autowired
    private TdsContext tdsContext;
    private static final String FMRC_PATH = "/admin/showFmrc";
    private static final String STATISTICS = "cacheStatistics.txt";
    private static final String CMD = "cmd";
    private static final String FILE = "file";
    private final FmrcCacheMonitorImpl monitor = new FmrcCacheMonitorImpl();

    @PostConstruct
    public void afterPropertiesSet() {
        DebugController.Category debugHandler = DebugController.find("Collections");
        DebugController.Action act = new DebugController.Action("showCollection", "Show Collections"){

            @Override
            public void doAction(DebugController.Event e) {
                List<InvDatasetFeatureCollection> fcList = DataRootHandler.getInstance().getFeatureCollections();
                Collections.sort(fcList, new Comparator<InvDatasetFeatureCollection>(){

                    @Override
                    public int compare(InvDatasetFeatureCollection o1, InvDatasetFeatureCollection o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (InvDatasetFeatureCollection fc : fcList) {
                    String uriParam = Escape.uriParam((String)fc.getCollectionName());
                    String url = CollectionController.this.tdsContext.getContextPath() + CollectionController.PATH + "?" + CollectionController.COLLECTION + "=" + uriParam;
                    e.pw.printf("<p/><a href='%s'>%s</a>%n", url, fc.getName());
                    FeatureCollectionConfig config = fc.getConfig();
                    if (config == null) continue;
                    e.pw.printf("%s%n", config.spec);
                }
                String url = CollectionController.this.tdsContext.getContextPath() + CollectionController.PATH + "/" + CollectionController.SHOW;
                e.pw.printf("<p/><a href='%s'>Show All Collection Status</a>%n", url);
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("sched", "Show scheduler"){

            @Override
            public void doAction(DebugController.Event e) {
                Scheduler scheduler = CollectionUpdater.INSTANCE.getScheduler();
                if (scheduler == null) {
                    return;
                }
                try {
                    e.pw.println(scheduler.getMetaData());
                    List groups = scheduler.getJobGroupNames();
                    List triggers = scheduler.getTriggerGroupNames();
                    for (String group : scheduler.getJobGroupNames()) {
                        e.pw.println("Group " + group);
                        for (JobKey jobKey : scheduler.getJobKeys(GroupMatcher.groupEquals((String)group))) {
                            e.pw.println("  Job " + jobKey.getName());
                            e.pw.println("    " + scheduler.getJobDetail(jobKey));
                        }
                        for (TriggerKey triggerKey : scheduler.getTriggerKeys(GroupMatcher.groupEquals((String)group))) {
                            e.pw.println("  Trigger " + triggerKey.getName());
                            e.pw.println("    " + scheduler.getTrigger(triggerKey));
                        }
                    }
                }
                catch (Exception e1) {
                    e.pw.println("Error on scheduler " + e1.getMessage());
                    CollectionController.this.log.error("Error on scheduler " + e1.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("showFmrcCache", "Show FMRC Cache"){

            @Override
            public void doAction(DebugController.Event e) {
                e.pw.println("<p>cache location = " + CollectionController.this.monitor.getCacheLocation() + "<p>");
                String statUrl = CollectionController.this.tdsContext.getContextPath() + CollectionController.FMRC_PATH + "/" + CollectionController.STATISTICS;
                e.pw.println("<p/> <a href='" + statUrl + "'>Show Cache Statistics</a>");
                for (String name : CollectionController.this.monitor.getCachedCollections()) {
                    String ename = StringUtil2.quoteHtmlContent((String)name);
                    String url = CollectionController.this.tdsContext.getContextPath() + CollectionController.FMRC_PATH + "?" + CollectionController.COLLECTION + "=" + ename;
                    e.pw.println("<p/> <a href='" + url + "'>" + name + "</a>");
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("syncFmrcCache", "Flush FMRC Cache to disk"){

            @Override
            public void doAction(DebugController.Event e) {
                CollectionController.this.monitor.sync();
                e.pw.println("<p>bdb cache location = " + CollectionController.this.monitor.getCacheLocation() + "<p> flushed to disk");
            }
        };
        debugHandler.addAction(act);
    }

    @RequestMapping(value={"/collection/showStatus"})
    protected ModelAndView handleCollectionStatus(HttpServletRequest req, HttpServletResponse res) throws Exception {
        res.setContentType(ContentType.html.getContentHeader());
        PrintWriter pw = res.getWriter();
        List<InvDatasetFeatureCollection> fcList = DataRootHandler.getInstance().getFeatureCollections();
        Collections.sort(fcList, new Comparator<InvDatasetFeatureCollection>(){

            @Override
            public int compare(InvDatasetFeatureCollection o1, InvDatasetFeatureCollection o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (InvDatasetFeatureCollection fc : fcList) {
            String uriParam = Escape.uriParam((String)fc.getCollectionName());
            String url = this.tdsContext.getContextPath() + PATH + "?" + COLLECTION + "=" + uriParam;
            pw.printf("<p/><a href='%s'>%s</a>%n", url, fc.getName());
            pw.printf("<pre>%s</pre>%n", fc.showStatusShort("txt"));
        }
        return null;
    }

    @RequestMapping(value={"/collection/showStatus.csv"})
    protected ModelAndView handleCollectionStatusCsv(HttpServletRequest req, HttpServletResponse res) throws Exception {
        res.setContentType(ContentType.csv.getContentHeader());
        PrintWriter pw = res.getWriter();
        List<InvDatasetFeatureCollection> fcList = DataRootHandler.getInstance().getFeatureCollections();
        Collections.sort(fcList, new Comparator<InvDatasetFeatureCollection>(){

            @Override
            public int compare(InvDatasetFeatureCollection o1, InvDatasetFeatureCollection o2) {
                int compareType = o1.getConfig().type.toString().compareTo(o1.getConfig().type.toString());
                if (compareType != 0) {
                    return compareType;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        pw.printf("%s, %s, %s, %s, %s, %s, %s, %s%n", COLLECTION, "type", "group", "nrecords", "ndups", "%", "nmiss", "%");
        for (InvDatasetFeatureCollection fc : fcList) {
            if (fc.getConfig().type != FeatureCollectionType.GRIB1 && fc.getConfig().type != FeatureCollectionType.GRIB2) continue;
            pw.printf("%s", fc.showStatusShort("csv"));
        }
        return null;
    }

    @RequestMapping(value={"/collection", "/collection/trigger"})
    protected ModelAndView handleCollectionTriggers(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String path = req.getServletPath();
        if (path == null) {
            path = "";
        }
        if (path.startsWith("/admin")) {
            path = path.substring("/admin".length(), path.length());
        }
        res.setContentType(ContentType.html.getContentHeader());
        PrintWriter pw = res.getWriter();
        CollectionUpdateType triggerType = null;
        if (path.equals("/collection/trigger")) {
            String triggerTypeS = req.getParameter(TRIGGER);
            try {
                triggerType = CollectionUpdateType.valueOf((String)triggerTypeS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (triggerType == null) {
                res.setStatus(400);
                pw.printf(" TRIGGER Type %s not legal%n", Escape.html((String)triggerTypeS));
                pw.flush();
                return null;
            }
        }
        String collectName = StringUtil2.unescape((String)req.getParameter(COLLECTION));
        InvDatasetFeatureCollection fc = DataRootHandler.getInstance().findFcByCollectionName(collectName);
        if (fc == null) {
            res.setStatus(404);
            pw.append("NOT FOUND");
            pw.flush();
            return null;
        }
        pw.printf("<h3>Collection %s</h3>%n", Escape.html((String)collectName));
        if (triggerType != null) {
            if (!fc.getConfig().isTrigggerOk()) {
                res.setStatus(403);
                pw.printf(" TRIGGER NOT ENABLED%n", new Object[0]);
                pw.flush();
                return null;
            }
            CollectionUpdater.INSTANCE.triggerUpdate(collectName, triggerType);
            pw.printf(" TRIGGER SENT%n", new Object[0]);
        } else {
            this.showFeatureCollection(pw, fc);
            String uriParam = Escape.uriParam((String)fc.getCollectionName());
            String url = this.tdsContext.getContextPath() + PATH + "/trigger?" + COLLECTION + "=" + uriParam + "&" + TRIGGER + "=" + CollectionUpdateType.nocheck;
            pw.printf("<p/><a href='%s'>Send trigger to %s</a>%n", url, Escape.html((String)fc.getName()));
        }
        pw.flush();
        return null;
    }

    private void showFeatureCollection(PrintWriter pw, InvDatasetFeatureCollection fc) {
        Formatter f;
        FeatureCollectionConfig config = fc.getConfig();
        if (config != null) {
            f = new Formatter();
            config.show(f);
            pw.printf("%n<pre>%s%n</pre>", f.toString());
        }
        f = new Formatter();
        fc.showStatus(f);
        pw.printf("%n<pre>%s%n</pre>", f.toString());
    }

    @RequestMapping(value={"/showFmrc", "/showFmrc/*"})
    protected ModelAndView showFmrcCache(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String path = TdsPathUtils.extractPath(req, "admin/");
        if (path.endsWith(STATISTICS)) {
            res.setContentType(ContentType.text.getContentHeader());
            Formatter f = new Formatter();
            this.monitor.getCacheStatistics(f);
            String s = f.toString();
            PrintWriter pw = res.getWriter();
            pw.println(s);
            pw.flush();
            return null;
        }
        String collectName = StringUtil2.unescape((String)req.getParameter(COLLECTION));
        String fileName = req.getParameter(FILE);
        String cmd = req.getParameter(CMD);
        if (fileName != null) {
            String ufilename = URLDecoder.decode(fileName, "UTF-8");
            String contents = this.monitor.getCachedFile(collectName, ufilename);
            if (null == contents) {
                res.setContentType(ContentType.html.getContentHeader());
                PrintWriter pw = res.getWriter();
                pw.println("<p/> Cant find filename=" + Escape.html((String)fileName) + " in collection = " + Escape.html((String)collectName));
            } else {
                res.setContentType(ContentType.xml.getContentHeader());
                PrintWriter pw = res.getWriter();
                pw.println(contents);
            }
            return null;
        }
        if (collectName != null) {
            String ecollectName = Escape.uriParam((String)collectName);
            String url = this.tdsContext.getContextPath() + FMRC_PATH + "?" + COLLECTION + "=" + ecollectName;
            res.setContentType(ContentType.html.getContentHeader());
            PrintWriter pw = res.getWriter();
            pw.println("Files for collection = " + Escape.html((String)collectName) + "");
            String deleteUrl = this.tdsContext.getContextPath() + FMRC_PATH + "?" + COLLECTION + "=" + ecollectName + "&" + CMD + "=delete";
            pw.println("<a href='" + deleteUrl + "'> Delete</a>");
            pw.println("<ol>");
            for (String filename : this.monitor.getFilesInCollection(collectName)) {
                String efileName = URLEncoder.encode(filename, "UTF-8");
                pw.println("<li> <a href='" + url + "&" + FILE + "=" + efileName + "'>" + filename + "</a>");
            }
            pw.println("</ol>");
        }
        if (cmd != null && cmd.equals("delete")) {
            res.setContentType(ContentType.html.getContentHeader());
            PrintWriter pw = res.getWriter();
            try {
                this.monitor.deleteCollection(collectName);
                pw.println("<p/>deleted");
            }
            catch (Exception e) {
                pw.println("<pre>delete failed on collection = " + Escape.html((String)collectName));
                e.printStackTrace(pw);
                pw.println("</pre>");
            }
        }
        return null;
    }
}

