/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import thredds.servlet.HtmlWriter;
import thredds.util.ContentType;
import ucar.nc2.constants.CDM;

@Controller
@RequestMapping(value={"/admin"}, method={RequestMethod.GET})
public class DebugController {
    private static List<Category> dhList = new ArrayList<Category>();

    @RequestMapping(value={"/debug", "/debug/*"})
    protected void showDebugPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(ContentType.html.getContentHeader());
        response.setHeader("Content-Description", "thredds_debug");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream((OutputStream)bos, false, "UTF-8");
        pw.println(HtmlWriter.getInstance().getHtmlDoctypeAndOpenTag());
        pw.println("<head>");
        pw.println("<title> THREDDS Debug</title>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
        pw.println(HtmlWriter.getInstance().getTdsPageCssLink());
        pw.println("</head>");
        pw.println("<body>");
        pw.println(HtmlWriter.getInstance().getOldStyleHeader());
        pw.println("<br><a href='content/logs/'>Show TDS Logs</a>");
        pw.println("<br><a href='content/tdm/'>Show TDM Logs</a>");
        pw.println("<br><a href='logs/'>Show Tomcat Logs</a>");
        pw.println("<h2>Debug Actions</h2>");
        pw.println("<pre>");
        String cmds = request.getQueryString();
        if (cmds == null || cmds.length() == 0) {
            this.showDebugActions(request, pw);
        } else {
            StringTokenizer tz = new StringTokenizer(cmds, ";");
            while (tz.hasMoreTokens()) {
                Category dh;
                String cmd = tz.nextToken();
                String target = null;
                pw.println("Cmd= " + cmd);
                int pos = cmd.indexOf(47);
                String dhName = "General";
                if (pos > 0) {
                    dhName = cmd.substring(0, pos);
                    cmd = cmd.substring(pos + 1);
                }
                if ((pos = cmd.indexOf(61)) >= 0) {
                    target = cmd.substring(pos + 1);
                    cmd = cmd.substring(0, pos);
                }
                if ((dh = DebugController.find(dhName)) == null) {
                    pw.println(" Unknown Debug Category=" + dhName + "=");
                    continue;
                }
                Action action = (Action)dh.actions.get(cmd);
                if (action == null) {
                    pw.println(" Unknown action=" + cmd + "=");
                    continue;
                }
                action.doAction(new Event(request, response, pw, bos, target));
            }
        }
        pw.println("</pre></body></html>");
        response.setStatus(200);
        PrintWriter responsePS = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), CDM.utf8Charset));
        responsePS.write(bos.toString("UTF-8"));
        responsePS.flush();
    }

    private void showDebugActions(HttpServletRequest req, PrintStream pw) {
        for (Category dh : dhList) {
            pw.println("<h2>" + dh.name + "</h2>");
            for (Action act : dh.actions.values()) {
                if (act.desc == null) continue;
                String url = req.getRequestURI() + "?" + dh.name + "/" + act.name;
                pw.println("   <a href='" + url + "'>" + act.desc + "</a>");
            }
        }
    }

    public static Category find(String name) {
        for (Category dh : dhList) {
            if (!dh.name.equals(name)) continue;
            return dh;
        }
        return new Category(name);
    }

    public static class Event {
        public HttpServletRequest req;
        public HttpServletResponse res;
        public PrintStream pw;
        public ByteArrayOutputStream bos;
        public String target;

        public Event(HttpServletRequest req, HttpServletResponse res, PrintStream pw, ByteArrayOutputStream bos, String target) {
            this.req = req;
            this.res = res;
            this.pw = pw;
            this.bos = bos;
            this.target = target;
        }
    }

    public static abstract class Action {
        public String name;
        public String desc;

        public Action(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public abstract void doAction(Event var1);
    }

    public static class Category {
        private Map<String, Action> actions = new LinkedHashMap<String, Action>();
        private String name;

        private Category(String name) {
            this.name = name;
            dhList.add(this);
        }

        public void addAction(Action act) {
            this.actions.put(act.name, act);
        }
    }
}

