/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.point;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.view.dsg.point.PointSubsetWriterCSV;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;

public class PointSubsetWriterGeoCsv
extends PointSubsetWriterCSV {
    private static final String GEOCSV_CONTAINER_TYPE = "GeoCSV 2.0";
    private static final String DELIMITER = ",";
    private static final String DEFAULT_MISSING_VALUE = "";
    private static final String UNKNOWN_UNIT = "unknown";
    private List<String> fieldNames = new ArrayList<String>();
    private List<String> fieldUnits = new ArrayList<String>();
    private List<String> fieldTypes = new ArrayList<String>();
    private List<String> fieldMissing = new ArrayList<String>();

    public PointSubsetWriterGeoCsv(FeatureDatasetPoint fdPoint, NcssParamsBean ncssParams, OutputStream out) throws NcssException, IOException {
        super(fdPoint, ncssParams, out);
    }

    private void appendMetadata(String name, String unit, String type) {
        this.appendMetadata(name, unit, type, DEFAULT_MISSING_VALUE);
    }

    private void appendMetadata(String name, String unit, String type, String missing) {
        this.fieldNames.add(name);
        this.fieldUnits.add(unit);
        this.fieldTypes.add(type);
        this.fieldMissing.add(missing);
    }

    @Override
    public void writeHeader(PointFeature pf) throws Exception {
        this.appendMetadata("time", "ISO_8601", "datetime");
        this.appendMetadata("latitude", "degrees_north", "double");
        this.appendMetadata("longitude", "degrees_east", "double");
        for (VariableSimpleIF wantedVar : this.wantedVariables) {
            String name = wantedVar.getShortName();
            String unit = UNKNOWN_UNIT;
            if (wantedVar.getUnitsString() != null) {
                unit = wantedVar.getUnitsString();
            }
            String type = wantedVar.getDataType().toString();
            Attribute missingAttr = wantedVar.findAttributeIgnoreCase("missing_value");
            String missing = missingAttr != null && !missingAttr.getStringValue().isEmpty() ? missingAttr.getStringValue() : DEFAULT_MISSING_VALUE;
            this.appendMetadata(name, unit, type, missing);
        }
        this.writer.print("# dataset: ".concat(GEOCSV_CONTAINER_TYPE));
        this.writer.println();
        this.writer.print("# delimiter: ".concat(DELIMITER));
        this.writer.println();
        this.writer.print("# field_unit: ".concat(StringUtils.join(this.fieldUnits, (String)DELIMITER)));
        this.writer.println();
        this.writer.print("# field_types: ".concat(StringUtils.join(this.fieldTypes, (String)DELIMITER)));
        this.writer.println();
        this.writer.print("# field_missing: ".concat(StringUtils.join(this.fieldMissing, (String)DELIMITER)));
        this.writer.println();
        this.writer.print(StringUtils.join(this.fieldNames, (String)DELIMITER));
        this.writer.println();
    }
}

