/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.dap4;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.servlet.DSPFactory;
import dap4.servlet.DapCache;
import dap4.servlet.DapController;
import dap4.servlet.DapRequest;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.server.dap4.ThreddsDSP;

@Controller
@RequestMapping(value={"/dap4"})
public class Dap4Controller
extends DapController {
    static final boolean DEBUG = false;
    static final boolean PARSEDEBUG = false;

    @RequestMapping(value={"**"})
    public void handleRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        super.handleRequest(req, res);
    }

    public Dap4Controller() {
        super("dap4");
    }

    protected void doFavicon(DapRequest drq, String icopath) throws IOException {
        throw new UnsupportedOperationException("Favicon");
    }

    protected void doCapabilities(DapRequest drq) throws IOException {
        this.addCommonHeaders(drq);
        OutputStream out = drq.getOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, DapUtil.UTF8));
        pw.println("Capabilities page not supported");
        pw.flush();
    }

    protected long getBinaryWriteLimit() {
        return 100000000L;
    }

    protected String getResourcePath(DapRequest drq, String relpath) throws IOException {
        URL realpathurl = this.servletcontext.getResource(relpath);
        String realpath = null;
        if (!realpathurl.getProtocol().equalsIgnoreCase("file")) {
            throw new DapException("Requested file not found " + realpathurl).setCode(404);
        }
        realpath = realpathurl.getPath();
        File dataset = new File(realpath);
        if (!dataset.exists()) {
            throw new DapException("Requested file does not exist: " + realpath).setCode(404);
        }
        if (!dataset.canRead()) {
            throw new DapException("Requested file not readable: " + realpath).setCode(403);
        }
        return realpath;
    }

    static {
        DapCache.setFactory((DSPFactory)new Dap4Factory());
    }

    static class Dap4Factory
    extends DSPFactory {
        public Dap4Factory() {
            this.registerDSP(ThreddsDSP.class, true);
        }
    }
}

