/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin;

import java.io.PrintStream;
import java.util.Formatter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import thredds.server.admin.DebugController;
import thredds.servlet.Debug;
import thredds.servlet.ServletUtil;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.unidata.io.RandomAccessFile;

public class DebugCommands {
    private String version;
    private String builddate;

    public DebugCommands() {
        this.makeGeneralActions();
        this.makeDebugActions();
        this.makeCacheActions();
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBuilddate(String builddate) {
        this.builddate = builddate;
    }

    protected void makeCacheActions() {
        DebugController.Category debugHandler = DebugController.find("Caches");
        DebugController.Action act = new DebugController.Action("showCaches", "Show All File Object Caches"){

            @Override
            public void doAction(DebugController.Event e) {
                Formatter f = new Formatter(e.pw);
                FileCacheIF fc = RandomAccessFile.getGlobalFileCache();
                if (fc == null) {
                    f.format("%nRandomAccessFile : turned off%n", new Object[0]);
                } else {
                    f.format("%n%n", new Object[0]);
                    fc.showCache(f);
                }
                fc = NetcdfDataset.getNetcdfFileCache();
                if (fc == null) {
                    f.format("NetcdfDatasetFileCache : turned off%n", new Object[0]);
                } else {
                    f.format("%n%n", new Object[0]);
                    fc.showCache(f);
                }
                fc = GribCdmIndex.gribCollectionCache;
                if (fc == null) {
                    f.format("%nTimePartitionCache : turned off%n", new Object[0]);
                } else {
                    f.format("%n%n", new Object[0]);
                    fc.showCache(f);
                }
                e.pw.flush();
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("clearCaches", "Clear All File Object Caches"){

            @Override
            public void doAction(DebugController.Event e) {
                NetcdfDataset.getNetcdfFileCache().clearCache(false);
                RandomAccessFile.getGlobalFileCache().clearCache(false);
                FileCacheIF fc = GribCdmIndex.gribCollectionCache;
                if (fc != null) {
                    fc.clearCache(false);
                }
                e.pw.println("  ClearCache ok");
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("disableRAFCache", "Disable RandomAccessFile Cache"){

            @Override
            public void doAction(DebugController.Event e) {
                RandomAccessFile.getGlobalFileCache().disable();
                e.pw.println("  Disable RandomAccessFile Cache ok");
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("forceRAFCache", "Force clear RandomAccessFile Cache"){

            @Override
            public void doAction(DebugController.Event e) {
                RandomAccessFile.getGlobalFileCache().clearCache(true);
                e.pw.println("  RandomAccessFile force clearCache done");
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("disableNetcdfCache", "Disable NetcdfDatasetFile Cache"){

            @Override
            public void doAction(DebugController.Event e) {
                NetcdfDataset.disableNetcdfFileCache();
                e.pw.println("  Disable NetcdfFile Cache ok");
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("forceNCCache", "Force clear NetcdfDatasetFile Cache"){

            @Override
            public void doAction(DebugController.Event e) {
                NetcdfDataset.getNetcdfFileCache().clearCache(true);
                e.pw.println("  NetcdfFileCache force clearCache done");
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("disableTimePartitionCache", "Disable TimePartition Cache"){

            @Override
            public void doAction(DebugController.Event e) {
                GribCdmIndex.disableGribCollectionCache();
                e.pw.println("  Disable gribCollectionCache ok");
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("forceGCCache", "Force clear TimePartition Cache"){

            @Override
            public void doAction(DebugController.Event e) {
                FileCacheIF fc = GribCdmIndex.gribCollectionCache;
                if (fc != null) {
                    fc.clearCache(true);
                }
                e.pw.println("  gribCollectionCache force clearCache done");
            }
        };
        debugHandler.addAction(act);
    }

    protected void makeDebugActions() {
        DebugController.Category debugHandler = DebugController.find("Debug");
        DebugController.Action act = new DebugController.Action("enableRafHandles", "Toggle tracking open RAF"){

            @Override
            public void doAction(DebugController.Event e) {
                try {
                    RandomAccessFile.setDebugLeaks((!RandomAccessFile.getDebugLeaks() ? 1 : 0) != 0);
                    e.pw.println("  Tracking RAF=" + RandomAccessFile.getDebugLeaks());
                }
                catch (Exception ioe) {
                    e.pw.println(ioe.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("showRafHandles", "Show open RAF"){

            @Override
            public void doAction(DebugController.Event e) {
                try {
                    List names = RandomAccessFile.getOpenFiles();
                    e.pw.println("count=" + names.size());
                    for (String s : names) {
                        e.pw.println("  " + s);
                    }
                }
                catch (Exception ioe) {
                    e.pw.println(ioe.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
    }

    protected void makeGeneralActions() {
        DebugController.Category debugHandler = DebugController.find("General");
        DebugController.Action act = new DebugController.Action("showVersion", "Show Build Version"){

            @Override
            public void doAction(DebugController.Event e) {
                try {
                    e.pw.println("version= " + DebugCommands.this.version);
                    e.pw.println("build date= " + DebugCommands.this.builddate);
                }
                catch (Exception ioe) {
                    e.pw.println(ioe.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("showRuntime", "Show Runtime info"){

            @Override
            public void doAction(DebugController.Event e) {
                Runtime runt = Runtime.getRuntime();
                double scale = 1.0E-6;
                e.pw.println(" freeMemory= " + scale * (double)runt.freeMemory() + " Mb");
                e.pw.println(" totalMemory= " + scale * (double)runt.totalMemory() + " Mb");
                e.pw.println(" maxMemory= " + scale * (double)runt.maxMemory() + " Mb");
                e.pw.println(" availableProcessors= " + runt.availableProcessors());
                e.pw.println();
                ServletUtil.showThreads(e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("showFlags", "Show Debugging Flags"){

            @Override
            public void doAction(DebugController.Event e) {
                DebugCommands.this.showFlags(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("toggleFlag", null){

            @Override
            public void doAction(DebugController.Event e) {
                if (e.target != null) {
                    String flag;
                    Debug.set(flag, !Debug.isSet(flag = e.target));
                } else {
                    e.pw.println(" Must be toggleFlag=<flagName>");
                }
                DebugCommands.this.showFlags(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("showRequest", "Show HTTP Request info"){

            @Override
            public void doAction(DebugController.Event e) {
                e.pw.println(ServletUtil.showRequestDetail(null, e.req));
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("showSystemProperties", "Show Server info"){

            @Override
            public void doAction(DebugController.Event e) {
                ServletUtil.showServerInfo(e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("showSession", "Show HTTP Session info"){

            @Override
            public void doAction(DebugController.Event e) {
                ServletUtil.showSession(e.req, e.res, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("showSecurity", "Show Security info"){

            @Override
            public void doAction(DebugController.Event e) {
                e.pw.println(ServletUtil.showSecurity(e.req, "admin"));
            }
        };
        debugHandler.addAction(act);
    }

    void showFlags(HttpServletRequest req, PrintStream pw) {
        for (String key : Debug.keySet()) {
            String url = req.getRequestURI() + "?toggleFlag=" + key;
            pw.println("  <a href='" + url + "'>" + key + " = " + Debug.isSet(key) + "</a>");
        }
    }
}

