/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import thredds.server.ncss.exception.NcssException;

public class AbstractNcssController {
    protected static final String servletPath = "/ncss/";
    protected static final String servletPathGrid = "/ncss/grid/";
    protected static final String servletCachePath = "/cache/ncss";
    private static final Logger logger = LoggerFactory.getLogger(AbstractNcssController.class);
    private static final String[] endings = new String[]{"/dataset.xml", "/dataset.html", "/pointDataset.html", "/pointDataset.xml", "/datasetBoundaries.xml", "/station.xml"};

    protected void handleValidationErrorsResponse(HttpServletResponse response, int status, BindingResult validationResult) {
        List errors = validationResult.getAllErrors();
        response.setStatus(status);
        StringBuilder responseStr = new StringBuilder();
        responseStr.append("Validation errors: ");
        for (ObjectError err : errors) {
            responseStr.append(err.getDefaultMessage());
            responseStr.append("  -- ");
        }
        try {
            PrintWriter pw = response.getWriter();
            pw.write(responseStr.toString());
            pw.flush();
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
        }
    }

    protected void handleValidationErrorMessage(HttpServletResponse response, int status, String errorMessage) {
        response.setStatus(status);
        try {
            PrintWriter pw = response.getWriter();
            pw.write(errorMessage);
            pw.flush();
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
        }
    }

    @ExceptionHandler(value={NcssException.class})
    public ResponseEntity<String> handle(NcssException e) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)e.getMessage(), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={FileNotFoundException.class})
    public ResponseEntity<String> handle(FileNotFoundException e) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)e.getMessage(), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    public ResponseEntity<String> handle(UnsupportedOperationException e) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)e.getMessage(), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<String> handle(Throwable t) {
        logger.error("Uncaught exception", t);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)t.getMessage(), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static String getNCSSServletPath() {
        return servletPath;
    }

    public static String getServletCachePath() {
        return servletCachePath;
    }

    public static String getDatasetPath(HttpServletRequest req) {
        return AbstractNcssController.getDatasetPath(req.getServletPath());
    }

    public static String getDatasetPath(String path) {
        if (path.startsWith(servletPathGrid)) {
            path = path.substring(servletPathGrid.length());
        } else if (path.startsWith(servletPath)) {
            path = path.substring(servletPath.length());
        }
        for (String ending : endings) {
            if (!path.endsWith(ending)) continue;
            int len = path.length() - ending.length();
            path = path.substring(0, len);
            break;
        }
        return path;
    }
}

