/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.gridaspoint;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import thredds.server.ncss.view.gridaspoint.CSVPointDataWriter;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.unidata.geoloc.vertical.VerticalTransform;

public class GeoCsvWriter
extends CSVPointDataWriter {
    private static final String GEOCSV_CONTAINER_TYPE = "GeoCSV 2.0";
    private static final String DELIMITER = ",";
    private static final String DEFAULT_MISSING_VALUE = "";
    private static final String UNKNOWN_UNIT = "unknown";
    private List<String> fieldNames = new ArrayList<String>();
    private List<String> fieldUnits = new ArrayList<String>();
    private List<String> fieldTypes = new ArrayList<String>();
    private List<String> fieldMissing = new ArrayList<String>();

    protected GeoCsvWriter(OutputStream os) {
        super(os);
    }

    public static GeoCsvWriter factory(OutputStream os) {
        return new GeoCsvWriter(os);
    }

    private void appendMetadata(String name, String unit, String type) {
        this.appendMetadata(name, unit, type, DEFAULT_MISSING_VALUE);
    }

    private void appendMetadata(String name, String unit, String type, String missing) {
        this.fieldNames.add(name);
        this.fieldUnits.add(unit);
        this.fieldTypes.add(type);
        this.fieldMissing.add(missing);
    }

    @Override
    protected void writeGroupHeader(List<String> varGroup, GridDataset gridDataset, boolean hasEnsAxis, boolean hasTimeAxis) {
        VerticalTransform vt;
        GridCoordSystem coordSystem;
        CoordinateAxis1D zAxis;
        if (hasTimeAxis) {
            this.appendMetadata("time", "ISO_8601", "datetime");
        }
        this.appendMetadata("latitude", "degrees_north", "double");
        this.appendMetadata("longitude", "degrees_east", "double");
        if (hasEnsAxis) {
            this.appendMetadata("ensMember", "unitless", "double");
        }
        if ((zAxis = (coordSystem = gridDataset.findGridDatatype(varGroup.get(0)).getCoordinateSystem()).getVerticalAxis()) != null) {
            this.appendMetadata("vertCoord,", zAxis.getUnitsString(), zAxis.getDataType().toString(), DEFAULT_MISSING_VALUE);
        }
        if ((vt = coordSystem.getVerticalTransform()) != null) {
            String ft = UNKNOWN_UNIT;
            try {
                ft = vt.getCoordinateArray(0).getDataType().toString();
            }
            catch (IOException iOException) {
            }
            catch (InvalidRangeException invalidRangeException) {
                // empty catch block
            }
            this.appendMetadata("vertCoord", vt.getUnitString(), ft, DEFAULT_MISSING_VALUE);
        }
        Iterator<String> it = varGroup.iterator();
        while (it.hasNext()) {
            GridDatatype grid = gridDataset.findGridDatatype(it.next());
            String name = grid.getName();
            String unit = UNKNOWN_UNIT;
            if (grid.getUnitsString() != null) {
                unit = grid.getUnitsString();
            }
            String type = grid.getDataType().toString();
            String missing = DEFAULT_MISSING_VALUE;
            if (grid.hasMissingData()) {
                missing = grid.findAttributeIgnoreCase("missing_value").getStringValue();
            }
            this.appendMetadata(name, unit, type, missing);
        }
        this.printWriter.print("# dataset: ".concat(GEOCSV_CONTAINER_TYPE));
        this.printWriter.println();
        this.printWriter.print("# delimiter: ".concat(DELIMITER));
        this.printWriter.println();
        this.printWriter.print("# field_unit: ".concat(StringUtils.join(this.fieldUnits, (String)DELIMITER)));
        this.printWriter.println();
        this.printWriter.print("# field_types: ".concat(StringUtils.join(this.fieldTypes, (String)DELIMITER)));
        this.printWriter.println();
        this.printWriter.print("# field_missing: ".concat(StringUtils.join(this.fieldMissing, (String)DELIMITER)));
        this.printWriter.println();
        this.printWriter.print(StringUtils.join(this.fieldNames, (String)DELIMITER));
        this.printWriter.println();
    }
}

