/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.point;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.controller.NcssController;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.util.NcssRequestUtils;
import thredds.server.ncss.view.dsg.point.AbstractPointSubsetWriter;
import thredds.util.ContentType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.ft.point.writer.WriterCFPointCollection;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;

public class PointSubsetWriterNetcdf
extends AbstractPointSubsetWriter {
    private final OutputStream out;
    private final NetcdfFileWriter.Version version;
    private final File netcdfResult;
    private final WriterCFPointCollection cfWriter;

    public PointSubsetWriterNetcdf(FeatureDatasetPoint fdPoint, NcssParamsBean ncssParams, DiskCache2 diskCache, OutputStream out, NetcdfFileWriter.Version version) throws NcssException, IOException {
        super(fdPoint, ncssParams);
        this.out = out;
        this.version = version;
        this.netcdfResult = diskCache.createUniqueFile("ncss-point", ".nc");
        ArrayList<Attribute> attribs = new ArrayList<Attribute>();
        attribs.add(new Attribute("title", "Extracted data from TDS Feature Collection " + fdPoint.getLocation()));
        DateUnit timeUnit = DateUnit.factory((String)"seconds since 1970-01-01");
        String altUnit = null;
        if (fdPoint.getNetcdfFile() instanceof NetcdfDataset) {
            CoordinateAxis altAxis;
            NetcdfDataset dataset = (NetcdfDataset)fdPoint.getNetcdfFile();
            CoordinateAxis timeAxis = dataset.findCoordinateAxis(AxisType.Time);
            if (timeAxis != null && timeAxis.getUnitsString() != null) {
                timeUnit = DateUnit.factory((String)timeAxis.getUnitsString());
            }
            if ((altAxis = dataset.findCoordinateAxis(AxisType.Height)) != null) {
                altUnit = altAxis.getUnitsString();
            }
        }
        this.cfWriter = new WriterCFPointCollection(this.netcdfResult.getAbsolutePath(), attribs, this.wantedVariables, null, timeUnit, altUnit, new CFPointWriterConfig(version));
    }

    @Override
    public HttpHeaders getHttpHeaders(String datasetPath, boolean isStream) {
        HttpHeaders httpHeaders = new HttpHeaders();
        String fileName = NcssRequestUtils.getFileNameForResponse(datasetPath, this.version);
        String url = NcssRequestUtils.getTdsContext().getContextPath() + NcssController.getServletCachePath() + "/" + fileName;
        if (this.version == NetcdfFileWriter.Version.netcdf3) {
            httpHeaders.set("Content-Type", ContentType.netcdf.getContentHeader());
        } else if (this.version == NetcdfFileWriter.Version.netcdf4 || this.version == NetcdfFileWriter.Version.netcdf4_classic) {
            httpHeaders.set("Content-Type", ContentType.netcdf4.getContentHeader());
        }
        httpHeaders.set("Content-Location", url);
        httpHeaders.set("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        return httpHeaders;
    }

    @Override
    public void writeHeader(PointFeature pf) throws Exception {
        this.cfWriter.writeHeader(pf);
    }

    @Override
    public void writePoint(PointFeature pointFeat) throws Exception {
        this.cfWriter.writeRecord(pointFeat, pointFeat.getDataAll());
    }

    @Override
    public void writeFooter() throws Exception {
        this.cfWriter.finish();
        IO.copyFileB((File)this.netcdfResult, (OutputStream)this.out, (int)60000);
        this.out.flush();
    }
}

