/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.radarServer.RadarDayCollection;
import thredds.server.radarServer.RadarStationCollection;

public class RadarDatasetCollection {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final Pattern p_yyyymmdd_hhmm = Pattern.compile("\\d{8}_(\\d{4})");
    public static boolean debug = false;
    String tdir;
    boolean stnTime = true;
    boolean stnProduct = false;
    String product = null;
    boolean standardName = true;
    boolean caseStudy = false;
    String inbetween = null;
    HashMap<String, ArrayList<String>> yyyymmdd = new HashMap();
    HashMap<String, ArrayList<String>> hhmm = new HashMap();
    private static int daysToRead = 6;
    private final SimpleDateFormat dateFormat;

    public int getDaysToRead() {
        return daysToRead;
    }

    public void setDaysToRead(int daysToRead) {
        RadarDatasetCollection.daysToRead = daysToRead;
    }

    public RadarDatasetCollection(String tdir, String product) {
        this.caseStudy = tdir.contains("casestudies");
        StringBuffer sb = new StringBuffer(tdir);
        this.product = product;
        this.tdir = this.stnTime ? (product == null ? tdir : sb.append("/").append(product).toString()) : (product == null ? tdir : sb.append("/").append(product).append("/").toString());
        File dir = new File(this.tdir);
        if (!this.caseStudy && dir.exists() && dir.isDirectory()) {
            String[] children;
            ArrayList<String> rdc = new ArrayList<String>();
            sb.setLength(0);
            sb.append("In directory ").append(dir.getParent()).append("/").append(dir.getName());
            this.log.debug(sb.toString());
            for (String child : children = dir.list()) {
                if (!child.startsWith(".2")) continue;
                rdc.add(child);
            }
            Collections.sort(rdc, new CompareKeyDescend());
            for (int i = 0; i < rdc.size() && i < daysToRead; ++i) {
                this.readRadarDayCollection((String)rdc.get(i));
            }
        } else {
            this.tdir = tdir;
            ArrayList<String> stations = this.getStationsFromDir(tdir);
            for (String stn : stations) {
                String[] children;
                sb.setLength(0);
                dir = new File(sb.append(tdir).append("/").append(stn).toString());
                if (!dir.exists() || !dir.isDirectory()) continue;
                File pdir = null;
                if (product != null) {
                    pdir = new File(sb.append("/").append(product).toString());
                } else {
                    File btwn;
                    pdir = new File(sb.toString());
                    children = pdir.list();
                    if (children.length > 0 && (btwn = new File(sb.append("/").append(children[0]).toString())).exists() && btwn.isDirectory()) {
                        pdir = btwn;
                        this.inbetween = btwn.getName() + "/";
                    }
                }
                if (!pdir.exists() || !pdir.isDirectory()) continue;
                children = pdir.list();
                ArrayList<String> times = new ArrayList<String>();
                for (String child : children) {
                    if (child.startsWith(".")) continue;
                    if (this.inbetween != null) {
                        sb.setLength(0);
                        sb.append(this.inbetween).append(child);
                        times.add(sb.toString());
                        continue;
                    }
                    times.add(child);
                }
                ArrayList<String> days = this.yyyymmdd.get(stn);
                if (days == null) {
                    days = new ArrayList();
                }
                days.add("all");
                this.yyyymmdd.put(stn, days);
                sb.setLength(0);
                sb.append(stn).append("all");
                Collections.sort(times, new CompareKeyDescend());
                this.hhmm.put(sb.toString(), times);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("RadarDayCollections {} added stn={} days={} hours={}", new Object[]{tdir, stn, days.size(), times.size()});
            }
        }
        this.dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private ArrayList<String> getStationsFromDir(String stnDir) {
        ArrayList<String> stations = new ArrayList<String>();
        File dir = new File(stnDir);
        if (dir.exists() && dir.isDirectory()) {
            String[] children;
            this.log.debug("In directory " + dir.getParent() + "/" + dir.getName());
            for (String aChild : children = dir.list()) {
                File child = new File(dir, aChild);
                if (!child.isDirectory()) continue;
                stations.add(aChild);
            }
        } else {
            return null;
        }
        return stations;
    }

    private Boolean readRadarDayCollection(String child) {
        StringBuffer sb = new StringBuffer(this.tdir);
        sb.append("/").append(child);
        RadarDayCollection dayCollection = new RadarDayCollection().read(sb.toString());
        if (dayCollection == null) {
            return false;
        }
        this.standardName = dayCollection.standardName;
        Set<String> stations = dayCollection.getStations();
        for (String station : stations) {
            ArrayList<String> days = this.yyyymmdd.get(station);
            if (days == null) {
                days = new ArrayList();
            }
            days.add(dayCollection.yyyymmdd);
            this.yyyymmdd.put(station, days);
            sb.setLength(0);
            sb.append(station).append(dayCollection.yyyymmdd);
            this.hhmm.put(sb.toString(), dayCollection.getTimes(station));
        }
        return true;
    }

    public boolean previousDayNowAvailable() {
        if (this.caseStudy) {
            return false;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.add(5, -1);
        Date now = cal.getTime();
        String previousDay = this.dateFormat.format(now);
        StringBuffer sb = new StringBuffer();
        Set<String> stations = this.yyyymmdd.keySet();
        int count = 0;
        for (String station : stations) {
            if (++count == 10) {
                return false;
            }
            ArrayList<String> days = this.yyyymmdd.get(station);
            if (previousDay.equals(days.get(0))) {
                return false;
            }
            sb.setLength(0);
            sb.append(this.tdir).append("/").append('.').append(previousDay);
            File dir = new File(sb.toString());
            if (!dir.exists()) continue;
            return true;
        }
        return false;
    }

    public boolean getStationTimes(RadarStationCollection rsc, String currentDay) {
        ArrayList<String> dal;
        StringBuffer sb = new StringBuffer(this.tdir);
        sb.append("/").append(rsc.stnName).append("/").append(currentDay);
        File dir = new File(sb.toString());
        if (dir.exists() && dir.isDirectory()) {
            sb.insert(0, "In directory ");
            this.log.debug(sb.toString());
            ArrayList<String> currenthhmm = new ArrayList<String>();
            String[] children = dir.list();
            for (String child : children) {
                Matcher m;
                if (child.startsWith(".") || !(m = p_yyyymmdd_hhmm.matcher(child)).find()) continue;
                if (this.standardName) {
                    currenthhmm.add(m.group(1));
                    continue;
                }
                currenthhmm.add(child);
            }
            if (currenthhmm.size() > 0) {
                Collections.sort(currenthhmm, new CompareKeyDescend());
                rsc.yyyymmdd.add(currentDay);
                rsc.hhmm.put(currentDay, currenthhmm);
            }
            if (this.log.isDebugEnabled()) {
                for (String hm : currenthhmm) {
                    sb.setLength(0);
                    sb.append(currentDay).append("_").append(hm);
                    this.log.debug(sb.toString());
                }
            }
        }
        if ((dal = this.yyyymmdd.get(rsc.stnName)) == null) {
            return false;
        }
        Collections.sort(dal, new CompareKeyDescend());
        rsc.yyyymmdd.addAll(dal);
        for (String day : dal) {
            sb.setLength(0);
            sb.append(rsc.stnName).append(day);
            ArrayList<String> tal = this.hhmm.get(sb.toString());
            rsc.hhmm.put(day, tal);
            if (!this.log.isDebugEnabled()) continue;
            for (String hm : tal) {
                sb.setLength(0);
                sb.append(day).append("_").append(hm);
                this.log.debug(sb.toString());
            }
        }
        return true;
    }

    public RadarStationCollection queryStation(String stnName, String currentDay) {
        RadarStationCollection rsc = new RadarStationCollection(this.tdir, stnName, this.stnTime, this.product);
        if (this.getStationTimes(rsc, currentDay)) {
            return rsc;
        }
        return null;
    }

    public RadarStationCollection queryStation(String dir, String stnName, String product, String currentDay) {
        RadarStationCollection rsc = new RadarStationCollection(dir, stnName, this.stnTime, product);
        this.getStationTimes(rsc, currentDay);
        return rsc;
    }

    public String getTdir() {
        return this.tdir;
    }

    public boolean isStnTime() {
        return this.stnTime;
    }

    public boolean isStnProduct() {
        return this.stnProduct;
    }

    public String getProduct() {
        return this.product;
    }

    public boolean isStandardName() {
        return this.standardName;
    }

    public HashMap<String, ArrayList<String>> getYyyymmdd() {
        return this.yyyymmdd;
    }

    public boolean isCaseStudy() {
        return this.caseStudy;
    }

    public HashMap<String, ArrayList<String>> getHhmm() {
        return this.hhmm;
    }

    protected static class CompareKeyDescend
    implements Comparator<String> {
        protected CompareKeyDescend() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s2.compareTo(s1);
        }
    }
}

