/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.XSLTransformer;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.ThreddsMetadata;
import thredds.server.radarServer.RadarMethods;
import thredds.server.radarServer.ServerMethods;
import thredds.servlet.AbstractServlet;
import thredds.servlet.HtmlWriter;
import thredds.servlet.ServletUtil;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.StringUtil2;

public class RadarServer
extends AbstractServlet {
    public static InvCatalogImpl cat;
    public static final String catName = "radarCollections.xml";
    public static URI catURI;
    public static List datasets;
    public static HashMap<String, String> dataLocation;
    public static RadarMethods rm;
    private boolean allow = false;
    private boolean debug = false;

    protected long getLastModified(HttpServletRequest req) {
        this.contentPath = ServletUtil.getContentPath();
        File file = new File(this.contentPath + this.getPath() + catName);
        return file.lastModified();
    }

    @Override
    protected String getPath() {
        return "servers/";
    }

    @Override
    public void init() throws ServletException {
        super.init();
        this.contentPath = ServletUtil.getContentPath();
        rm = new RadarMethods(this.contentPath, this.logServerStartup);
        InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)false);
        cat = this.readCatalog(factory, this.getPath() + catName, this.contentPath + this.getPath() + catName);
        if (cat == null) {
            this.logServerStartup.info("cat initialization failed");
            return;
        }
        cat.setBaseURI(catURI);
        List parents = cat.getDatasets();
        for (int i = 0; i < parents.size(); ++i) {
            InvDataset top = (InvDataset)parents.get(i);
            datasets = top.getDatasets();
            for (int j = 0; j < datasets.size(); ++j) {
                InvDatasetScan ds = (InvDatasetScan)datasets.get(j);
                if (ds.getPath() != null) {
                    dataLocation.put(ds.getPath(), ds.getScanLocation());
                    this.logServerStartup.info("path =" + ds.getPath() + " location =" + ds.getScanLocation());
                }
                ds.setXlinkHref(ds.getPath() + "/dataset.xml");
            }
        }
        this.logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization complete ");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block23: {
            PrintWriter pw = null;
            try {
                long startms;
                block25: {
                    block24: {
                        startms = System.currentTimeMillis();
                        if (cat == null) break block24;
                        if (RadarMethods.nexradList != null) break block25;
                    }
                    res.sendError(500, "radarServer Radar Station/Catalog initialization problem");
                    return;
                }
                String pathInfo = req.getPathInfo();
                if (pathInfo == null) {
                    pathInfo = "";
                }
                RadarType radarType = RadarType.nexrad;
                if (pathInfo.indexOf(47, 1) > 1) {
                    String rt = pathInfo.substring(1, pathInfo.indexOf(47, 1));
                    radarType = RadarType.valueOf(rt);
                }
                if (!pathInfo.endsWith("html")) {
                    pw = res.getWriter();
                    res.setContentType("text/xml; charset=iso-8859-1");
                }
                if (req.getQueryString() != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("<documentation>\n" + req.getQueryString() + "</documentation>\n");
                    }
                    rm.radarQuery(radarType, req, res, pw);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("after doGet " + (System.currentTimeMillis() - startms));
                    }
                    pw.flush();
                    return;
                }
                if (pathInfo.startsWith("/catalog.xml") || pathInfo.startsWith("/dataset.xml")) {
                    InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)false);
                    String catAsString = factory.writeXML(cat);
                    pw.println(catAsString);
                    res.setStatus(200);
                    pw.flush();
                    return;
                }
                if (pathInfo.startsWith("/catalog.html") || pathInfo.startsWith("/dataset.html")) {
                    try {
                        int factory = HtmlWriter.getInstance().writeCatalog(req, res, cat, true);
                    }
                    catch (Exception e) {
                        this.log.error("Radar HtmlWriter failed ", (Throwable)e);
                        res.sendError(500, "radarServer HtmlWriter error " + pathInfo);
                        return;
                    }
                    return;
                }
                if (pathInfo.contains("level2/catalog.") || pathInfo.contains("level3/catalog.") || pathInfo.contains("level2/dataset.") || pathInfo.contains("level3/dataset.")) {
                    this.level2level3catalog(radarType, pathInfo, pw, req, res);
                    return;
                }
                if (pathInfo.endsWith("stations.xml")) {
                    pathInfo = pathInfo.replace("/stations.xml", "");
                    Element rootElem = new Element("stationsList");
                    Document doc = new Document(rootElem);
                    doc = rm.stationsXML(radarType, doc, rootElem, pathInfo.substring(1));
                    XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                    pw.println(fmt.outputString(doc));
                    pw.flush();
                    return;
                }
                if (pathInfo.endsWith("dataset.xml") || pathInfo.endsWith("catalog.xml")) {
                    this.datasetInfoXml(radarType, pathInfo, pw);
                    return;
                }
                if (pathInfo.endsWith("dataset.html") || pathInfo.endsWith("catalog.html")) {
                    this.datasetInfoHtml(radarType, pathInfo, pw, res);
                    return;
                }
                res.sendError(404);
            }
            catch (FileNotFoundException e) {
                if (!res.isCommitted()) {
                    res.sendError(404);
                }
            }
            catch (Throwable e) {
                this.log.error("RadarServer.doGet failed", e);
                if (res.isCommitted()) break block23;
                res.sendError(500);
            }
        }
    }

    private void level2level3catalog(RadarType radarType, String pathInfo, PrintWriter pw, HttpServletRequest req, HttpServletResponse res) throws IOException {
        block8: {
            try {
                String type = pathInfo.contains("level2") ? radarType.toString() + "/level2" : radarType.toString() + "/level3";
                ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
                InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)false);
                factory.writeXML(cat, (OutputStream)os, true);
                InvCatalogImpl tCat = factory.readXML((InputStream)new ByteArrayInputStream(os.toByteArray()), catURI);
                Iterator parents = tCat.getDatasets().iterator();
                while (parents.hasNext()) {
                    ArrayList<InvDatasetImpl> delete = new ArrayList<InvDatasetImpl>();
                    InvDatasetImpl top = (InvDatasetImpl)parents.next();
                    for (InvDatasetImpl ds : top.getDatasets()) {
                        InvDatasetScan ids;
                        if (!(ds instanceof InvDatasetScan) || (ids = (InvDatasetScan)ds).getPath() == null) continue;
                        if (ids.getPath().contains(type)) {
                            ids.setXlinkHref(ids.getPath() + "/dataset.xml");
                            continue;
                        }
                        delete.add(ds);
                    }
                    for (InvDatasetImpl idi : delete) {
                        top.removeDataset(idi);
                    }
                }
                if (pathInfo.endsWith("xml")) {
                    String catAsString = factory.writeXML(tCat);
                    pw.println(catAsString);
                    pw.flush();
                } else {
                    HtmlWriter.getInstance().writeCatalog(req, res, tCat, true);
                }
            }
            catch (Throwable e) {
                this.log.error("RadarServer.level2level3catalog failed", e);
                if (res.isCommitted()) break block8;
                res.sendError(500);
            }
        }
    }

    private void datasetInfoXml(RadarType radarType, String pathInfo, PrintWriter pw) throws IOException {
        try {
            pw.println("<catalog xmlns=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"Radar Data\" version=\"1.0.1\">\n");
            pw.println("  <service name=\"radarServer\" base=\"/thredds/radarServer/\" serviceType=\"DQC\" />\n");
            pathInfo = pathInfo.replace("/dataset.xml", "");
            pathInfo = pathInfo.replace("/catalog.xml", "");
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            for (int i = 0; i < datasets.size(); ++i) {
                InvDatasetScan ds = (InvDatasetScan)datasets.get(i);
                if (!pathInfo.equals(ds.getPath())) continue;
                pw.println("  <dataset ID=\"" + ds.getID() + "\" serviceName=\"radarServer\">");
                pw.println("    <urlpath>" + ds.getPath() + "</urlpath>");
                pw.println("    <dataType>" + ds.getDataType() + "</dataType>");
                pw.println("    <dataFormat>" + ds.getDataFormatType() + "</dataFormat>");
                pw.println("   <serviceName>radarServer</serviceName>");
                pw.println("    <metadata inherited=\"true\">");
                pw.println("    <documentation type=\"summary\">" + ds.getSummary() + "</documentation>");
                CalendarDateRange dr = ds.getCalendarDateCoverage();
                pw.println("      <TimeSpan>");
                pw.print("        <start>");
                if (pathInfo.contains("IDD")) {
                    pw.print(rm.getStartDateTime(ds.getPath()));
                } else {
                    pw.print(dr.getStart().toString());
                }
                pw.println("</start>");
                pw.println("        <end>" + dr.getEnd().toString() + "</end>");
                pw.println("      </TimeSpan>");
                ThreddsMetadata.GeospatialCoverage gc = ds.getGeospatialCoverage();
                LatLonRect bb = new LatLonRect();
                gc.setBoundingBox(bb);
                pw.println("      <LatLonBox>");
                pw.println("        <north>" + gc.getLatNorth() + "</north>");
                pw.println("        <south>" + gc.getLatSouth() + "</south>");
                pw.println("        <east>" + gc.getLonEast() + "</east>");
                pw.println("        <west>" + gc.getLonWest() + "</west>");
                pw.println("      </LatLonBox>");
                ThreddsMetadata.Variables cvs = (ThreddsMetadata.Variables)ds.getVariables().get(0);
                List vl = cvs.getVariableList();
                pw.println("      <Variables>");
                for (int j = 0; j < vl.size(); ++j) {
                    ThreddsMetadata.Variable v = (ThreddsMetadata.Variable)vl.get(j);
                    pw.println("        <variable name=\"" + v.getName() + "\" vocabulary_name=\"" + v.getVocabularyName() + "\" units=\"" + v.getUnits() + "\" />");
                }
                pw.println("      </Variables>");
                String[] stations = rm.stationsDS(radarType, dataLocation.get(ds.getPath()));
                rm.printStations(stations, pw, radarType);
                pw.println("    </metadata>");
                pw.println("  </dataset>");
            }
            pw.println("</catalog>");
            pw.flush();
        }
        catch (Throwable e) {
            this.log.error("RadarServer.datasetInfoXml", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void datasetInfoHtml(RadarType radarType, String pathInfo, PrintWriter pw, HttpServletResponse res) throws IOException {
        pathInfo = pathInfo.replace("/dataset.html", "");
        pathInfo = pathInfo.replace("/catalog.html", "");
        Element root = new Element("RadarNexrad");
        Document doc = new Document(root);
        if (pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        for (int i = 0; i < datasets.size(); ++i) {
            InvDatasetScan ds = (InvDatasetScan)datasets.get(i);
            if (!pathInfo.equals(ds.getPath())) continue;
            root.setAttribute("location", "/thredds/radarServer/" + ds.getPath());
            ThreddsMetadata.GeospatialCoverage gc = ds.getGeospatialCoverage();
            LatLonRect bb = new LatLonRect();
            gc.setBoundingBox(bb);
            String north = Double.toString(gc.getLatNorth());
            String south = Double.toString(gc.getLatSouth());
            String east = Double.toString(gc.getLonEast());
            String west = Double.toString(gc.getLonWest());
            Element LatLonBox = new Element("LatLonBox");
            LatLonBox.addContent((Content)new Element("north").addContent(north));
            LatLonBox.addContent((Content)new Element("south").addContent(south));
            LatLonBox.addContent((Content)new Element("east").addContent(east));
            LatLonBox.addContent((Content)new Element("west").addContent(west));
            root.addContent((Content)LatLonBox);
            Element timeSpan = new Element("TimeSpan");
            CalendarDateRange dr = ds.getCalendarDateCoverage();
            timeSpan.addContent((Content)new Element("begin").addContent(dr.getStart().toString()));
            timeSpan.addContent((Content)new Element("end").addContent(dr.getEnd().toString()));
            root.addContent((Content)timeSpan);
            ThreddsMetadata.Variables cvs = (ThreddsMetadata.Variables)ds.getVariables().get(0);
            List vl = cvs.getVariableList();
            for (int j = 0; j < vl.size(); ++j) {
                ThreddsMetadata.Variable v = (ThreddsMetadata.Variable)vl.get(j);
                Element variable = new Element("variable");
                variable.setAttribute("name", v.getName());
                root.addContent((Content)variable);
            }
            Element a = new Element("AcceptList");
            a.addContent((Content)new Element("accept").addContent("xml"));
            a.addContent((Content)new Element("accept").addContent("html"));
            root.addContent((Content)a);
        }
        ServerMethods sm = new ServerMethods(this.log);
        InputStream xslt = ServerMethods.getInputStream(this.contentPath + this.getPath() + "radar.xsl", RadarServer.class);
        try {
            XSLTransformer transformer = new XSLTransformer(xslt);
            Document html = transformer.transform(doc);
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            String infoString = fmt.outputString(html);
            res.setContentType("text/html; charset=iso-8859-1");
            pw = res.getWriter();
            pw.println(infoString);
            pw.flush();
        }
        catch (Exception e) {
            this.log.error("radarServer reading " + this.contentPath + this.getPath() + "radar.xsl");
            this.log.error("radarServer XSLTransformer problem for web form ", (Throwable)e);
        }
        finally {
            if (xslt != null) {
                try {
                    xslt.close();
                }
                catch (IOException e) {
                    this.log.error("radarServer radar.xsl: error closing" + this.contentPath + this.getPath() + "radar.xsl");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvCatalogImpl readCatalog(InvCatalogFactory factory, String path, String catalogFullPath) {
        InvCatalogImpl acat;
        try {
            catURI = new URI("file:" + StringUtil2.escape((String)catalogFullPath, (String)"/:-_."));
        }
        catch (URISyntaxException e) {
            this.logServerStartup.info("radarServer readCatalog(): URISyntaxException=" + e.getMessage());
            return null;
        }
        this.logServerStartup.info("radarServer readCatalog(): full path=" + catalogFullPath + "; path=" + path);
        FileInputStream ios = null;
        try {
            ios = new FileInputStream(catalogFullPath);
            acat = factory.readXML((InputStream)ios, catURI);
        }
        catch (Throwable t) {
            this.logServerStartup.error("radarServer readCatalog(): Exception on catalog=" + catalogFullPath + " " + t.getMessage());
            InvCatalogImpl invCatalogImpl = null;
            return invCatalogImpl;
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException e) {
                    this.logServerStartup.info("radarServer readCatalog(): error closing" + catalogFullPath);
                }
            }
        }
        return acat;
    }

    private InputStream getXSLT(String xslName) throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/resources/xsl/" + xslName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String path = "http://motherlode.ucar.edu:8081/thredds/radarServer/nexrad/level3/IDD/dataset.xml";
        try {
            catURI = new URI(StringUtil2.escape((String)path, (String)"/:-_."));
        }
        catch (URISyntaxException e) {
            System.out.println("radarServer main: URISyntaxException=" + e.getMessage());
            return;
        }
        System.out.println("radarServer main: full path=" + path);
        InputStream ios = null;
        try {
            String line;
            URL url = new URL(path);
            ios = url.openStream();
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
            while ((line = dataIS.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Throwable t) {
            System.out.println("radarServer main: Exception on catalog=" + path + " " + t.getMessage());
            return;
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException e) {
                    System.out.println("radarServer main: error closing" + path);
                }
            }
        }
    }

    static {
        dataLocation = new HashMap();
    }

    public static enum RadarType {
        nexrad,
        terminal;

    }
}

