/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Formatter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.writer.DatasetHtmlWriter;
import thredds.core.ViewerService;
import thredds.server.config.HtmlConfig;
import thredds.servlet.HtmlWriter;
import thredds.util.ContentType;
import ucar.nc2.units.DateType;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil2;

public class ConfigCatalogHtmlWriter {
    private static Logger log = LoggerFactory.getLogger(ConfigCatalogHtmlWriter.class);
    @Autowired
    private ViewerService viewerService;
    HtmlWriter html;
    HtmlConfig htmlConfig;
    String contextPath;

    public ConfigCatalogHtmlWriter(HtmlWriter html, HtmlConfig htmlConfig, String contextPath) {
        this.html = html;
        this.htmlConfig = htmlConfig;
        this.contextPath = contextPath;
    }

    public int writeCatalog(HttpServletRequest req, HttpServletResponse res, Catalog cat, boolean isLocalCatalog) throws IOException {
        String catHtmlAsString = this.convertCatalogToHtml(cat, isLocalCatalog);
        res.setContentLength(catHtmlAsString.length());
        res.setContentType(ContentType.html.getContentHeader());
        if (!req.getMethod().equals("HEAD")) {
            PrintWriter writer = res.getWriter();
            writer.write(catHtmlAsString);
            writer.flush();
        }
        return catHtmlAsString.length();
    }

    String convertCatalogToHtml(Catalog cat, boolean isLocalCatalog) {
        StringBuilder sb = new StringBuilder(10000);
        String uri = cat.getUriString();
        if (uri == null) {
            uri = cat.getName();
        }
        if (uri == null) {
            uri = "unknown";
        }
        String catname = StringUtil2.quoteHtmlContent((String)uri);
        sb.append(this.html.getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>");
        sb.append("<title>");
        sb.append("Catalog ").append(catname);
        sb.append("</title>\r\n");
        sb.append(this.html.getTdsCatalogCssLink()).append("\n");
        sb.append("</head>\r\n");
        sb.append("<body>");
        sb.append("<h1>");
        String logoUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallLogoUrl());
        if (logoUrl != null) {
            sb.append("<img src='").append(logoUrl);
            String logoAlt = this.htmlConfig.getInstallLogoAlt();
            if (logoAlt != null) {
                sb.append("' alt='").append(logoAlt);
            }
            sb.append("' align='left' valign='top'").append(">\n");
        }
        sb.append("Catalog ").append(catname);
        sb.append("</h1>");
        sb.append("<HR size='1' noshade='noshade'>");
        sb.append("<table width='100%' cellspacing='0' cellpadding='5' align='center'>\r\n");
        sb.append("<tr>\r\n");
        sb.append("<th align='left'><font size='+1'>");
        sb.append("Dataset");
        sb.append("</font></th>\r\n");
        sb.append("<th align='center'><font size='+1'>");
        sb.append("Size");
        sb.append("</font></th>\r\n");
        sb.append("<th align='right'><font size='+1'>");
        sb.append("Last Modified");
        sb.append("</font></th>\r\n");
        sb.append("</tr>");
        this.doDatasets(cat, cat.getDatasets(), sb, false, 0, isLocalCatalog);
        sb.append("</table>\r\n");
        sb.append("<HR size='1' noshade='noshade'>");
        this.html.appendSimpleFooter(sb);
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        return sb.toString();
    }

    private boolean doDatasets(Catalog cat, List<Dataset> datasets, StringBuilder sb, boolean shade, int level, boolean isLocalCatalog) {
        String catHtml;
        if (!isLocalCatalog) {
            catHtml = this.contextPath + "/remoteCatalogService?command=subset&catalog=" + cat.getUriString() + "&";
        } else {
            int pos;
            URI catURI = cat.getBaseURI();
            catHtml = catURI.getPath();
            if (catHtml == null) {
                catHtml = cat.getUriString();
            }
            if ((pos = catHtml.lastIndexOf("/")) != -1) {
                catHtml = catHtml.substring(pos + 1);
            }
            catHtml = (pos = catHtml.lastIndexOf(46)) < 0 ? catHtml + "catalog.html?" : catHtml.substring(0, pos) + ".html?";
        }
        for (Dataset ds : datasets) {
            String name = StringUtil2.quoteHtmlContent((String)ds.getName());
            sb.append("<tr");
            if (shade) {
                sb.append(" bgcolor='#eeeeee'");
            }
            sb.append(">\r\n");
            shade = !shade;
            sb.append("<td align='left'>");
            for (int j = 0; j <= level; ++j) {
                sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            sb.append("\r\n");
            if (ds instanceof CatalogRef) {
                CatalogRef catref = (CatalogRef)ds;
                String href = catref.getXlinkHref();
                if (!isLocalCatalog) {
                    URI hrefUri = cat.getBaseURI().resolve(href);
                    href = hrefUri.toString();
                }
                try {
                    URI uri = new URI(href);
                    if (uri.isAbsolute()) {
                        boolean defaultUseRemoteCatalogService = this.htmlConfig.getUseRemoteCatalogService();
                        Boolean dsUseRemoteCatalogSerivce = ((CatalogRef)ds).useRemoteCatalogService();
                        boolean useRemoteCatalogService = defaultUseRemoteCatalogService;
                        if (dsUseRemoteCatalogSerivce == null) {
                            dsUseRemoteCatalogSerivce = defaultUseRemoteCatalogService;
                        }
                        if (defaultUseRemoteCatalogService != dsUseRemoteCatalogSerivce) {
                            useRemoteCatalogService = dsUseRemoteCatalogSerivce;
                        }
                        if (useRemoteCatalogService) {
                            href = this.contextPath + "/remoteCatalogService?catalog=" + href;
                        } else {
                            int pos = href.lastIndexOf(46);
                            href = href.substring(0, pos) + ".html";
                        }
                    } else {
                        int pos = href.lastIndexOf(46);
                        href = href.substring(0, pos) + ".html";
                    }
                }
                catch (URISyntaxException e) {
                    log.error(href, (Throwable)e);
                }
                sb.append("<img src='").append(this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getFolderIconUrl())).append("' alt='").append(this.htmlConfig.getFolderIconAlt()).append("'> &nbsp;");
                sb.append("<a href='");
                sb.append(StringUtil2.quoteHtmlContent((String)href));
                sb.append("'><tt>");
                sb.append(name);
                sb.append("/</tt></a></td>\r\n");
            } else {
                if (ds.hasNestedDatasets()) {
                    sb.append("<img src='").append(this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getFolderIconUrl())).append("' alt='").append(this.htmlConfig.getFolderIconAlt()).append("'> &nbsp;");
                }
                if (ds.getAccess().size() == 1 && ((Access)ds.getAccess().get(0)).getService().getType().equals((Object)ServiceType.Resolver)) {
                    Access access = (Access)ds.getAccess().get(0);
                    String accessUrlName = access.getUnresolvedUrlName();
                    int pos = accessUrlName.lastIndexOf(".xml");
                    if (accessUrlName.equalsIgnoreCase("latest.xml") && !isLocalCatalog) {
                        String catBaseUriPath = "";
                        String catBaseUri = cat.getBaseURI().toString();
                        pos = catBaseUri.lastIndexOf("catalog.xml");
                        if (pos != -1) {
                            catBaseUriPath = catBaseUri.substring(0, pos);
                        }
                        accessUrlName = this.contextPath + "/remoteCatalogService?catalog=" + catBaseUriPath + accessUrlName;
                    } else if (pos != -1) {
                        accessUrlName = accessUrlName.substring(0, pos) + ".html";
                    }
                    sb.append("<a href='");
                    sb.append(StringUtil2.quoteHtmlContent((String)accessUrlName));
                    sb.append("'><tt>");
                    String tmpName = name;
                    if (tmpName.endsWith(".xml")) {
                        tmpName = tmpName.substring(0, tmpName.lastIndexOf(46));
                    }
                    sb.append(tmpName);
                    sb.append("</tt></a></td>\r\n");
                } else if (ds.getID() != null) {
                    sb.append("<a href='");
                    sb.append(StringUtil2.quoteHtmlContent((String)catHtml));
                    sb.append("dataset=");
                    sb.append(StringUtil2.replace((String)ds.getID(), (char)'+', (String)"%2B"));
                    sb.append("'><tt>");
                    sb.append(name);
                    sb.append("</tt></a></td>\r\n");
                } else {
                    sb.append("<tt>");
                    sb.append(name);
                    sb.append("</tt></td>\r\n");
                }
            }
            sb.append("<td align='right'><tt>");
            double size = ds.getDataSize();
            if (size != 0.0 && !Double.isNaN(size)) {
                sb.append(Format.formatByteSize((double)size));
            } else {
                sb.append("&nbsp;");
            }
            sb.append("</tt></td>\r\n");
            sb.append("<td align='right'><tt>");
            DateType lastModDateType = ds.getLastModifiedDate();
            if (lastModDateType == null) {
                sb.append("--");
            } else {
                sb.append(lastModDateType.toDateTimeString());
            }
            sb.append("</tt></td>\r\n");
            sb.append("</tr>\r\n");
            if (ds instanceof CatalogRef) continue;
            shade = this.doDatasets(cat, ds.getDatasets(), sb, shade, level + 1, isLocalCatalog);
        }
        return shade;
    }

    private String convertDatasetToHtml(String catURL, Dataset dataset, HttpServletRequest request, boolean isLocalCatalog) {
        Formatter out = new Formatter();
        out.format("%s<head>\r\n", this.html.getHtmlDoctypeAndOpenTag());
        out.format("<title> Catalog Services</title>\r\n", new Object[0]);
        out.format("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>\r\n", new Object[0]);
        out.format("%s</head>\r\n", this.html.getTdsPageCssLink());
        out.format("<body>\r\n", new Object[0]);
        StringBuilder sb = new StringBuilder();
        this.html.appendOldStyleHeader(sb);
        out.format("%s\r\n", sb);
        out.format("<h2> Catalog %s</h2>\r\n", catURL);
        DatasetHtmlWriter writer = new DatasetHtmlWriter();
        writer.writeHtmlDescription(out, dataset, false, true, false, false, !isLocalCatalog);
        if (isLocalCatalog) {
            this.viewerService.showViewers(out, dataset, request);
        }
        out.format("%s\r\n", this.html.getGoogleTrackingContent());
        out.format("</body>\r\n", new Object[0]);
        out.format("</html>\r\n", new Object[0]);
        return out.toString();
    }

    public int showDataset(String catURL, Dataset dataset, HttpServletRequest request, HttpServletResponse response, boolean isLocalCatalog) throws IOException {
        String datasetAsHtml = this.convertDatasetToHtml(catURL, dataset, request, isLocalCatalog);
        response.setStatus(200);
        response.setContentType(ContentType.html.getContentHeader());
        if (!request.getMethod().equals("HEAD")) {
            PrintWriter pw = response.getWriter();
            pw.write(datasetAsHtml);
            pw.flush();
        }
        return datasetAsHtml.length();
    }
}

