/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer2;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import thredds.server.radarServer2.RadarServerConfig;
import thredds.server.radarServer2.StationList;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.EarthLocation;

public class RadarDataInventory {
    private static final long updateIntervalMsec = 600000L;
    private EnumMap<DirType, Set<String>> items = new EnumMap(DirType.class);
    private Path collectionDir;
    private DirectoryStructure structure;
    private String fileTimeRegex;
    private String fileTimeFmt;
    private String dataFormat;
    private boolean dirty;
    private CalendarDate lastUpdate;
    private int maxCrawlItems;
    private int maxCrawlDepth;
    private StationList stations;
    private CalendarPeriod nearestWindow;
    private CalendarPeriod rangeAdjustment;
    private String name;
    private String description;
    private DateRange timeCoverage;
    private RadarServerConfig.RadarConfigEntry.GeoInfo geoCoverage;

    public RadarDataInventory(Path datasetRoot) {
        this.collectionDir = datasetRoot;
        this.structure = new DirectoryStructure(this.collectionDir);
        this.dirty = true;
        this.maxCrawlItems = 5;
        this.maxCrawlDepth = 3;
        this.stations = new StationList();
        this.nearestWindow = CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
    }

    public Path getCollectionDir() {
        return this.collectionDir;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    CalendarDate getLastUpdate() {
        return this.lastUpdate;
    }

    public FeatureType getFeatureType() {
        return FeatureType.RADIAL;
    }

    public void setDataFormat(String format) {
        this.dataFormat = format;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTimeCoverage(DateRange range) {
        this.timeCoverage = range;
    }

    public DateRange getTimeCoverage() {
        return this.timeCoverage;
    }

    public void setGeoCoverage(RadarServerConfig.RadarConfigEntry.GeoInfo info) {
        this.geoCoverage = info;
    }

    public RadarServerConfig.RadarConfigEntry.GeoInfo getGeoCoverage() {
        return this.geoCoverage;
    }

    public boolean needsVar() {
        return this.items.containsKey((Object)DirType.Variable);
    }

    public StationList getStationList() {
        return this.stations;
    }

    public List<String> getVariableList() {
        return this.listItems(DirType.Variable);
    }

    public void setNearestWindow(CalendarPeriod pd) {
        this.nearestWindow = pd;
    }

    public void addStationDir() {
        this.structure.addSubDir(DirType.Station, null);
        this.dirty = true;
    }

    public void addVariableDir() {
        this.structure.addSubDir(DirType.Variable, null);
        this.dirty = true;
    }

    public void addDateDir(String fmt) {
        this.structure.addSubDir(DirType.Date, fmt);
        CalendarPeriod adjust = this.findRangeAdjustment(fmt);
        if (this.rangeAdjustment == null) {
            this.rangeAdjustment = adjust;
        } else if (adjust.getConvertFactor(this.rangeAdjustment) > 1.0) {
            this.rangeAdjustment = adjust;
        }
        this.dirty = true;
    }

    private CalendarPeriod findRangeAdjustment(String fmtString) {
        if (fmtString.contains("H") || fmtString.contains("k")) {
            return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
        }
        if (fmtString.contains("d")) {
            return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Day);
        }
        if (fmtString.contains("M")) {
            return CalendarPeriod.of((int)31, (CalendarPeriod.Field)CalendarPeriod.Field.Day);
        }
        return CalendarPeriod.of((int)366, (CalendarPeriod.Field)CalendarPeriod.Field.Day);
    }

    public void addFileTime(String regex, String fmt) {
        this.fileTimeRegex = regex;
        this.fileTimeFmt = fmt;
    }

    private void findItems(Path start, int level) {
        Set<Object> values;
        if (level >= this.structure.order.size() || level >= this.maxCrawlDepth) {
            return;
        }
        DirectoryStructure.DirEntry entry = (DirectoryStructure.DirEntry)this.structure.order.get(level);
        if (!this.items.containsKey((Object)entry.type)) {
            values = new TreeSet();
            this.items.put(entry.type, values);
        } else {
            values = this.items.get((Object)entry.type);
        }
        int crawled = 0;
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(start);){
            for (Path p : dirStream) {
                if (!p.toFile().isDirectory()) continue;
                String item = p.getFileName().toString();
                values.add(item);
                if (crawled >= this.maxCrawlItems) continue;
                this.findItems(p, level + 1);
                ++crawled;
            }
        }
        catch (IOException e) {
            System.out.println("findItems(): Error reading directory: " + start.toString());
        }
    }

    private void updateStations(String station, Path path) {
        StationList.Station match = this.stations.get(station);
        if (match == null) {
            try {
                Files.walkFileTree(path, new StationVisitor());
            }
            catch (IOException e) {
                System.out.println("Error walking to find station info: " + station);
            }
        }
    }

    private void update() {
        if (this.dirty || this.timeToUpdate()) {
            this.findItems(this.structure.base, 0);
            this.dirty = false;
            this.lastUpdate = CalendarDate.present();
        }
    }

    boolean timeToUpdate() {
        CalendarDate now = CalendarDate.present();
        return now.getDifferenceInMsecs(this.lastUpdate) > 600000L;
    }

    public List<String> listItems(DirType type) {
        this.update();
        Set<String> vals = this.items.get((Object)type);
        if (vals == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(vals);
    }

    public Query newQuery() {
        this.update();
        return new Query();
    }

    public static void main(String[] args) throws IOException {
        for (String name : args) {
            File baseDir = new File(name);
            if (!baseDir.isDirectory()) continue;
            RadarDataInventory dw = new RadarDataInventory(baseDir.toPath());
            dw.addVariableDir();
            dw.addStationDir();
            dw.addDateDir("yyyyMMdd");
            System.out.println("Stations:");
            for (String res : dw.listItems(DirType.Station)) {
                System.out.println("\t" + res);
            }
            System.out.println("Variables:");
            for (String res : dw.listItems(DirType.Variable)) {
                System.out.println("\t" + res);
            }
            System.out.println("Dates:");
            for (String res : dw.listItems(DirType.Date)) {
                System.out.println("\t" + res);
            }
            Query q = dw.newQuery();
            q.addVariable("N0Q");
            q.addStation("TLX");
            q.addDateRange(CalendarDateRange.of((CalendarDate)CalendarDate.of(null, (int)2014, (int)6, (int)24, (int)0, (int)0, (int)0), (CalendarDate)CalendarDate.of(null, (int)2014, (int)6, (int)25, (int)0, (int)0, (int)0)));
            System.out.println("Results of query:");
            for (Query.QueryResultItem i : q.results()) {
                System.out.println("File: " + i.file.toString());
            }
        }
    }

    public class Query {
        private EnumMap<DirType, List<Object>> q = new EnumMap(DirType.class);

        public void addCriteria(DirType type, Object val) {
            List<Object> curVals = this.q.get((Object)type);
            if (curVals == null) {
                curVals = new ArrayList<Object>();
                this.q.put(type, curVals);
            }
            curVals.add(val);
        }

        public void addStation(String stID) {
            this.addCriteria(DirType.Station, stID);
        }

        public void addVariable(String varName) {
            this.addCriteria(DirType.Variable, varName);
        }

        public void addDateRange(CalendarDateRange range) {
            this.addCriteria(DirType.Date, range);
        }

        private CalendarDateRange rangeFromFormat(SimpleDateFormat fmt, CalendarDateRange range) {
            if (range == null) {
                return null;
            }
            CalendarDate newStart = this.reparseDate(fmt, range.getStart());
            CalendarDate newEnd = this.reparseDate(fmt, range.getEnd());
            return CalendarDateRange.of((CalendarDate)newStart, (CalendarDate)newEnd.add(RadarDataInventory.this.rangeAdjustment));
        }

        private CalendarDate reparseDate(SimpleDateFormat fmt, CalendarDate d) {
            try {
                Date newDate = fmt.parse(fmt.format(d.toDate()));
                return CalendarDate.of((Date)newDate);
            }
            catch (ParseException e) {
                return d;
            }
        }

        private boolean checkDate(CalendarDateRange range, CalendarDate d) {
            return range == null || range.includes(d);
        }

        public Collection<QueryResultItem> results() {
            Object object;
            DirectoryStream<Path> dirStream;
            ArrayList<Path> results = new ArrayList<Path>();
            DirectoryStructure.DirectoryDateMatcher matcher = RadarDataInventory.this.structure.matcher();
            results.add(RadarDataInventory.this.structure.base);
            boolean needDateFilter = false;
            for (int i = 0; i < RadarDataInventory.this.structure.order.size(); ++i) {
                DirectoryStructure.DirEntry entry = (DirectoryStructure.DirEntry)RadarDataInventory.this.structure.order.get(i);
                ArrayList<Object> newResults = new ArrayList<Object>();
                List<Object> queryItem = this.q.get((Object)entry.type);
                switch (entry.type) {
                    case Date: {
                        needDateFilter = queryItem.get(0) != null;
                        for (Path p : results) {
                            try {
                                dirStream = Files.newDirectoryStream(p);
                                object = null;
                                try {
                                    for (Path sub : dirStream) {
                                        newResults.add(sub);
                                    }
                                }
                                catch (Throwable throwable) {
                                    object = throwable;
                                    throw throwable;
                                }
                                finally {
                                    if (dirStream == null) continue;
                                    if (object != null) {
                                        try {
                                            dirStream.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                        continue;
                                    }
                                    dirStream.close();
                                }
                            }
                            catch (IOException e) {
                                System.out.println("results(): Error reading dir: " + p.toString());
                            }
                        }
                        matcher.add(i, entry.fmt);
                        break;
                    }
                    default: {
                        for (Object next : queryItem) {
                            for (Path p : results) {
                                Path nextPath = p.resolve(next.toString());
                                if (!nextPath.toFile().exists()) continue;
                                newResults.add(nextPath);
                            }
                        }
                    }
                }
                results = newResults;
            }
            List<Object> dates = this.q.get((Object)DirType.Date);
            CalendarDateRange range = (CalendarDateRange)dates.get(0);
            if (range != null && range.isPoint()) {
                range = CalendarDateRange.of((CalendarDate)range.getStart().subtract(RadarDataInventory.this.nearestWindow), (CalendarDate)range.getEnd().add(RadarDataInventory.this.nearestWindow));
            }
            ArrayList<Path> filteredResults = new ArrayList<Path>();
            if (needDateFilter) {
                SimpleDateFormat fmt = matcher.getFormat();
                CalendarDateRange dirRange = this.rangeFromFormat(fmt, range);
                for (Path p : results) {
                    Date d = matcher.getDate(p);
                    if (d == null || !this.checkDate(dirRange, CalendarDate.of((Date)d))) continue;
                    filteredResults.add(p);
                }
            } else {
                filteredResults = results;
            }
            Collection<QueryResultItem> filteredFiles = new ArrayList<QueryResultItem>();
            for (Path p : filteredResults) {
                try {
                    dirStream = Files.newDirectoryStream(p);
                    object = null;
                    try {
                        for (Path f : dirStream) {
                            Pattern pattern = Pattern.compile(RadarDataInventory.this.fileTimeRegex);
                            Matcher regexMatcher = pattern.matcher(f.toString());
                            if (!regexMatcher.find()) continue;
                            try {
                                CalendarDate cd;
                                SimpleDateFormat fmt = new SimpleDateFormat(RadarDataInventory.this.fileTimeFmt);
                                fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
                                Date d = fmt.parse(regexMatcher.group());
                                if (d == null || !this.checkDate(range, cd = CalendarDate.of((Date)d))) continue;
                                filteredFiles.add(new QueryResultItem(f, cd));
                            }
                            catch (ParseException parseException) {}
                        }
                    }
                    catch (Throwable nextPath) {
                        object = nextPath;
                        throw nextPath;
                    }
                    finally {
                        if (dirStream == null) continue;
                        if (object != null) {
                            try {
                                dirStream.close();
                            }
                            catch (Throwable nextPath) {
                                ((Throwable)object).addSuppressed(nextPath);
                            }
                            continue;
                        }
                        dirStream.close();
                    }
                }
                catch (IOException e) {
                    System.out.println("results(): Error getting files for: " + p.toString());
                }
            }
            CalendarDateRange originalRange = (CalendarDateRange)dates.get(0);
            if (originalRange != null && originalRange.isPoint()) {
                TreeMap<String, Long> offsets = new TreeMap<String, Long>();
                TreeMap<String, QueryResultItem> best = new TreeMap<String, QueryResultItem>();
                for (QueryResultItem it : filteredFiles) {
                    long check;
                    String key = RadarDataInventory.this.structure.getKey(it.file);
                    Long offset = (Long)offsets.get(key);
                    if (offset == null) {
                        offset = Long.MAX_VALUE;
                    }
                    if ((check = Math.abs(it.time.getDifferenceInMsecs(originalRange.getStart()))) >= offset) continue;
                    offsets.put(key, check);
                    best.put(key, it);
                }
                filteredFiles = best.values();
            }
            return filteredFiles;
        }

        public class QueryResultItem {
            public Path file;
            public CalendarDate time;

            private QueryResultItem(Path f, CalendarDate cd) {
                this.file = f;
                this.time = cd;
            }
        }
    }

    private class StationVisitor
    extends SimpleFileVisitor<Path> {
        private StationVisitor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            try (RadialDatasetSweep rds = (RadialDatasetSweep)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.RADIAL, (String)file.toString(), null, (Formatter)new Formatter());){
                if (rds == null) {
                    FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                    return fileVisitResult;
                }
                EarthLocation loc = rds.getCommonOrigin();
                if (loc == null) {
                    FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                    return fileVisitResult;
                }
                StationList.Station added = RadarDataInventory.this.stations.addStation(rds.getRadarID(), loc.getLatLon());
                added.setElevation(loc.getAltitude());
                added.setName(rds.getRadarName());
                FileVisitResult fileVisitResult = FileVisitResult.TERMINATE;
                return fileVisitResult;
            }
            catch (IOException e) {
                return FileVisitResult.CONTINUE;
            }
        }
    }

    public static class DirectoryStructure {
        private Path base;
        private String sep;
        private List<DirEntry> order;
        private List<Integer> keyIndices;

        public DirectoryStructure(Path dir) {
            this.base = dir;
            this.sep = System.getProperty("file.separator");
            this.order = new ArrayList<DirEntry>();
            this.keyIndices = new ArrayList<Integer>();
        }

        public void addSubDir(DirType type, String fmt) {
            this.keyIndices.add(this.order.size());
            if (type == DirType.Station || type == DirType.Variable) {
                this.order.add(new DirEntry(type, fmt));
            }
        }

        public String getKey(Path path) {
            Path relPath = this.base.relativize(path);
            String[] parts = relPath.toString().split(this.sep);
            StringBuilder sb = new StringBuilder("");
            for (int ind : this.keyIndices) {
                sb.append(parts[ind]);
            }
            return sb.toString();
        }

        public DirectoryDateMatcher matcher() {
            return new DirectoryDateMatcher();
        }

        private class DirectoryDateMatcher {
            List<Integer> levels = new ArrayList<Integer>(4);
            String fmt = "";

            public void add(int level, String value) {
                this.levels.add(level);
                this.fmt = this.fmt + value;
            }

            public SimpleDateFormat getFormat() {
                SimpleDateFormat sdf = new SimpleDateFormat(this.fmt);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                return sdf;
            }

            public Date getDate(Path path) {
                Path relPath = DirectoryStructure.this.base.relativize(path);
                String[] parts = relPath.toString().split(DirectoryStructure.this.sep);
                StringBuilder sb = new StringBuilder("");
                for (Integer l : this.levels) {
                    sb.append(parts[l]);
                }
                try {
                    SimpleDateFormat fmt = this.getFormat();
                    return fmt.parse(sb.toString());
                }
                catch (ParseException e) {
                    return null;
                }
            }
        }

        private static class DirEntry {
            public DirType type;
            public String fmt;

            public DirEntry(DirType type, String fmt) {
                this.type = type;
                this.fmt = fmt;
            }
        }
    }

    public static enum DirType {
        Station,
        Variable,
        Date;

    }
}

