/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.exception.VariableNotContainedInDatasetException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.view.dsg.DsgSubsetWriter;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.units.TimeDuration;

public abstract class AbstractDsgSubsetWriter
implements DsgSubsetWriter {
    protected final FeatureDatasetPoint fdPoint;
    protected final NcssParamsBean ncssParams;
    protected final List<VariableSimpleIF> wantedVariables;
    protected final CalendarDateRange wantedRange;

    public AbstractDsgSubsetWriter(FeatureDatasetPoint fdPoint, NcssParamsBean ncssParams) throws NcssException {
        this.fdPoint = fdPoint;
        this.ncssParams = ncssParams;
        this.wantedVariables = AbstractDsgSubsetWriter.getWantedVariables(fdPoint, ncssParams);
        this.wantedRange = AbstractDsgSubsetWriter.getWantedRange(ncssParams);
    }

    @Override
    public void respond(HttpServletResponse res, FeatureDataset ft, String requestPathInfo, NcssParamsBean queryParams, SupportedFormat format) throws Exception {
        this.write();
    }

    @Override
    public HttpHeaders getResponseHeaders(FeatureDataset fd, SupportedFormat format, String datasetPath) {
        return this.getHttpHeaders(datasetPath, format.isStream());
    }

    public static List<VariableSimpleIF> getWantedVariables(FeatureDatasetPoint fdPoint, NcssParamsBean ncssParams) throws VariableNotContainedInDatasetException {
        if (ncssParams.getVar().size() == 1 && ncssParams.getVar().get(0).equals("all")) {
            return fdPoint.getDataVariables();
        }
        HashMap<String, VariableSimpleIF> dataVarsMap = new HashMap<String, VariableSimpleIF>();
        for (VariableSimpleIF dataVar : fdPoint.getDataVariables()) {
            dataVarsMap.put(dataVar.getShortName(), dataVar);
        }
        ArrayList allVarNames = new ArrayList(dataVarsMap.keySet());
        ArrayList<VariableSimpleIF> wantedVars = new ArrayList<VariableSimpleIF>();
        for (String varName : ncssParams.getVar()) {
            if (allVarNames.contains(varName)) {
                VariableSimpleIF var = (VariableSimpleIF)dataVarsMap.get(varName);
                wantedVars.add(var);
                continue;
            }
            throw new VariableNotContainedInDatasetException("Variable: " + varName + " is not contained in the requested dataset");
        }
        return wantedVars;
    }

    public static CalendarDateRange getWantedRange(NcssParamsBean ncssParams) throws NcssException {
        boolean isAllTimes = ncssParams.isAllTimes();
        String time = ncssParams.getTime();
        String timeStart = ncssParams.getTime_start();
        String timeEnd = ncssParams.getTime_end();
        String timeDuration = ncssParams.getTime_duration();
        if (isAllTimes) {
            return null;
        }
        if (time != null) {
            CalendarDate startR = CalendarDate.parseISOformat(null, (String)time);
            startR = startR.subtract(CalendarPeriod.Hour);
            CalendarDate endR = CalendarDate.parseISOformat(null, (String)time);
            endR = endR.add(CalendarPeriod.Hour);
            return CalendarDateRange.of((Date)new Date(startR.getMillis()), (Date)new Date(endR.getMillis()));
        }
        if (timeStart == null && timeEnd == null && timeDuration == null) {
            return null;
        }
        if (timeStart != null && timeEnd != null) {
            CalendarDate startR = CalendarDate.parseISOformat(null, (String)timeStart);
            CalendarDate endR = CalendarDate.parseISOformat(null, (String)timeEnd);
            return CalendarDateRange.of((Date)new Date(startR.getMillis()), (Date)new Date(endR.getMillis()));
        }
        if (timeStart != null && timeDuration != null) {
            CalendarDate startR = CalendarDate.parseISOformat(null, (String)timeStart);
            TimeDuration td = ncssParams.parseTimeDuration();
            return new CalendarDateRange(startR, (long)td.getValueInSeconds());
        }
        if (timeEnd != null && timeDuration != null) {
            CalendarDate endR = CalendarDate.parseISOformat(null, (String)timeEnd);
            TimeDuration td = ncssParams.parseTimeDuration();
            return new CalendarDateRange(endR, (long)td.getValueInSeconds() * -1L);
        }
        throw new NcssException("Two of \"time_start\", \"time_end\", and \"time_duration\" must be present to define a valid time range.");
    }
}

