/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.gridaspoint.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.ncss.dataservice.StructureDataFactory;
import thredds.server.ncss.util.NcssRequestUtils;
import thredds.server.ncss.view.gridaspoint.netcdf.CFPointWriterWrapper;
import thredds.server.ncss.view.gridaspoint.netcdf.WriterCFTimeSeriesProfileCollection;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.ft.point.writer.CFPointWriterUtils;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

final class CFTimeSeriesProfileCollectionWriterWrapper
implements CFPointWriterWrapper {
    private static Logger log = LoggerFactory.getLogger(CFTimeSeriesProfileCollectionWriterWrapper.class);
    private WriterCFTimeSeriesProfileCollection writerCFTimeSeriesProfileCollection;
    private CalendarDate timeOrigin;

    private CFTimeSeriesProfileCollectionWriterWrapper(NetcdfFileWriter.Version version, String filePath, List<Attribute> atts) throws IOException {
        this.writerCFTimeSeriesProfileCollection = new WriterCFTimeSeriesProfileCollection(version, filePath, atts);
    }

    @Override
    public boolean header(Map<String, List<String>> groupedVars, GridDataset gds, List<CalendarDate> wDates, List<Attribute> timeDimAtts, LatLonPoint point, Double vertCoord) {
        boolean headerDone = false;
        Attribute unitsAtt = CFPointWriterUtils.findCDMAtt(timeDimAtts, (String)"units");
        try {
            DateUnit dateUnit = new DateUnit(unitsAtt.getStringValue());
            this.timeOrigin = dateUnit.makeCalendarDate(0.0);
        }
        catch (Exception e) {
            log.error("Error creating time units for: " + unitsAtt.getStringValue());
            return headerDone;
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("title", "Extract time series profiles data from Grid file " + gds.getLocationURI()));
        String stnName = "Grid Point";
        String desc = "Grid Point at lat/lon=" + point.getLatitude() + "," + point.getLongitude();
        StationImpl s = new StationImpl(stnName, desc, "", point.getLatitude(), point.getLongitude(), Double.NaN);
        ArrayList<Station> stnList = new ArrayList<Station>();
        stnList.add((Station)s);
        try {
            this.writerCFTimeSeriesProfileCollection.writeHeader(stnList, groupedVars, gds, timeDimAtts, wDates.size(), vertCoord);
            headerDone = true;
        }
        catch (IOException ioe) {
            log.error("Error writing header", (Throwable)ioe);
        }
        return headerDone;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double targetLevel) throws InvalidRangeException {
        boolean allDone = false;
        ArrayList<String> keys = new ArrayList<String>(groupedVars.keySet());
        try {
            for (String key : keys) {
                List<String> varsGroup = groupedVars.get(key);
                CoordinateAxis1D ensAxis = gridDataset.findGridDatatype(varsGroup.get(0)).getCoordinateSystem().getEnsembleAxis();
                double[] ensCoords = new double[]{-1.0};
                if (ensAxis != null) {
                    ensCoords = ensAxis.getCoordValues();
                }
                int ensIdx = 0;
                for (double ensCoord : ensCoords) {
                    if (ensCoord >= 0.0) {
                        this.writerCFTimeSeriesProfileCollection.writeEnsCoord(ensIdx, ensCoord);
                        ++ensIdx;
                    }
                    CoordinateAxis1D zAxis = gridDataset.findGridDatatype(varsGroup.get(0)).getCoordinateSystem().getVerticalAxis();
                    EarthLocationImpl earthLocation = null;
                    GridAsPointDataset gap = NcssRequestUtils.buildGridAsPointDataset(gridDataset, varsGroup);
                    GridDatatype timeGrid = NcssRequestUtils.getTimeGrid(groupedVars, gridDataset);
                    if (timeGrid == null) {
                        throw new IllegalArgumentException("Variables do not have time dimension");
                    }
                    Double timeCoordValue = NcssRequestUtils.getTimeCoordValue(timeGrid, date, this.timeOrigin);
                    if (zAxis == null) {
                        StructureData sdata = StructureDataFactory.getFactory().createSingleStructureData(gridDataset, point, varsGroup, true);
                        sdata.findMember("time").getDataArray().setDouble(0, timeCoordValue.doubleValue());
                        Iterator<String> itVars = varsGroup.iterator();
                        boolean cont = false;
                        while (itVars.hasNext()) {
                            String varName = itVars.next();
                            GridDatatype grid = gridDataset.findGridDatatype(varName);
                            if (gap.hasTime(grid, date)) {
                                GridAsPointDataset.Point p = gap.readData(grid, date, ensCoord, -1.0, point.getLatitude(), point.getLongitude());
                                sdata.findMember(varName).getDataArray().setDouble(0, p.dataValue);
                                if (cont) continue;
                                earthLocation = new EarthLocationImpl(p.lat, p.lon, Double.NaN);
                                continue;
                            }
                            sdata.findMember(varName).getDataArray().setDouble(0, gap.getMissingValue(grid));
                            earthLocation = new EarthLocationImpl(point.getLatitude(), point.getLongitude(), Double.NaN);
                        }
                        if (ensCoord >= 0.0) {
                            this.writerCFTimeSeriesProfileCollection.writeRecord(timeCoordValue, ensCoord, date, (EarthLocation)earthLocation, sdata);
                            continue;
                        }
                        this.writerCFTimeSeriesProfileCollection.writeRecord(timeCoordValue, date, (EarthLocation)earthLocation, sdata);
                        continue;
                    }
                    String profileName = zAxis.getShortName();
                    double[] vertCoords = new double[]{0.0};
                    int vertCoordsIndex = 0;
                    if (targetLevel != null) {
                        vertCoords[0] = targetLevel;
                        vertCoordsIndex = zAxis.findCoordElementBounded(targetLevel.doubleValue());
                    } else if (zAxis.getCoordValues().length > 1) {
                        vertCoords = zAxis.getCoordValues();
                    }
                    int vertCoordsIndexForFile = 0;
                    for (double vertLevel : vertCoords) {
                        StructureData sdata = StructureDataFactory.getFactory().createSingleStructureData(gridDataset, point, varsGroup, zAxis, true);
                        sdata.findMember("time").getDataArray().setDouble(0, timeCoordValue.doubleValue());
                        sdata.findMember(zAxis.getShortName()).getDataArray().setDouble(0, zAxis.getCoordValues()[vertCoordsIndex]);
                        ++vertCoordsIndex;
                        ++vertCoordsIndexForFile;
                        int cont = 0;
                        for (String varName : varsGroup) {
                            GridDatatype grid = gridDataset.findGridDatatype(varName);
                            if (grid.getCoordinateSystem().getVerticalTransform() != null) {
                                double actualLevel = NcssRequestUtils.getActualVertLevel(grid, date, point, vertLevel);
                                sdata.findMember(grid.getCoordinateSystem().getVerticalCT().getName()).getDataArray().setDouble(0, actualLevel);
                            }
                            if (gap.hasTime(grid, date) && gap.hasVert(grid, vertLevel)) {
                                GridAsPointDataset.Point p = gap.readData(grid, date, ensCoord, vertLevel, point.getLatitude(), point.getLongitude());
                                sdata.findMember(varName).getDataArray().setDouble(0, p.dataValue);
                                if (cont == 0) {
                                    earthLocation = new EarthLocationImpl(p.lat, p.lon, p.z);
                                }
                            } else {
                                sdata.findMember(varName).getDataArray().setDouble(0, gap.getMissingValue(grid));
                                earthLocation = new EarthLocationImpl(point.getLatitude(), point.getLongitude(), vertLevel);
                            }
                            ++cont;
                        }
                        if (ensCoord >= 0.0) {
                            this.writerCFTimeSeriesProfileCollection.writeRecord(profileName, timeCoordValue, ensCoord, date, (EarthLocation)earthLocation, sdata, vertCoordsIndexForFile - 1);
                        } else {
                            this.writerCFTimeSeriesProfileCollection.writeRecord(profileName, timeCoordValue, date, (EarthLocation)earthLocation, sdata, vertCoordsIndexForFile - 1);
                        }
                        allDone = true;
                    }
                }
            }
        }
        catch (IOException ioe) {
            log.error("Error writing data", (Throwable)ioe);
        }
        return allDone;
    }

    @Override
    public boolean trailer() {
        boolean allDone = false;
        try {
            this.writerCFTimeSeriesProfileCollection.finish();
            allDone = true;
        }
        catch (IOException ioe) {
            log.error("Error finishing  WriterCFTimeSeriesProfileCollection: " + ioe);
        }
        return allDone;
    }

    public static CFTimeSeriesProfileCollectionWriterWrapper createWrapper(NetcdfFileWriter.Version version, String filePath, List<Attribute> atts) throws IOException {
        return new CFTimeSeriesProfileCollectionWriterWrapper(version, filePath, atts);
    }
}

