/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.server.ncss.controller.AbstractNcssController;
import thredds.server.ncss.controller.NcssController;
import thredds.server.ncss.dataservice.FeatureDatasetService;
import thredds.server.ncss.dataservice.NcssShowFeatureDatasetInfo;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.util.NcssRequestUtils;
import thredds.util.ContentType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.writer.FeatureDatasetPointXML;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

@Controller
@Scope(value="request")
class NcssDatasetInfoController
extends AbstractNcssController {
    @Autowired
    private NcssShowFeatureDatasetInfo ncssShowDatasetInfo;
    @Autowired
    FeatureDatasetService datasetService;

    NcssDatasetInfoController() {
    }

    @RequestMapping(value={"/ncss/**/dataset.html", "/ncss/**/dataset.xml", "/ncss/**/pointDataset.html", "/ncss/**/pointDataset.xml"}, params={"!var"})
    void getDatasetDescription(HttpServletRequest req, HttpServletResponse res) throws IOException, TransformerException, JDOMException {
        if (!req.getParameterMap().isEmpty()) {
            throw new IllegalArgumentException("Invalid info request.");
        }
        String path = req.getServletPath();
        boolean wantXML = path.endsWith("/dataset.xml") || path.endsWith("/pointDataset.xml");
        boolean showPointForm = path.endsWith("/pointDataset.html");
        String datasetPath = NcssDatasetInfoController.getDatasetPath(path);
        try (FeatureDataset fd = this.datasetService.findDatasetByPath(req, res, datasetPath);){
            if (fd == null) {
                return;
            }
            String strResponse = this.ncssShowDatasetInfo.showForm(fd, this.buildDatasetUrl(datasetPath), wantXML, showPointForm);
            res.setContentLength(strResponse.length());
            if (wantXML) {
                res.setContentType(ContentType.xml.getContentHeader());
            } else {
                res.setContentType(ContentType.html.getContentHeader());
            }
            this.writeResponse(strResponse, res);
        }
    }

    @RequestMapping(value={"/ncss/**/station.xml"})
    void getStations(HttpServletRequest req, HttpServletResponse res, NcssParamsBean params) throws IOException {
        String path = req.getServletPath();
        String datasetPath = NcssDatasetInfoController.getDatasetPath(path);
        try (FeatureDataset fd = this.datasetService.findDatasetByPath(req, res, datasetPath);){
            if (fd == null) {
                throw new FileNotFoundException("Could not find Dataset " + datasetPath);
            }
            if (fd.getFeatureType() != FeatureType.STATION) {
                throw new UnsupportedOperationException("Station list request is only supported for Station features");
            }
            FeatureDatasetPointXML xmlWriter = new FeatureDatasetPointXML((FeatureDatasetPoint)fd, this.buildDatasetUrl(datasetPath));
            Object stnsList = new String[]{};
            stnsList = params.getStns() != null ? params.getStns().toArray((T[])stnsList) : null;
            LatLonRect llrect = null;
            if (params.getNorth() != null && params.getSouth() != null && params.getEast() != null && params.getWest() != null) {
                llrect = new LatLonRect((LatLonPoint)new LatLonPointImpl(params.getSouth().doubleValue(), params.getWest().doubleValue()), (LatLonPoint)new LatLonPointImpl(params.getNorth().doubleValue(), params.getEast().doubleValue()));
            }
            Document doc = xmlWriter.makeStationCollectionDocument(llrect, stnsList);
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            String infoString = fmt.outputString(doc);
            res.setContentType(ContentType.xml.getContentHeader());
            this.writeResponse(infoString, res);
        }
    }

    private String buildDatasetUrl(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return NcssRequestUtils.getTdsContext().getContextPath() + NcssController.getNCSSServletPath() + path;
    }

    private void writeResponse(String responseStr, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        pw.write(responseStr);
        pw.flush();
        response.flushBuffer();
    }
}

