/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.server.config.HtmlConfig;
import thredds.server.config.TdsContext;
import thredds.server.viewer.dataservice.ViewerService;
import thredds.util.ContentType;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateType;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil2;

@Component
public class HtmlWriter {
    private static Logger log = LoggerFactory.getLogger(HtmlWriter.class);
    private static HtmlWriter singleton;
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private HtmlConfig htmlConfig;
    @Autowired
    private ViewerService viewerService;

    private HtmlWriter() {
    }

    @PostConstruct
    public void afterPropertiesSet() {
        singleton = this;
    }

    public static HtmlWriter getInstance() {
        return singleton;
    }

    public String getHtmlDoctypeAndOpenTag() {
        return "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n        'http://www.w3.org/TR/html4/loose.dtd'>\n<html>\n";
    }

    public String getXHtmlDoctypeAndOpenTag() {
        return "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN'\n        'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>\n<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en'>";
    }

    public String getUserCSS() {
        return "<link rel='stylesheet' href='" + this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getPageCssUrl()) + "' type='text/css' >";
    }

    public String getGoogleTrackingContent() {
        if (this.htmlConfig.getGoogleTrackingCode().isEmpty()) {
            return "";
        }
        return "<script type='text/javascript'>" + "var _gaq = _gaq || [];" + "_gaq.push(['_setAccount', '" + this.htmlConfig.getGoogleTrackingCode() + "']);" + "_gaq.push(['_trackPageview']);" + "(function() {" + "var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;" + "ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';" + "    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);" + "})();" + "</script>";
    }

    public String getTdsCatalogCssLink() {
        return "<link rel='stylesheet' href='" + this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getCatalogCssUrl()) + "' type='text/css' >";
    }

    public String getTdsPageCssLink() {
        return "<link rel='stylesheet' href='" + this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getPageCssUrl()) + "' type='text/css' >";
    }

    public String getUserHead() {
        return "<table width='100%'><tr><td>\n" + "  <img src='" + this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getHostInstLogoUrl()) + "'\n" + "       alt='" + this.htmlConfig.getHostInstLogoAlt() + "'\n" + "       align='left' valign='top'\n" + "       hspace='10' vspace='2'>\n" + "  <h3><strong>" + this.tdsContext.getWebappName() + "</strong></h3>\n" + "</td></tr></table>\n";
    }

    public String getOldStyleHeader() {
        StringBuilder sb = new StringBuilder();
        this.appendOldStyleHeader(sb);
        return sb.toString();
    }

    public void appendOldStyleHeader(StringBuilder sb) {
        this.appendOldStyleHeader(sb, this.htmlConfig.getWebappName(), this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getWebappUrl()), this.htmlConfig.getInstallLogoAlt(), this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallLogoUrl()), this.htmlConfig.getInstallName(), this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallUrl()), this.htmlConfig.getHostInstName(), this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getHostInstUrl()));
    }

    public void appendOldStyleHeader(StringBuilder sb, String webappName, String webappUrl, String logoAlt, String logoUrl, String installName, String installUrl, String hostName, String hostUrl) {
        sb.append("<table width='100%'>\n").append("<tr><td>\n");
        sb.append("<img src='").append(logoUrl).append("' alt='").append(logoAlt).append("' align='left' valign='top'").append(" hspace='10' vspace='2'").append(">\n");
        sb.append("<h3><strong>").append("<a href='").append(installUrl).append("'>").append(installName).append("</a>").append("</strong>");
        sb.append("</h3>\n");
        sb.append("<h3><strong>").append("<a href='").append(webappUrl).append("'>").append(webappName).append("</a>").append("</strong></h3>\n");
        sb.append("</td></tr>\n").append("</table>\n");
    }

    public void appendTableHeader(StringBuilder stringBuilder, boolean includeInstall, boolean includeWebapp, boolean includeLogos) {
        stringBuilder.append("<table width='100%'>\n");
        if (includeInstall) {
            stringBuilder.append("<tr><td>\n");
            this.appendInstallationInfo(stringBuilder, includeLogos);
            stringBuilder.append("</td><td>\n");
            this.appendHostInstInfo(stringBuilder, includeLogos);
            stringBuilder.append("</td></tr>\n");
        }
        if (includeWebapp) {
            stringBuilder.append("<tr><td>\n");
            this.appendWebappInfo(stringBuilder, includeLogos);
            stringBuilder.append("</td></tr>\n");
        }
        stringBuilder.append("</table><hr>\n");
    }

    private void appendWebappInfo(StringBuilder stringBuilder, boolean includeLogo) {
        String webappUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getWebappUrl());
        String webappLogoUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getWebappLogoUrl());
        if (includeLogo && webappLogoUrl != null) {
            stringBuilder.append("<img src='").append(webappLogoUrl).append("' alt='").append(this.htmlConfig.getWebappLogoAlt()).append("'> ");
        }
        stringBuilder.append("<a href='").append(webappUrl).append("'>").append(this.tdsContext.getWebappName()).append("</a>");
    }

    private void appendHostInstInfo(StringBuilder stringBuilder, boolean includeLogo) {
        if (this.htmlConfig.getHostInstName() != null) {
            String hostInstUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getHostInstUrl());
            String hostInstLogoUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getHostInstLogoUrl());
            if (includeLogo && hostInstLogoUrl != null) {
                stringBuilder.append("<img src='").append(hostInstLogoUrl).append("' alt='").append(this.htmlConfig.getHostInstLogoAlt()).append("'> ");
            }
            if (hostInstUrl != null) {
                stringBuilder.append("<a href='").append(hostInstUrl).append("'>");
            }
            stringBuilder.append(this.htmlConfig.getHostInstName());
            if (hostInstUrl != null) {
                stringBuilder.append("</a>");
            }
        } else {
            stringBuilder.append("Unknown Host Institution");
        }
    }

    private void appendInstallationInfo(StringBuilder stringBuilder, boolean includeLogo) {
        if (this.htmlConfig.getInstallName() != null) {
            String installUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallUrl());
            String installLogoUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallLogoUrl());
            if (includeLogo && installLogoUrl != null) {
                stringBuilder.append("<img src='").append(installLogoUrl).append("' alt='").append(this.htmlConfig.getInstallLogoAlt()).append("'> ");
            }
            if (installUrl != null) {
                stringBuilder.append("<a href='").append(installUrl).append("'>");
            }
            stringBuilder.append(this.htmlConfig.getInstallName());
            if (installUrl != null) {
                stringBuilder.append("</a>");
            }
        } else {
            stringBuilder.append("Unnamed TDS Installation");
        }
    }

    public void appendSimpleFooter(StringBuilder sb) {
        sb.append("<h3>");
        if (this.htmlConfig.getInstallName() != null) {
            String installUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallUrl());
            if (installUrl != null) {
                sb.append("<a href='").append(installUrl).append("'>");
            }
            sb.append(this.htmlConfig.getInstallName());
            if (installUrl != null) {
                sb.append("</a>");
            }
        }
        if (this.htmlConfig.getHostInstName() != null) {
            sb.append(" at ");
            String hostInstUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getHostInstUrl());
            if (hostInstUrl != null) {
                sb.append("<a href='").append(hostInstUrl).append("'>");
            }
            sb.append(this.htmlConfig.getHostInstName());
            if (hostInstUrl != null) {
                sb.append("</a>");
            }
            sb.append(String.format(" see <a href='%s/serverInfo.html'> Info </a>", this.tdsContext.getContextPath()));
            sb.append("<br>\n");
        }
        sb.append(this.tdsContext.getWebappName()).append(" [Version ").append(this.tdsContext.getVersionInfo());
        sb.append("] <a href='").append(this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getWebappDocsUrl())).append("'> Documentation</a>");
        sb.append("</h3>\n");
        sb.append(this.getGoogleTrackingContent());
    }

    private void appendWebappFooter(StringBuilder sb) {
        sb.append("<h3>").append(this.tdsContext.getWebappName()).append(" [Version ").append(this.tdsContext.getVersionInfo());
        sb.append("] <a href='").append(this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getWebappDocsUrl())).append("'> Documentation</a>");
        sb.append("</h3>\n");
    }

    private String getTomcatCSS() {
        return "<STYLE type='text/css'><!--" + "H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} " + "H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} " + "H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} " + "BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} " + "B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} " + "P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}" + "A {color : black;}" + "A.name {color : black;}" + "HR {color : #525D76;}" + "--></STYLE>\r\n";
    }

    public int writeDirectory(HttpServletResponse res, File dir, String path) throws IOException {
        if (dir == null) {
            res.sendError(404);
            return 0;
        }
        if (!dir.exists() || !dir.isDirectory()) {
            res.sendError(404);
            return 0;
        }
        String dirHtmlString = this.getDirectory(path, dir);
        res.setContentLength(dirHtmlString.length());
        res.setContentType(ContentType.html.getContentHeader());
        PrintWriter writer = res.getWriter();
        writer.write(dirHtmlString);
        writer.flush();
        return dirHtmlString.length();
    }

    private String getDirectory(String path, File dir) {
        int slash;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>");
        sb.append("<title>");
        sb.append("Directory listing for ").append(path);
        sb.append("</title>\r\n");
        sb.append(this.getTdsCatalogCssLink()).append("\n");
        sb.append("</head>\r\n");
        sb.append("<body>\r\n");
        sb.append("<h1>");
        sb.append("Directory listing for ").append(path);
        String parentDirectory = path;
        if (parentDirectory.endsWith("/")) {
            parentDirectory = parentDirectory.substring(0, parentDirectory.length() - 1);
        }
        if ((slash = parentDirectory.lastIndexOf(47)) >= 0) {
            String parent = parentDirectory.substring(0, slash);
            sb.append(" - <a href='");
            if (parent.equals("")) {
                parent = "/";
            }
            sb.append("../");
            sb.append("'>");
            sb.append("<b>");
            sb.append("Up to ").append(parent);
            sb.append("</b>");
            sb.append("</a>");
        }
        sb.append("</h1>\r\n");
        sb.append("<HR size='1' noshade='noshade'>");
        sb.append("<table width='100%' cellspacing='0' cellpadding='5' align='center'>\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align='left'><font size='+1'><strong>");
        sb.append("Filename");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align='center'><font size='+1'><strong>");
        sb.append("Size");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align='right'><font size='+1'><strong>");
        sb.append("Last Modified");
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        boolean shade = false;
        File[] children = dir.listFiles();
        List<Object> fileList = children == null ? new ArrayList() : Arrays.asList(children);
        Collections.sort(fileList);
        for (File file : fileList) {
            String childname = file.getName();
            if (childname.equalsIgnoreCase("WEB-INF") || childname.equalsIgnoreCase("META-INF")) continue;
            if (file.isDirectory()) {
                childname = childname + "/";
            }
            sb.append("<tr");
            if (shade) {
                sb.append(" bgcolor='#eeeeee'");
            }
            sb.append(">\r\n");
            shade = !shade;
            sb.append("<td align='left'>&nbsp;&nbsp;\r\n");
            sb.append("<a href='");
            sb.append(childname);
            sb.append("'><tt>");
            sb.append(childname);
            sb.append("</tt></a></td>\r\n");
            sb.append("<td align='right'><tt>");
            if (file.isDirectory()) {
                sb.append("&nbsp;");
            } else {
                sb.append(this.renderSize(file.length()));
            }
            sb.append("</tt></td>\r\n");
            sb.append("<td align='right'><tt>");
            sb.append(CalendarDate.of((long)file.lastModified()).toString());
            sb.append("</tt></td>\r\n");
            sb.append("</tr>\r\n");
        }
        sb.append("</table>\r\n");
        sb.append("<HR size='1' noshade='noshade'>");
        this.appendSimpleFooter(sb);
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        return sb.toString();
    }

    private String renderSize(long size) {
        long leftSide = size / 1024L;
        long rightSide = size % 1024L / 103L;
        if (leftSide == 0L && rightSide == 0L && size > 0L) {
            rightSide = 1L;
        }
        return "" + leftSide + "." + rightSide + " kb";
    }

    public int writeCatalog(HttpServletRequest req, HttpServletResponse res, InvCatalogImpl cat, boolean isLocalCatalog) throws IOException {
        String catHtmlAsString = this.convertCatalogToHtml(cat, isLocalCatalog);
        res.setContentLength(catHtmlAsString.length());
        res.setContentType(ContentType.html.getContentHeader());
        if (!req.getMethod().equals("HEAD")) {
            PrintWriter writer = res.getWriter();
            writer.write(catHtmlAsString);
            writer.flush();
        }
        return catHtmlAsString.length();
    }

    String convertCatalogToHtml(InvCatalogImpl cat, boolean isLocalCatalog) {
        StringBuilder sb = new StringBuilder(10000);
        String catname = StringUtil2.quoteHtmlContent((String)cat.getUriString());
        sb.append(this.getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>");
        sb.append("<title>");
        if (cat.isStatic()) {
            sb.append("TdsStaticCatalog ").append(catname);
        } else {
            sb.append("Catalog ").append(catname);
        }
        sb.append("</title>\r\n");
        sb.append(this.getTdsCatalogCssLink()).append("\n");
        sb.append("</head>\r\n");
        sb.append("<body>");
        sb.append("<h1>");
        String logoUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallLogoUrl());
        if (logoUrl != null) {
            sb.append("<img src='").append(logoUrl);
            String logoAlt = this.htmlConfig.getInstallLogoAlt();
            if (logoAlt != null) {
                sb.append("' alt='").append(logoAlt);
            }
            sb.append("' align='left' valign='top'").append(">\n");
        }
        sb.append("Catalog ").append(catname);
        sb.append("</h1>");
        sb.append("<HR size='1' noshade='noshade'>");
        sb.append("<table width='100%' cellspacing='0' cellpadding='5' align='center'>\r\n");
        sb.append("<tr>\r\n");
        sb.append("<th align='left'><font size='+1'>");
        sb.append("Dataset");
        sb.append("</font></th>\r\n");
        sb.append("<th align='center'><font size='+1'>");
        sb.append("Size");
        sb.append("</font></th>\r\n");
        sb.append("<th align='right'><font size='+1'>");
        sb.append("Last Modified");
        sb.append("</font></th>\r\n");
        sb.append("</tr>");
        this.doDatasets(cat, cat.getDatasets(), sb, false, 0, isLocalCatalog);
        sb.append("</table>\r\n");
        sb.append("<HR size='1' noshade='noshade'>");
        this.appendSimpleFooter(sb);
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        return sb.toString();
    }

    private boolean doDatasets(InvCatalogImpl cat, List<InvDataset> datasets, StringBuilder sb, boolean shade, int level, boolean isLocalCatalog) {
        String catHtml;
        if (!isLocalCatalog) {
            catHtml = this.tdsContext.getContextPath() + "/remoteCatalogService?command=subset&catalog=" + cat.getUriString() + "&";
        } else {
            int pos;
            URI catURI = cat.getBaseURI();
            catHtml = catURI.getPath();
            if (catHtml == null) {
                catHtml = cat.getUriString();
            }
            if ((pos = catHtml.lastIndexOf("/")) != -1) {
                catHtml = catHtml.substring(pos + 1);
            }
            catHtml = (pos = catHtml.lastIndexOf(46)) < 0 ? catHtml + "catalog.html?" : catHtml.substring(0, pos) + ".html?";
        }
        for (InvDataset dataset : datasets) {
            InvDatasetImpl ds = (InvDatasetImpl)dataset;
            String name = StringUtil2.quoteHtmlContent((String)ds.getName());
            sb.append("<tr");
            if (shade) {
                sb.append(" bgcolor='#eeeeee'");
            }
            sb.append(">\r\n");
            shade = !shade;
            sb.append("<td align='left'>");
            for (int j = 0; j <= level; ++j) {
                sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            sb.append("\r\n");
            if (ds instanceof InvCatalogRef) {
                InvCatalogRef catref = (InvCatalogRef)ds;
                String href = catref.getXlinkHref();
                if (!isLocalCatalog) {
                    URI hrefUri = cat.getBaseURI().resolve(href);
                    href = hrefUri.toString();
                }
                try {
                    URI uri = new URI(href);
                    if (uri.isAbsolute()) {
                        boolean defaultUseRemoteCatalogService = this.htmlConfig.getUseRemoteCatalogService();
                        Boolean dsUseRemoteCatalogSerivce = ((InvCatalogRef)ds).useRemoteCatalogService();
                        boolean useRemoteCatalogService = defaultUseRemoteCatalogService;
                        if (dsUseRemoteCatalogSerivce == null) {
                            dsUseRemoteCatalogSerivce = defaultUseRemoteCatalogService;
                        }
                        if (defaultUseRemoteCatalogService != dsUseRemoteCatalogSerivce) {
                            useRemoteCatalogService = dsUseRemoteCatalogSerivce;
                        }
                        if (useRemoteCatalogService) {
                            href = this.tdsContext.getContextPath() + "/remoteCatalogService?catalog=" + href;
                        } else {
                            int pos = href.lastIndexOf(46);
                            href = href.substring(0, pos) + ".html";
                        }
                    } else {
                        int pos = href.lastIndexOf(46);
                        href = href.substring(0, pos) + ".html";
                    }
                }
                catch (URISyntaxException e) {
                    log.error(href, (Throwable)e);
                }
                sb.append("<img src='").append(this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getFolderIconUrl())).append("' alt='").append(this.htmlConfig.getFolderIconAlt()).append("'> &nbsp;");
                sb.append("<a href='");
                sb.append(StringUtil2.quoteHtmlContent((String)href));
                sb.append("'><tt>");
                sb.append(name);
                sb.append("/</tt></a></td>\r\n");
            } else {
                if (ds.hasNestedDatasets()) {
                    sb.append("<img src='").append(this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getFolderIconUrl())).append("' alt='").append(this.htmlConfig.getFolderIconAlt()).append("'> &nbsp;");
                }
                if (ds.getAccess().size() == 1 && ((InvAccess)ds.getAccess().get(0)).getService().getServiceType().equals((Object)ServiceType.RESOLVER)) {
                    InvAccess access = (InvAccess)ds.getAccess().get(0);
                    String accessUrlName = access.getUnresolvedUrlName();
                    int pos = accessUrlName.lastIndexOf(".xml");
                    if (accessUrlName.equalsIgnoreCase("latest.xml") && !isLocalCatalog) {
                        String catBaseUriPath = "";
                        String catBaseUri = cat.getBaseURI().toString();
                        pos = catBaseUri.lastIndexOf("catalog.xml");
                        if (pos != -1) {
                            catBaseUriPath = catBaseUri.substring(0, pos);
                        }
                        accessUrlName = this.tdsContext.getContextPath() + "/remoteCatalogService?catalog=" + catBaseUriPath + accessUrlName;
                    } else if (pos != -1) {
                        accessUrlName = accessUrlName.substring(0, pos) + ".html";
                    }
                    sb.append("<a href='");
                    sb.append(StringUtil2.quoteHtmlContent((String)accessUrlName));
                    sb.append("'><tt>");
                    String tmpName = name;
                    if (tmpName.endsWith(".xml")) {
                        tmpName = tmpName.substring(0, tmpName.lastIndexOf(46));
                    }
                    sb.append(tmpName);
                    sb.append("</tt></a></td>\r\n");
                } else if (ds.getID() != null) {
                    sb.append("<a href='");
                    sb.append(StringUtil2.quoteHtmlContent((String)catHtml));
                    sb.append("dataset=");
                    sb.append(StringUtil2.replace((String)ds.getID(), (char)'+', (String)"%2B"));
                    sb.append("'><tt>");
                    sb.append(name);
                    sb.append("</tt></a></td>\r\n");
                } else {
                    sb.append("<tt>");
                    sb.append(name);
                    sb.append("</tt></td>\r\n");
                }
            }
            sb.append("<td align='right'><tt>");
            double size = ds.getDataSize();
            if (size != 0.0 && !Double.isNaN(size)) {
                sb.append(Format.formatByteSize((double)size));
            } else {
                sb.append("&nbsp;");
            }
            sb.append("</tt></td>\r\n");
            sb.append("<td align='right'><tt>");
            DateType lastModDateType = ds.getLastModifiedDate();
            if (lastModDateType == null) {
                sb.append("--");
            } else {
                sb.append(lastModDateType.toDateTimeString());
            }
            sb.append("</tt></td>\r\n");
            sb.append("</tr>\r\n");
            if (ds instanceof InvCatalogRef) continue;
            shade = this.doDatasets(cat, ds.getDatasets(), sb, shade, level + 1, isLocalCatalog);
        }
        return shade;
    }

    private String convertDatasetToHtml(String catURL, InvDatasetImpl dataset, HttpServletRequest request, boolean isLocalCatalog) {
        StringBuilder sb = new StringBuilder(10000);
        sb.append(this.getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<title> Catalog Services</title>\r\n");
        sb.append("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>\r\n");
        sb.append(this.getTdsPageCssLink());
        sb.append("</head>\r\n");
        sb.append("<body>\r\n");
        this.appendOldStyleHeader(sb);
        sb.append("<h2> Catalog ").append(catURL).append("</h2>\r\n");
        InvDatasetImpl.writeHtmlDescription((StringBuilder)sb, (InvDatasetImpl)dataset, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (!isLocalCatalog ? 1 : 0) != 0);
        if (isLocalCatalog) {
            this.viewerService.showViewers(sb, dataset, request);
        }
        sb.append(this.getGoogleTrackingContent());
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        return sb.toString();
    }

    public int showDataset(String catURL, InvDatasetImpl dataset, HttpServletRequest request, HttpServletResponse response, boolean isLocalCatalog) throws IOException {
        String datasetAsHtml = this.convertDatasetToHtml(catURL, dataset, request, isLocalCatalog);
        response.setStatus(200);
        response.setContentType(ContentType.html.getContentHeader());
        if (!request.getMethod().equals("HEAD")) {
            PrintWriter pw = response.getWriter();
            pw.write(datasetAsHtml);
            pw.flush();
        }
        return datasetAsHtml.length();
    }

    public void showCDM(HttpServletResponse res, NetcdfDataset ds) throws IOException {
        String cdmAsString = this.getCDM(ds);
        res.setContentLength(cdmAsString.length());
        res.setContentType(ContentType.html.getContentHeader());
        PrintWriter writer = res.getWriter();
        writer.write(cdmAsString);
        writer.flush();
    }

    private String getCDM(NetcdfDataset ds) throws IOException {
        StringBuilder sb = new StringBuilder(10000);
        String name = StringUtil2.quoteHtmlContent((String)ds.getLocation());
        sb.append(this.getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>");
        sb.append("<title>");
        sb.append("Common Data Model");
        sb.append("</title>\r\n");
        sb.append(this.getTdsPageCssLink()).append("\n");
        sb.append("</head>\r\n");
        sb.append("<body>");
        sb.append("<h1>");
        sb.append("Dataset ").append(name);
        sb.append("</h1>");
        sb.append("<HR size='1' noshade='noshade'>");
        sb.append("<table width='100%' cellspacing='0' cellpadding='5' align='center'>\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align='left'><font size='+1'><strong>");
        sb.append("Axis");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align='left'><font size='+1'><strong>");
        sb.append("Type");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align='left'><font size='+1'><strong>");
        sb.append("Units");
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        boolean shade = false;
        for (CoordinateAxis axis : ds.getCoordinateAxes()) {
            this.showAxis(axis, sb, shade);
            shade = !shade;
        }
        GridDataset gds = new GridDataset(ds);
        sb.append("<tr>\r\n");
        sb.append("<td align='left'><font size='+1'><strong>");
        sb.append("GeoGrid");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align='left'><font size='+1'><strong>");
        sb.append("Description");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align='left'><font size='+1'><strong>");
        sb.append("Units");
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        shade = false;
        for (GridDatatype grid : gds.getGrids()) {
            this.showGrid(grid, sb, shade);
            shade = !shade;
        }
        sb.append("</table>\r\n");
        sb.append("<HR size='1' noshade='noshade'>");
        this.appendSimpleFooter(sb);
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        return sb.toString();
    }

    private void showAxis(CoordinateAxis axis, StringBuilder sb, boolean shade) {
        sb.append("<tr");
        if (shade) {
            sb.append(" bgcolor='#eeeeee'");
        }
        sb.append(">\r\n");
        shade = !shade;
        sb.append("<td align='left'>");
        sb.append("\r\n");
        StringBuilder sbuff = new StringBuilder();
        axis.getNameAndDimensions(sbuff);
        String name = StringUtil2.quoteHtmlContent((String)sbuff.toString());
        sb.append("&nbsp;");
        sb.append(name);
        sb.append("</tt></a></td>\r\n");
        sb.append("<td align='left'><tt>");
        AxisType type = axis.getAxisType();
        String stype = type == null ? "" : StringUtil2.quoteHtmlContent((String)type.toString());
        sb.append(stype);
        sb.append("</tt></td>\r\n");
        sb.append("<td align='left'><tt>");
        String units = axis.getUnitsString();
        String sunits = units == null ? "" : units;
        sb.append(sunits);
        sb.append("</tt></td>\r\n");
        sb.append("</tr>\r\n");
    }

    private void showGrid(GridDatatype grid, StringBuilder sb, boolean shade) {
        sb.append("<tr");
        if (shade) {
            sb.append(" bgcolor='#eeeeee'");
        }
        sb.append(">\r\n");
        shade = !shade;
        sb.append("<td align='left'>");
        sb.append("\r\n");
        VariableDS ve = grid.getVariable();
        StringBuilder sbuff = new StringBuilder();
        ve.getNameAndDimensions(new Formatter(sbuff), false, true);
        String name = StringUtil2.quoteHtmlContent((String)sbuff.toString());
        sb.append("&nbsp;");
        sb.append(name);
        sb.append("</tt></a></td>\r\n");
        sb.append("<td align='left'><tt>");
        String desc = ve.getDescription();
        String sdesc = desc == null ? "" : StringUtil2.quoteHtmlContent((String)desc);
        sb.append(sdesc);
        sb.append("</tt></td>\r\n");
        sb.append("<td align='left'><tt>");
        String units = ve.getUnitsString();
        String sunits = units == null ? "" : units;
        sb.append(sunits);
        sb.append("</tt></td>\r\n");
        sb.append("</tr>\r\n");
    }
}

