/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote.params;

import java.text.ParseException;
import java.util.Formatter;
import org.springframework.http.MediaType;
import thredds.server.cdmremote.validation.CdmrfQueryConstraint;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;

@CdmrfQueryConstraint
public class CdmrfQueryBean {
    private String req = "";
    private String accept = "";
    private String variables;
    private String var;
    private String spatial;
    private TemporalSelection temporalSelection;
    private String stn;
    private String bbox;
    private String west;
    private String east;
    private String south;
    private String north;
    private String latitude;
    private String longitude;
    private String temporal;
    private SpatialSelection spatialSelection;
    private String time_start;
    private String time_end;
    private String time_duration;
    private String time;
    private DateRange dateRange;
    private DateType timePoint;
    private LatLonRect llbb;
    private LatLonPoint latlonPoint;
    private RequestType reqType = null;
    private ResponseType resType = null;
    private boolean fatal = false;
    private Formatter errs = new Formatter();

    boolean hasFatalError() {
        return this.fatal;
    }

    String getErrorMessage() {
        return this.errs.toString();
    }

    public LatLonRect getLatLonRect() {
        return this.spatialSelection == SpatialSelection.bb ? this.llbb : null;
    }

    public void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public LatLonPoint getLatlonPoint() {
        return this.latlonPoint;
    }

    public DateType getTimePoint() {
        return this.timePoint;
    }

    public RequestType getRequestType() {
        if (this.reqType == null) {
            this.reqType = this.req.equalsIgnoreCase("capabilities") ? RequestType.capabilities : (this.req.equalsIgnoreCase("cdl") ? RequestType.cdl : (this.req.equalsIgnoreCase("data") ? RequestType.data : (this.req.equalsIgnoreCase("dataForm") ? RequestType.dataForm : (this.req.equalsIgnoreCase("form") ? RequestType.form : (this.req.equalsIgnoreCase("header") ? RequestType.header : (this.req.equalsIgnoreCase("ncml") ? RequestType.ncml : (this.req.equalsIgnoreCase("stations") ? RequestType.stations : RequestType.data)))))));
        }
        return this.reqType;
    }

    public ResponseType getResponseType() {
        if (this.resType == null) {
            RequestType req = this.getRequestType();
            if (req == RequestType.capabilities) {
                this.resType = ResponseType.xml;
            } else if (req == RequestType.form) {
                this.resType = ResponseType.html;
            }
        }
        if (this.resType == null) {
            this.resType = this.accept.equalsIgnoreCase("csv") ? ResponseType.csv : (this.accept.equalsIgnoreCase("ncstream") ? ResponseType.ncstream : (this.accept.equalsIgnoreCase("netcdf") ? ResponseType.netcdf : (this.accept.equalsIgnoreCase("xml") ? ResponseType.xml : ResponseType.ncstream)));
        }
        return this.resType;
    }

    public MediaType getMediaType() {
        if (this.resType == ResponseType.xml || this.accept.equals("xml") || this.reqType == RequestType.capabilities) {
            return MediaType.TEXT_XML;
        }
        if (this.resType == ResponseType.html || this.reqType == RequestType.form) {
            return MediaType.TEXT_HTML;
        }
        if (this.resType == ResponseType.csv) {
            return MediaType.TEXT_PLAIN;
        }
        if (this.resType == ResponseType.netcdf) {
            return new MediaType("application", "x-netcdf");
        }
        if (this.resType == ResponseType.ncstream) {
            return new MediaType("application", "x-netcdf");
        }
        return MediaType.TEXT_HTML;
    }

    public SpatialSelection getSpatialSelection() {
        return this.spatialSelection;
    }

    public void setSpatialSelection(SpatialSelection spatialSelection) {
        this.spatialSelection = spatialSelection;
    }

    public TemporalSelection getTemporalSelection() {
        return this.temporalSelection;
    }

    public void setTemporalSelection(TemporalSelection temporalSelecion) {
        this.temporalSelection = temporalSelecion;
    }

    public double parseLat(String key, String value) {
        double lat = this.parseDouble(key, value);
        if (!Double.isNaN(lat) && (lat > 90.0 || lat < -90.0)) {
            this.errs.format("Illegal param= param='%s=%s' must be between +/- 90.0 %n", key, value);
            lat = Double.NaN;
            this.fatal = true;
        }
        return lat;
    }

    public double parseLon(String key, String value) {
        return this.parseDouble(key, value);
    }

    private double parseDouble(String key, String value) {
        value = value.trim();
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            this.errs.format("Illegal param='%s=%s' must be valid floating point number%n", key, value);
            this.fatal = true;
            return Double.NaN;
        }
    }

    public DateType parseDate(String key, String value) {
        if (value != null) {
            try {
                return new DateType(value, null, null);
            }
            catch (ParseException e) {
                this.errs.format("Illegal param='%s=%s'  must be valid ISO Date%n", key, value);
                this.fatal = true;
            }
        }
        return null;
    }

    public TimeDuration parseW3CDuration(String key, String value) {
        if (value != null) {
            try {
                return new TimeDuration(value);
            }
            catch (ParseException e) {
                this.errs.format("Illegal param='%s=%s'  must be valid ISO Duration%n", key, value);
                this.fatal = true;
            }
        }
        return null;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public void setReq(String req) {
        this.req = req;
    }

    public void setVariables(String variables) {
        this.variables = variables;
    }

    public String getVariables() {
        return this.variables;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getVar() {
        return this.var;
    }

    public String[] getVarNames() {
        return this.var == null ? null : this.var.split(",");
    }

    public void setSpatial(String spatial) {
        this.spatial = spatial;
    }

    public String getSpatial() {
        return this.spatial;
    }

    public void setStn(String stn) {
        this.stn = stn;
    }

    public String getStn() {
        return this.stn;
    }

    public String[] getStnNames() {
        if (this.spatialSelection != SpatialSelection.stns) {
            return null;
        }
        return this.stn == null ? null : this.stn.split(",");
    }

    public void setBbox(String bbox) {
        this.bbox = bbox;
    }

    public String getBbox() {
        return this.bbox;
    }

    public void setWest(String west) {
        this.west = west;
    }

    public String getWest() {
        return this.west;
    }

    public void setEast(String east) {
        this.east = east;
    }

    public String getEast() {
        return this.east;
    }

    public void setSouth(String south) {
        this.south = south;
    }

    public String getSouth() {
        return this.south;
    }

    public void setNorth(String north) {
        this.north = north;
    }

    public String getNorth() {
        return this.north;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setTemporal(String temporal) {
        this.temporal = temporal;
    }

    public String getTemporal() {
        return this.temporal;
    }

    public void setTime_start(String timeStart) {
        this.time_start = timeStart;
    }

    public String getTime_start() {
        return this.time_start;
    }

    public void setTime_end(String timeEnd) {
        this.time_end = timeEnd;
    }

    public String getTime_end() {
        return this.time_end;
    }

    public void setTime_duration(String timeDuration) {
        this.time_duration = timeDuration;
    }

    public String getTime_duration() {
        return this.time_duration;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getTime() {
        return this.time;
    }

    public void setTimepoint(DateType type) {
        this.timePoint = type;
    }

    public void setLLBB(LatLonRect llbb) {
        this.llbb = llbb;
    }

    public void setLatLonPoint(LatLonPoint point) {
        this.latlonPoint = point;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("QueryBean: reqType=%s resType=%s", new Object[]{this.getRequestType(), this.getResponseType()});
        if (this.spatialSelection == SpatialSelection.all) {
            f.format(" spatialSelection=all;", new Object[0]);
        } else if (this.spatialSelection == SpatialSelection.bb) {
            f.format(" bb=%s;", this.getLatLonRect());
        } else if (this.spatialSelection == SpatialSelection.stns) {
            f.format(" stns=%s;", this.getStn());
        }
        if (this.temporalSelection == TemporalSelection.all) {
            f.format(" temporalSelection=all;", new Object[0]);
        } else if (this.temporalSelection == TemporalSelection.range) {
            f.format(" range=%s;", this.getDateRange());
        }
        if (this.var != null) {
            f.format(" vars=%s", this.var);
        }
        return f.toString();
    }

    public static enum TemporalSelection {
        all,
        range,
        point;

    }

    public static enum SpatialSelection {
        all,
        bb,
        point,
        stns;

    }

    public static enum ResponseType {
        csv,
        netcdf,
        ncstream,
        html,
        xml;

    }

    public static enum RequestType {
        capabilities,
        cdl,
        data,
        dataForm,
        form,
        header,
        ncml,
        stations;

    }
}

