/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs.v1_0_0_Plus;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import thredds.util.TdsPathUtils;
import thredds.wcs.v1_0_0_Plus.DescribeCoverage;
import thredds.wcs.v1_0_0_Plus.GetCapabilities;
import thredds.wcs.v1_0_0_Plus.GetCoverage;
import thredds.wcs.v1_0_0_Plus.WcsDataset;
import thredds.wcs.v1_0_0_Plus.WcsException;
import thredds.wcs.v1_0_0_Plus.WcsRequest;
import ucar.nc2.dt.grid.GridDataset;

public class WcsRequestParser {
    private static Logger log = LoggerFactory.getLogger(WcsRequestParser.class);

    public static WcsRequest parseRequest(String version, URI serverURI, HttpServletRequest req, HttpServletResponse res) throws WcsException {
        WcsRequest.Operation operation;
        String datasetPath = TdsPathUtils.extractPath(req, "wcs/");
        ucar.nc2.dt.GridDataset gridDataset = WcsRequestParser.openDataset(req, res);
        if (gridDataset == null) {
            log.error("parseRequest(): Failed to open dataset (???).");
            throw new WcsException(WcsException.Code.CoverageNotDefined, "", "Failed to open dataset.");
        }
        WcsDataset wcsDataset = new WcsDataset(gridDataset, datasetPath);
        String requestParam = ServletUtil.getParameterIgnoreCase(req, "Request");
        try {
            operation = WcsRequest.Operation.valueOf((String)requestParam);
        }
        catch (IllegalArgumentException e) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "Request", "Unsupported operation request <" + requestParam + ">.");
        }
        if (operation.equals((Object)WcsRequest.Operation.GetCapabilities)) {
            String sectionParam = ServletUtil.getParameterIgnoreCase(req, "Section");
            String updateSequenceParam = ServletUtil.getParameterIgnoreCase(req, "UpdateSequence");
            if (sectionParam == null) {
                sectionParam = "";
            }
            GetCapabilities.Section section = null;
            try {
                section = GetCapabilities.Section.getSection((String)sectionParam);
            }
            catch (IllegalArgumentException e) {
                throw new WcsException(WcsException.Code.InvalidParameterValue, "Section", "Unsupported GetCapabilities section requested <" + sectionParam + ">.");
            }
            return new GetCapabilities(operation, version, wcsDataset, serverURI, section, updateSequenceParam, null);
        }
        if (operation.equals((Object)WcsRequest.Operation.DescribeCoverage)) {
            String coverageIdListParam = ServletUtil.getParameterIgnoreCase(req, "Coverage");
            List<String> coverageIdList = WcsRequestParser.splitCommaSeperatedList(coverageIdListParam);
            return new DescribeCoverage(operation, version, wcsDataset, coverageIdList);
        }
        if (operation.equals((Object)WcsRequest.Operation.GetCoverage)) {
            String coverageId = ServletUtil.getParameterIgnoreCase(req, "Coverage");
            String crs = ServletUtil.getParameterIgnoreCase(req, "CRS");
            String responseCRS = ServletUtil.getParameterIgnoreCase(req, "RESPONSE_CRS");
            String bbox = ServletUtil.getParameterIgnoreCase(req, "BBOX");
            String time = ServletUtil.getParameterIgnoreCase(req, "TIME");
            String rangeSubset = ServletUtil.getParameterIgnoreCase(req, "RangeSubset");
            String format = ServletUtil.getParameterIgnoreCase(req, "FORMAT");
            return new GetCoverage(operation, version, wcsDataset, coverageId, crs, responseCRS, bbox, time, rangeSubset, format);
        }
        throw new WcsException(WcsException.Code.InvalidParameterValue, "Request", "Invalid requested operation <" + requestParam + ">.");
    }

    private static List<String> splitCommaSeperatedList(String identifiers) {
        String[] idArray;
        ArrayList<String> idList = new ArrayList<String>();
        for (String anIdArray : idArray = identifiers.split(",")) {
            idList.add(anIdArray.trim());
        }
        return idList;
    }

    private static ucar.nc2.dt.GridDataset openDataset(HttpServletRequest req, HttpServletResponse res) throws WcsException {
        GridDataset dataset;
        String datasetURL = ServletUtil.getParameterIgnoreCase(req, "dataset");
        boolean isRemote = datasetURL != null;
        String datasetPath = isRemote ? datasetURL : TdsPathUtils.extractPath(req, "wcs/");
        try {
            dataset = isRemote ? GridDataset.open((String)datasetPath) : DatasetHandler.openGridDataset(req, res, datasetPath);
        }
        catch (IOException e) {
            log.warn("WcsRequestParser(): Failed to open dataset <" + datasetPath + ">: " + e.getMessage());
            throw new WcsException("Failed to open dataset, \"" + datasetPath + "\".");
        }
        if (dataset == null) {
            log.debug("WcsRequestParser(): Unknown dataset <" + datasetPath + ">.");
            throw new WcsException("Unknown dataset, \"" + datasetPath + "\".");
        }
        return dataset;
    }
}

