/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmvalidator;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import thredds.server.cdmvalidator.CdmValidatorContext;
import thredds.servlet.UsageLog;

public class CdmValidatorConfigContextListener
implements ServletContextListener {
    private Logger logger = LoggerFactory.getLogger(CdmValidatorConfigContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        this.logger.info("contextInitialized(): start - " + UsageLog.setupNonRequestContext());
        ServletContext servletContext = event.getServletContext();
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        CdmValidatorContext cdmValidatorContext = (CdmValidatorContext)wac.getBean("cdmValidatorContext", CdmValidatorContext.class);
        cdmValidatorContext.init(servletContext);
        this.logger.info("contextInitialized(): done - " + UsageLog.closingMessageNonRequestContext());
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.logger.info("contextDestroyed(): start." + UsageLog.setupNonRequestContext());
        ServletContext servletContext = event.getServletContext();
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        CdmValidatorContext cdmValidatorContext = (CdmValidatorContext)wac.getBean("cdmValidatorContext", CdmValidatorContext.class);
        cdmValidatorContext.destroy();
        this.logger.info("contextDestroyed(): Done - " + UsageLog.closingMessageNonRequestContext());
    }
}

