/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Formatter;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.server.config.FormatsAvailabilityService;
import thredds.server.config.TdsContext;
import thredds.server.ncss.controller.AbstractNcssController;
import thredds.server.ncss.controller.GridAsPointResponder;
import thredds.server.ncss.controller.GridResponder;
import thredds.server.ncss.controller.NcssDiskCache;
import thredds.server.ncss.dataservice.FeatureDatasetService;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.exception.UnsupportedOperationException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.format.SupportedOperation;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.view.dsg.DsgSubsetWriter;
import thredds.server.ncss.view.dsg.DsgSubsetWriterFactory;
import thredds.util.Constants;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;

@Controller
@RequestMapping(value={"/ncss"})
public class NcssController
extends AbstractNcssController {
    @Autowired
    FeatureDatasetService datasetService;
    @Autowired
    TdsContext tdsContext;

    @RequestMapping(value={"**"})
    public void handleRequest(HttpServletRequest req, HttpServletResponse res, @Valid NcssParamsBean params, BindingResult validationResult) throws Exception {
        block26: {
            if (validationResult.hasErrors()) {
                this.handleValidationErrorsResponse(res, 400, validationResult);
                return;
            }
            String datasetPath = NcssController.getDatasetPath(req);
            try (FeatureDataset fd = this.datasetService.findDatasetByPath(req, res, datasetPath);){
                if (fd == null) {
                    return;
                }
                Formatter errs = new Formatter();
                if (!params.intersectsTime(fd, errs)) {
                    this.handleValidationErrorMessage(res, 400, errs.toString());
                    return;
                }
                FeatureType ft = fd.getFeatureType();
                if (ft == FeatureType.GRID) {
                    if (!params.hasLatLonPoint()) {
                        this.handleRequestGrid(res, params, datasetPath, (GridDataset)fd);
                    } else {
                        this.handleRequestGridAsPoint(res, params, datasetPath, fd);
                    }
                    break block26;
                }
                if (ft == FeatureType.POINT) {
                    this.handleRequestDsg(res, params, datasetPath, fd);
                    break block26;
                }
                if (ft == FeatureType.STATION) {
                    this.handleRequestDsg(res, params, datasetPath, fd);
                    break block26;
                }
                throw new UnsupportedOperationException("Feature Type " + ft.toString() + " not supported");
            }
        }
    }

    void handleRequestGrid(HttpServletResponse res, NcssParamsBean params, String datasetPath, GridDataset gridDataset) throws IOException, NcssException, ParseException, InvalidRangeException {
        String filename;
        SupportedFormat sf = SupportedOperation.GRID_REQUEST.getSupportedFormat(params.getAccept());
        NetcdfFileWriter.Version version = NetcdfFileWriter.Version.netcdf3;
        if (sf.equals((Object)SupportedFormat.NETCDF4)) {
            if (FormatsAvailabilityService.isFormatAvailable(SupportedFormat.NETCDF4)) {
                version = NetcdfFileWriter.Version.netcdf4;
            } else {
                this.handleValidationErrorMessage(res, 400, "NetCDF-4 format not available");
                return;
            }
        }
        GridResponder gds = GridResponder.factory(gridDataset, datasetPath);
        File netcdfResult = gds.getResponseFile(res, params, version);
        String suffix = version == NetcdfFileWriter.Version.netcdf4 ? ".nc4" : ".nc";
        int pos = datasetPath.lastIndexOf("/");
        String string = filename = pos >= 0 ? datasetPath.substring(pos + 1) : datasetPath;
        if (!filename.endsWith(suffix)) {
            filename = filename + suffix;
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("Content-Type", sf.getResponseContentType());
        httpHeaders.set("Content-Disposition", Constants.setContentDispositionValue((String)filename));
        this.setResponseHeaders(res, httpHeaders);
        IO.copyFileB((File)netcdfResult, (OutputStream)res.getOutputStream(), (int)60000);
        res.flushBuffer();
        res.getOutputStream().close();
        res.setStatus(200);
    }

    void handleRequestGridAsPoint(HttpServletResponse res, NcssParamsBean params, String datasetPath, FeatureDataset fd) throws Exception {
        SupportedFormat format = SupportedOperation.POINT_REQUEST.getSupportedFormat(params.getAccept());
        DiskCache2 diskCache = NcssDiskCache.getInstance().getDiskCache();
        GridAsPointResponder pds = GridAsPointResponder.factory(diskCache, format, (OutputStream)res.getOutputStream());
        this.setResponseHeaders(res, pds.getResponseHeaders(fd, format, datasetPath));
        pds.respond(res, fd, datasetPath, params, format);
    }

    void handleRequestDsg(HttpServletResponse res, NcssParamsBean params, String datasetPath, FeatureDataset fd) throws Exception {
        SupportedOperation supportedOp;
        switch (fd.getFeatureType()) {
            case POINT: {
                supportedOp = SupportedOperation.POINT_REQUEST;
                break;
            }
            case STATION: {
                supportedOp = SupportedOperation.STATION_REQUEST;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("%s format not currently supported for DSG subset writing.", fd.getFeatureType()));
            }
        }
        SupportedFormat format = supportedOp.getSupportedFormat(params.getAccept());
        DiskCache2 diskCache = NcssDiskCache.getInstance().getDiskCache();
        DsgSubsetWriter pds = DsgSubsetWriterFactory.newInstance((FeatureDatasetPoint)fd, params, diskCache, (OutputStream)res.getOutputStream(), format);
        this.setResponseHeaders(res, pds.getResponseHeaders(fd, format, datasetPath));
        pds.respond(res, fd, datasetPath, params, format);
    }

    private void setResponseHeaders(HttpServletResponse response, HttpHeaders httpHeaders) {
        Set keySet = httpHeaders.keySet();
        for (String key : keySet) {
            if (!httpHeaders.containsKey((Object)key)) continue;
            response.setHeader(key, (String)httpHeaders.get((Object)key).get(0));
        }
    }
}

