/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote.view;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.XSLTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.cdmremote.params.CdmrfQueryBean;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.writer.FeatureDatasetPointXML;

public final class CdmrfTextViewFactory {
    private static final Logger log = LoggerFactory.getLogger(CdmrfTextViewFactory.class);
    private static CdmrfTextViewFactory INSTANCE;

    private CdmrfTextViewFactory() {
    }

    public static CdmrfTextViewFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CdmrfTextViewFactory();
        }
        return INSTANCE;
    }

    public String getFormViewForDataset(HttpServletRequest req, HttpServletResponse res, FeatureDatasetPoint fdp, String absPath, CdmrfQueryBean query) throws IOException {
        String infoString;
        block5: {
            FeatureDatasetPointXML xmlWriter = new FeatureDatasetPointXML(fdp, absPath);
            CdmrfQueryBean.RequestType reqType = query.getRequestType();
            try {
                if (reqType == CdmrfQueryBean.RequestType.capabilities) {
                    Document doc = xmlWriter.getCapabilitiesDocument();
                    XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                    infoString = fmt.outputString(doc);
                    break block5;
                }
                if (reqType == CdmrfQueryBean.RequestType.stations) {
                    Document doc = xmlWriter.makeStationCollectionDocument(query.getLatLonRect(), query.getStnNames());
                    XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                    infoString = fmt.outputString(doc);
                    break block5;
                }
                if (reqType == CdmrfQueryBean.RequestType.form) {
                    String xslt = fdp.getFeatureType() == FeatureType.STATION ? "ncssSobs.xsl" : "fmrcPoint.xsl";
                    InputStream is = this.getXSLT(xslt);
                    Document doc = xmlWriter.getCapabilitiesDocument();
                    XSLTransformer transformer = new XSLTransformer(is);
                    Document html = transformer.transform(doc);
                    XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                    infoString = fmt.outputString(html);
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                log.error("SobsServlet internal error on " + fdp.getLocation(), (Throwable)e);
                res.sendError(500, "SobsServlet internal error");
                return null;
            }
        }
        return infoString;
    }

    private InputStream getXSLT(String xslName) {
        return this.getClass().getResourceAsStream("/resources/xsl/" + xslName);
    }
}

