/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin;

import com.coverity.security.Escape;
import com.google.common.escape.Escaper;
import com.google.common.eventbus.EventBus;
import com.google.common.net.UrlEscapers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import thredds.core.DataRootManager;
import thredds.core.DatasetManager;
import thredds.featurecollection.CollectionUpdater;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.featurecollection.InvDatasetFeatureCollection;
import thredds.inventory.CollectionUpdateEvent;
import thredds.inventory.CollectionUpdateType;
import thredds.monitor.FmrcCacheMonitorImpl;
import thredds.server.admin.DebugCommands;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.config.TdsContext;
import thredds.servlet.ServletUtil;
import thredds.util.ContentType;
import thredds.util.TdsPathUtils;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

@Controller
@RequestMapping(value={"/admin/collection"})
public class AdminCollectionController {
    private static final Logger log = LoggerFactory.getLogger(AdminCollectionController.class);
    private static final String PATH = "/admin/collection";
    private static final String COLLECTION = "collection";
    private static final String SHOW_COLLECTION = "showCollection";
    private static final String SHOW = "showStatus";
    private static final String SHOW_CSV = "showStatus.csv";
    private static final String DOWNLOAD = "download";
    private static final String DOWNLOAD_ALL = "downloadAll";
    private static final String TRIGGER = "trigger";
    @Autowired
    DebugCommands debugCommands;
    @Autowired
    DataRootManager dataRootManager;
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private DatasetManager datasetManager;
    @Autowired
    @Qualifier(value="fcTriggerEventBus")
    private EventBus eventBus;
    @Autowired
    CollectionUpdater collectionUpdater;
    private static final String FMRC_PATH = "/admin/collection/showFmrc";
    private static final String STATISTICS = "cacheStatistics.txt";
    private static final String CMD = "cmd";
    private static final String FILE = "file";
    private final FmrcCacheMonitorImpl monitor = new FmrcCacheMonitorImpl();

    @PostConstruct
    public void afterPropertiesSet() {
        final Escaper urlParamEscaper = UrlEscapers.urlFormParameterEscaper();
        DebugCommands.Category debugHandler = this.debugCommands.findCategory("Collections");
        DebugCommands.Action act = new DebugCommands.Action(SHOW_COLLECTION, "Show Collections"){

            @Override
            public void doAction(DebugCommands.Event e) {
                List<FeatureCollectionRef> fcList = AdminCollectionController.this.dataRootManager.getFeatureCollections();
                Collections.sort(fcList, (o1, o2) -> o1.getCollectionName().compareTo(o2.getCollectionName()));
                for (FeatureCollectionRef fc : fcList) {
                    String uriParam = Escape.uriParam((String)fc.getCollectionName());
                    String url = AdminCollectionController.this.tdsContext.getContextPath() + AdminCollectionController.PATH + "/" + AdminCollectionController.SHOW_COLLECTION + "?" + AdminCollectionController.COLLECTION + "=" + uriParam;
                    e.pw.printf("<p/><a href='%s'>%s</a> (%s)%n", url, fc.getCollectionName(), fc.getName());
                    FeatureCollectionConfig config = fc.getConfig();
                    if (config == null) continue;
                    e.pw.printf("%s%n", config.spec);
                }
                String url = AdminCollectionController.this.tdsContext.getContextPath() + AdminCollectionController.PATH + "/" + AdminCollectionController.SHOW;
                e.pw.printf("<p/><a href='%s'>Show All Collection Status</a>%n", url);
                url = AdminCollectionController.this.tdsContext.getContextPath() + AdminCollectionController.PATH + "/" + AdminCollectionController.SHOW_CSV;
                e.pw.printf("<p/><a href='%s'>Collection Status CSV</a>%n", url);
                url = AdminCollectionController.this.tdsContext.getContextPath() + AdminCollectionController.PATH + "/" + AdminCollectionController.DOWNLOAD_ALL;
                e.pw.printf("<p/><a href='%s'>Download All top-level collection indices</a>%n", url);
            }
        };
        debugHandler.addAction(act);
        act = new DebugCommands.Action("sched", "Show FeatureCollection update scheduler"){

            @Override
            public void doAction(DebugCommands.Event e) {
                Scheduler scheduler = AdminCollectionController.this.collectionUpdater.getScheduler();
                if (scheduler == null) {
                    return;
                }
                try {
                    e.pw.println(scheduler.getMetaData());
                    List groups = scheduler.getJobGroupNames();
                    List triggers = scheduler.getTriggerGroupNames();
                    for (String group : scheduler.getJobGroupNames()) {
                        e.pw.println("Group " + group);
                        for (JobKey jobKey : scheduler.getJobKeys(GroupMatcher.groupEquals((String)group))) {
                            e.pw.println("  Job " + jobKey.getName());
                            e.pw.println("    " + scheduler.getJobDetail(jobKey));
                        }
                        for (TriggerKey triggerKey : scheduler.getTriggerKeys(GroupMatcher.groupEquals((String)group))) {
                            e.pw.println("  Trigger " + triggerKey.getName());
                            e.pw.println("    " + scheduler.getTrigger(triggerKey));
                        }
                    }
                }
                catch (Exception e1) {
                    e.pw.println("Error on scheduler " + e1.getMessage());
                    log.error("Error on scheduler " + e1.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugCommands.Action("showFmrcCache", "Show FMRC Cache"){

            @Override
            public void doAction(DebugCommands.Event e) {
                e.pw.println("<p>cache location = " + AdminCollectionController.this.monitor.getCacheLocation() + "<p>");
                String statUrl = AdminCollectionController.this.tdsContext.getContextPath() + AdminCollectionController.FMRC_PATH + "/" + AdminCollectionController.STATISTICS;
                e.pw.println("<p/> <a href='" + statUrl + "'>Show Cache Statistics</a>");
                for (String name : AdminCollectionController.this.monitor.getCachedCollections()) {
                    String ename = urlParamEscaper.escape(name);
                    String url = AdminCollectionController.this.tdsContext.getContextPath() + AdminCollectionController.FMRC_PATH + "?" + AdminCollectionController.COLLECTION + "=" + ename;
                    e.pw.println("<p/> <a href='" + url + "'>" + Escape.html((String)name) + "</a>");
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugCommands.Action("syncFmrcCache", "Flush FMRC Cache to disk"){

            @Override
            public void doAction(DebugCommands.Event e) {
                AdminCollectionController.this.monitor.sync();
                e.pw.println("<p>bdb cache location = " + AdminCollectionController.this.monitor.getCacheLocation() + "<p> flushed to disk");
            }
        };
        debugHandler.addAction(act);
    }

    @RequestMapping(value={"/showCollection"}, method={RequestMethod.GET})
    protected ResponseEntity<String> showCollection(@RequestParam String collection) throws Exception {
        Formatter out = new Formatter();
        FeatureCollectionRef want = this.dataRootManager.findFeatureCollection(collection);
        HttpStatus status = HttpStatus.OK;
        if (want == null) {
            status = HttpStatus.NOT_FOUND;
            out.format("NOT FOUND", new Object[0]);
        } else {
            out.format("<h3>Collection %s</h3>%n%n", Escape.html((String)collection));
            this.showFeatureCollection(out, want);
            String uriParam = Escape.uriParam((String)want.getCollectionName());
            String url = this.tdsContext.getContextPath() + PATH + "/" + TRIGGER + "?" + COLLECTION + "=" + uriParam + "&" + TRIGGER + "=" + CollectionUpdateType.nocheck;
            out.format("<p/><a href='%s'>Send trigger to %s</a>%n", url, Escape.html((String)want.getCollectionName()));
            String url2 = this.tdsContext.getContextPath() + PATH + "/" + DOWNLOAD + "?" + COLLECTION + "=" + uriParam;
            out.format("<p/><a href='%s'>Download index file for %s</a>%n", url2, Escape.html((String)want.getCollectionName()));
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_HTML);
        return new ResponseEntity((Object)out.toString(), (MultiValueMap)responseHeaders, status);
    }

    @RequestMapping(value={"/showStatus"})
    protected ResponseEntity<String> showCollectionStatus() throws Exception {
        Formatter out = new Formatter();
        List<FeatureCollectionRef> fcList = this.dataRootManager.getFeatureCollections();
        Collections.sort(fcList, (o1, o2) -> o1.getCollectionName().compareTo(o2.getCollectionName()));
        for (FeatureCollectionRef fc : fcList) {
            String uriParam = Escape.uriParam((String)fc.getCollectionName());
            String url = this.tdsContext.getContextPath() + PATH + "?" + COLLECTION + "=" + uriParam;
            out.format("<p/><a href='%s'>%s</a> (%s)%n", url, fc.getCollectionName(), fc.getName());
            InvDatasetFeatureCollection fcd = this.datasetManager.openFeatureCollection(fc);
            out.format("<pre>%s</pre>%n", fcd.showStatusShort("txt"));
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_HTML);
        return new ResponseEntity((Object)out.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/showStatus.csv"})
    protected ResponseEntity<String> showCollectionStatusCsv() throws Exception {
        Formatter out = new Formatter();
        List<FeatureCollectionRef> fcList = this.dataRootManager.getFeatureCollections();
        Collections.sort(fcList, (o1, o2) -> {
            int compareType = o1.getConfig().type.toString().compareTo(o1.getConfig().type.toString());
            if (compareType != 0) {
                return compareType;
            }
            return o1.getCollectionName().compareTo(o2.getCollectionName());
        });
        out.format("%s, %s, %s, %s, %s, %s, %s, %s, %s%n", COLLECTION, "ed", "type", "group", "nrecords", "ndups", "%", "nmiss", "%");
        for (FeatureCollectionRef fc : fcList) {
            if (fc.getConfig().type != FeatureCollectionType.GRIB1 && fc.getConfig().type != FeatureCollectionType.GRIB2) continue;
            InvDatasetFeatureCollection fcd = this.datasetManager.openFeatureCollection(fc);
            out.format("%s", fcd.showStatusShort("csv"));
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)out.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/trigger"})
    protected ResponseEntity<String> triggerFeatureCollection(HttpServletRequest req, HttpServletResponse res) throws Exception {
        Formatter out = new Formatter();
        CollectionUpdateType triggerType = null;
        String triggerTypeS = req.getParameter(TRIGGER);
        try {
            triggerType = CollectionUpdateType.valueOf((String)triggerTypeS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (triggerType == null) {
            res.setStatus(400);
            out.format(" TRIGGER Type '%s' not legal%n", Escape.html((String)triggerTypeS));
            return null;
        }
        String collectName = StringUtil2.unescape((String)req.getParameter(COLLECTION));
        FeatureCollectionRef want = this.dataRootManager.findFeatureCollection(collectName);
        if (want == null) {
            res.setStatus(404);
            out.format("NOT FOUND", new Object[0]);
        } else {
            out.format("<h3>Collection %s</h3>%n", Escape.html((String)collectName));
            if (!want.getConfig().isTrigggerOk()) {
                res.setStatus(403);
                out.format(" TRIGGER NOT ENABLED%n", new Object[0]);
            } else {
                this.eventBus.post((Object)new CollectionUpdateEvent(triggerType, collectName, TRIGGER));
                out.format(" TRIGGER SENT%n", new Object[0]);
            }
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_HTML);
        return new ResponseEntity((Object)out.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/downloadAll"})
    protected void downloadAll(HttpServletRequest req, HttpServletResponse res) throws IOException {
        File tempFile = File.createTempFile("CollectionIndex", ".zip");
        try (FileOutputStream fos = new FileOutputStream(tempFile.getPath());){
            ZipOutputStream zout = new ZipOutputStream(fos);
            for (FeatureCollectionRef fc : this.dataRootManager.getFeatureCollections()) {
                File idxFile = GribCdmIndex.getTopIndexFileFromConfig((FeatureCollectionConfig)fc.getConfig());
                if (idxFile == null) continue;
                ZipEntry entry = new ZipEntry(idxFile.getName());
                zout.putNextEntry(entry);
                IO.copyFile((String)idxFile.getPath(), (OutputStream)zout);
                zout.closeEntry();
            }
            zout.close();
            fos.close();
        }
        ServletUtil.returnFile(req, res, tempFile, ContentType.binary.toString());
    }

    @RequestMapping(value={"/download"})
    protected ResponseEntity<String> downloadIndex(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String collectName = StringUtil2.unescape((String)req.getParameter(COLLECTION));
        FeatureCollectionRef want = this.dataRootManager.findFeatureCollection(collectName);
        if (want == null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setContentType(MediaType.TEXT_PLAIN);
            return new ResponseEntity((Object)(Escape.html((String)collectName) + " NOT FOUND"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        File idxFile = GribCdmIndex.getTopIndexFileFromConfig((FeatureCollectionConfig)want.getConfig());
        if (idxFile == null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setContentType(MediaType.TEXT_PLAIN);
            return new ResponseEntity((Object)(Escape.html((String)collectName) + " NOT FOUND"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        ServletUtil.returnFile(req, res, idxFile, ContentType.binary.toString());
        return null;
    }

    private void showFeatureCollection(Formatter out, FeatureCollectionRef fc) throws IOException {
        FeatureCollectionConfig config = fc.getConfig();
        if (config != null) {
            Formatter f = new Formatter();
            config.show(f);
            out.format("%n<pre>%s%n</pre>", f.toString());
        }
        InvDatasetFeatureCollection fcd = this.datasetManager.openFeatureCollection(fc);
        out.format("%n<pre>%n", new Object[0]);
        fcd.showStatus(out);
        out.format("%n</pre>%n", new Object[0]);
    }

    @RequestMapping(value={"/showFmrc", "/showFmrc/*"})
    protected ModelAndView showFmrcCache(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String path = TdsPathUtils.extractPath(req, "admin/");
        if (path.endsWith(STATISTICS)) {
            res.setContentType(ContentType.text.getContentHeader());
            Formatter f = new Formatter();
            this.monitor.getCacheStatistics(f);
            String s = f.toString();
            PrintWriter pw = res.getWriter();
            pw.println(s);
            pw.flush();
            return null;
        }
        String collectName = StringUtil2.unescape((String)req.getParameter(COLLECTION));
        String fileName = req.getParameter(FILE);
        String cmd = req.getParameter(CMD);
        if (fileName != null) {
            String ufilename = URLDecoder.decode(fileName, "UTF-8");
            String contents = this.monitor.getCachedFile(collectName, ufilename);
            if (null == contents) {
                res.setContentType(ContentType.html.getContentHeader());
                PrintWriter pw = res.getWriter();
                pw.println("<p/> Cant find filename=" + Escape.html((String)fileName) + " in collection = " + Escape.html((String)collectName));
            } else {
                res.setContentType(ContentType.xml.getContentHeader());
                PrintWriter pw = res.getWriter();
                pw.println(contents);
            }
            return null;
        }
        if (collectName != null) {
            String ecollectName = Escape.uriParam((String)collectName);
            String url = this.tdsContext.getContextPath() + FMRC_PATH + "?" + COLLECTION + "=" + ecollectName;
            res.setContentType(ContentType.html.getContentHeader());
            PrintWriter pw = res.getWriter();
            pw.println("Files for collection = " + Escape.html((String)collectName) + "");
            String deleteUrl = this.tdsContext.getContextPath() + FMRC_PATH + "?" + COLLECTION + "=" + ecollectName + "&" + CMD + "=delete";
            pw.println("<a href='" + deleteUrl + "'> Delete Cache</a>");
            pw.println("<ol>");
            for (String filename : this.monitor.getFilesInCollection(collectName)) {
                String efileName = URLEncoder.encode(filename, "UTF-8");
                pw.println("<li> <a href='" + url + "&" + FILE + "=" + efileName + "'>" + filename + "</a>");
            }
            pw.println("</ol>");
        }
        if (cmd != null && cmd.equals("delete")) {
            res.setContentType(ContentType.html.getContentHeader());
            PrintWriter pw = res.getWriter();
            try {
                this.monitor.deleteCollection(collectName);
                pw.println("<p/>deleted");
            }
            catch (Exception e) {
                pw.println("<pre>delete failed on collection = " + Escape.html((String)collectName));
                e.printStackTrace(pw);
                pw.println("</pre>");
            }
        }
        return null;
    }
}

