/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import thredds.client.catalog.Dataset;
import ucar.nc2.units.DateType;
import ucar.unidata.util.Format;

class CatalogItemContext {
    private String displayName;
    private int level;
    private String dataSize;
    private String lastModified;
    private String iconSrc;
    private String itemhref;

    public CatalogItemContext(Dataset ds, int level) {
        DateType lastModDateType;
        this.displayName = ds.getName();
        double size = ds.getDataSize();
        if (size > 0.0 && !Double.isNaN(size)) {
            this.dataSize = Format.formatByteSize((double)size);
        }
        if ((lastModDateType = ds.getLastModifiedDate()) != null) {
            this.lastModified = lastModDateType.toDateTimeString();
        }
        this.level = level;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getLevel() {
        return this.level;
    }

    public String getDataSize() {
        return this.dataSize;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public String getIconSrc() {
        return this.iconSrc;
    }

    protected void setIconSrc(String iconSrc) {
        this.iconSrc = iconSrc;
    }

    public String getHref() {
        return this.itemhref;
    }

    protected void setHref(String href) {
        this.itemhref = href;
    }
}

