/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import thredds.server.config.TdsContext;
import thredds.server.config.ThreddsConfig;
import thredds.servlet.ServletUtil;
import ucar.nc2.util.DiskCache2;

@Component
@DependsOn(value={"TdsContext"})
public final class NcssDiskCache {
    @Autowired
    private TdsContext tdsContext;
    private DiskCache2 diskCache;
    private String cachePath;

    public NcssDiskCache() {
    }

    public void init() {
        String defaultPath = new File(this.tdsContext.getThreddsDirectory(), "/cache/ncss/").getPath();
        this.cachePath = ThreddsConfig.get("NetcdfSubsetService.dir", defaultPath);
        File cacheDir = new File(this.cachePath);
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            ServletUtil.logServerStartup.error("Cant make cache directory " + this.cachePath);
            throw new IllegalArgumentException("Cant make cache directory " + this.cachePath);
        }
        int scourSecs = ThreddsConfig.getSeconds("NetcdfSubsetService.scour", 600);
        int maxAgeSecs = ThreddsConfig.getSeconds("NetcdfSubsetService.maxAge", -1);
        maxAgeSecs = Math.max(maxAgeSecs, 300);
        scourSecs = Math.max(scourSecs, 300);
        this.diskCache = new DiskCache2(this.cachePath, false, maxAgeSecs / 60, scourSecs / 60);
        ServletUtil.logServerStartup.info(this.getClass().getName() + "Ncss.Cache= " + this.cachePath + " scour = " + scourSecs + " maxAgeSecs = " + maxAgeSecs);
    }

    public DiskCache2 getDiskCache() {
        return this.diskCache;
    }

    public String getServletCachePath() {
        String contextPath = this.tdsContext == null ? "" : this.tdsContext.getContextPath();
        return contextPath + this.cachePath + "/";
    }

    public NcssDiskCache(String cachePath) {
        this.cachePath = cachePath;
        this.diskCache = new DiskCache2(cachePath, false, 0, 0);
    }
}

