/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.params;

import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.validation.NcssGridRequestConstraint;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionRect;

@NcssGridRequestConstraint
public class NcssGridParamsBean
extends NcssParamsBean {
    private Double minx;
    private Double maxx;
    private Double miny;
    private Double maxy;
    private boolean addLatLon;
    private Integer horizStride = 1;
    private Integer timeStride = 1;
    private Double vertCoord;
    private Double ensCoord;
    private String runtime;
    private String timeOffset;
    protected Double timeOffsetVal;
    protected boolean firstTimeOffset;
    protected CalendarDate runtimeDate;
    protected boolean latestRuntime;
    protected boolean allRuntime;

    public Double getMinx() {
        return this.minx;
    }

    public void setMinx(Double minx) {
        this.minx = minx;
    }

    public Double getMaxx() {
        return this.maxx;
    }

    public void setMaxx(Double maxx) {
        this.maxx = maxx;
    }

    public Double getMiny() {
        return this.miny;
    }

    public void setMiny(Double miny) {
        this.miny = miny;
    }

    public Double getMaxy() {
        return this.maxy;
    }

    public void setMaxy(Double maxy) {
        this.maxy = maxy;
    }

    public boolean isAddLatLon() {
        return this.addLatLon;
    }

    public void setAddLatLon(boolean addLatLon) {
        this.addLatLon = addLatLon;
    }

    public Integer getHorizStride() {
        return this.horizStride;
    }

    public void setHorizStride(Integer horizStride) {
        this.horizStride = horizStride;
    }

    public Integer getTimeStride() {
        return this.timeStride;
    }

    public void setTimeStride(Integer timeStride) {
        this.timeStride = timeStride;
    }

    public boolean hasProjectionBB() {
        return this.minx != null && this.miny != null && this.maxx != null && this.maxy != null;
    }

    public ProjectionRect getProjectionBB() {
        return new ProjectionRect(this.minx.doubleValue(), this.miny.doubleValue(), this.maxx.doubleValue(), this.maxy.doubleValue());
    }

    public Double getVertCoord() {
        return this.vertCoord;
    }

    public void setVertCoord(Double vertCoord) {
        this.vertCoord = vertCoord;
    }

    public Double getEnsCoord() {
        return this.ensCoord;
    }

    public void setEnsCoord(Double ensCoord) {
        this.ensCoord = ensCoord;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(String timeOffset) {
        this.timeOffset = timeOffset;
    }

    public void setTimeOffsetVal(Double timeOffsetVal) {
        this.timeOffsetVal = timeOffsetVal;
    }

    public void setFirstTimeOffset(boolean firstTimeOffset) {
        this.firstTimeOffset = firstTimeOffset;
    }

    public void setLatestRuntime(boolean b) {
        this.latestRuntime = b;
    }

    public void setAllRuntime(boolean b) {
        this.allRuntime = b;
    }

    public void setRuntimeDate(CalendarDate runtimeDate) {
        this.runtimeDate = runtimeDate;
    }

    public CalendarDate getRuntimeDate(Calendar cal) {
        if (this.runtimeDate == null) {
            return null;
        }
        if (cal.equals((Object)Calendar.getDefault())) {
            return this.runtimeDate;
        }
        if (this.getTime().equalsIgnoreCase("present")) {
            return CalendarDate.present((Calendar)cal);
        }
        return CalendarDateFormatter.isoStringToCalendarDate((Calendar)cal, (String)this.getRuntime());
    }

    public SubsetParams makeSubset(CoverageCollection gcd) {
        Calendar cal = gcd.getCalendar();
        boolean isFmrc = gcd.getCoverageType() == FeatureType.FMRC;
        SubsetParams subset = new SubsetParams();
        subset.set("var", (Object)this.var);
        if (this.vertCoord != null) {
            subset.set("vertCoord", (Object)this.vertCoord);
        }
        if (this.ensCoord != null) {
            subset.set("ensCoord", (Object)this.ensCoord);
        }
        if (this.hasProjectionBB()) {
            subset.set("projBB", (Object)this.getProjectionBB());
        } else if (this.hasLatLonBB()) {
            subset.set("latlonBB", (Object)this.getLatLonBoundingBox());
        }
        if (this.horizStride != null && this.horizStride != 1) {
            subset.set("horizStride", (Object)this.horizStride);
        }
        if (this.hasLatLonPoint()) {
            subset.set("latlonPoint", (Object)new LatLonPointImpl(this.getLatitude().doubleValue(), this.getLongitude().doubleValue()));
        }
        if (isFmrc) {
            CalendarDate rundate = this.getRuntimeDate(cal);
            if (rundate != null) {
                subset.set("runtime", (Object)rundate);
            } else if (this.allRuntime) {
                subset.set("runtimeAll", (Object)true);
            } else {
                subset.set("runtimeLatest", (Object)true);
            }
            if (this.timeOffsetVal != null) {
                subset.set("timeOffset", (Object)this.timeOffsetVal);
            } else if (this.firstTimeOffset) {
                subset.set("timeOffsetFirst", (Object)true);
            } else {
                CalendarDate date = this.getRequestedDate(cal);
                CalendarDateRange dateRange = this.getCalendarDateRange(cal);
                if (this.isPresentTime()) {
                    subset.setTimePresent();
                } else if (this.isAllTimes() && !this.allRuntime) {
                    subset.set("timeAll", (Object)true);
                    if (this.timeStride != null && this.timeStride != 1) {
                        subset.set("timeStride", (Object)this.timeStride);
                    }
                } else if (date != null) {
                    subset.set("time", (Object)date);
                } else if (dateRange != null && !this.allRuntime) {
                    subset.set("timeRange", (Object)dateRange);
                    if (this.timeStride != null && this.timeStride != 1) {
                        subset.set("timeStride", (Object)this.timeStride);
                    }
                }
            }
        } else {
            CalendarDate date = this.getRequestedDate(cal);
            CalendarDateRange dateRange = this.getCalendarDateRange(cal);
            if (this.isPresentTime()) {
                subset.setTimePresent();
            } else if (this.isAllTimes()) {
                subset.set("timeAll", (Object)true);
                if (this.timeStride != null && this.timeStride != 1) {
                    subset.set("timeStride", (Object)this.timeStride);
                }
            } else if (date != null) {
                subset.set("time", (Object)date);
            } else if (dateRange != null) {
                subset.set("timeRange", (Object)dateRange);
                if (this.timeStride != null && this.timeStride != 1) {
                    subset.set("timeStride", (Object)this.timeStride);
                }
            } else {
                subset.set("timePresent", (Object)true);
            }
        }
        return subset;
    }
}

