/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs.v1_0_0_1;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import thredds.server.wcs.v1_0_0_1.WcsCoverage;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordSys;

public class WcsDataset {
    private String datasetPath;
    private String datasetName;
    private CoverageCollection dataset;
    private Map<String, WcsCoverage> availableCoverages;

    public WcsDataset(CoverageCollection dataset, String datasetPath) {
        this.datasetPath = datasetPath;
        int pos = datasetPath.lastIndexOf("/");
        this.datasetName = pos > 0 ? datasetPath.substring(pos + 1) : datasetPath;
        this.dataset = dataset;
        this.availableCoverages = new HashMap<String, WcsCoverage>();
        for (Coverage coverage : this.dataset.getCoverages()) {
            CoverageCoordSys gcs = coverage.getCoordSys();
            if (!gcs.isRegularSpatial()) continue;
            this.availableCoverages.put(coverage.getName(), new WcsCoverage(coverage, gcs, this));
        }
    }

    public String getDatasetPath() {
        return this.datasetPath;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public CoverageCollection getDataset() {
        return this.dataset;
    }

    public void close() throws IOException {
        if (this.dataset != null) {
            this.dataset.close();
        }
    }

    public boolean isAvailableCoverageName(String fullName) {
        return this.availableCoverages.containsKey(fullName);
    }

    public WcsCoverage getAvailableCoverage(String fullName) {
        return this.availableCoverages.get(fullName);
    }

    public Collection<WcsCoverage> getAvailableCoverageCollection() {
        return Collections.unmodifiableCollection(this.availableCoverages.values());
    }
}

