/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.filter.OncePerRequestFilter;
import thredds.server.config.CorsConfigBean;

public class RequestCORSFilter
extends OncePerRequestFilter {
    @Autowired
    private CorsConfigBean corsConfig;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.corsConfig.isEnabled()) {
            response.addHeader("Access-Control-Allow-Origin", this.corsConfig.getAllowedOrigin());
            if (request.getHeader("Access-Control-Request-Method") != null && "OPTIONS".equals(request.getMethod())) {
                response.addHeader("Access-Control-Allow-Methods", this.corsConfig.getAllowedMethods());
                if (!this.corsConfig.getAllowedHeaders().isEmpty()) {
                    response.addHeader("Access-Control-Allow-Headers", this.corsConfig.getAllowedHeaders());
                }
                response.addHeader("Access-Control-Max-Age", Integer.toString(this.corsConfig.getMaxAge()));
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

