/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote;

import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import thredds.core.AllowedServices;
import thredds.core.StandardService;
import thredds.core.TdsRequestedDataset;
import thredds.server.cdmremote.CdmRemoteQueryBean;
import thredds.server.cdmremote.CdmRemoteQueryBeanValidator;
import thredds.server.config.TdsContext;
import thredds.server.exception.ServiceNotAllowed;
import thredds.servlet.ServletUtil;
import thredds.util.ContentType;
import thredds.util.TdsPathUtils;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.stream.NcStreamWriter;

@Controller
@RequestMapping(value={"/cdmremote"})
public class CdmRemoteController {
    private static final Logger log = LoggerFactory.getLogger(CdmRemoteController.class);
    private static final boolean debug = false;
    private static final boolean showReq = false;
    @Autowired
    TdsContext tdsContext;
    @Autowired
    private AllowedServices allowedServices;

    @InitBinder(value={"CdmRemoteQueryBean"})
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new CdmRemoteQueryBeanValidator());
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET})
    public ResponseEntity<String> handleCapabilitiesRequest(HttpServletRequest request, HttpServletResponse response, @RequestParam String req) throws IOException {
        if (!this.allowedServices.isAllowed(StandardService.cdmRemote)) {
            throw new ServiceNotAllowed(StandardService.cdmRemote.toString());
        }
        String datasetPath = TdsPathUtils.extractPath(request, "/cdmremote");
        String absPath = this.getAbsolutePath(request);
        try (NetcdfFile ncfile = TdsRequestedDataset.getNetcdfFile(request, response, datasetPath);){
            if (ncfile == null) {
                ResponseEntity<String> responseEntity = null;
                return responseEntity;
            }
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setDate("Last-Modified", TdsRequestedDataset.getLastModified(datasetPath));
            if (req == null) {
                response.setContentType(ContentType.binary.getContentHeader());
                response.setHeader("Content-Description", "ncstream");
                ResponseEntity responseEntity = new ResponseEntity(null, (MultiValueMap)responseHeaders, HttpStatus.OK);
                return responseEntity;
            }
            switch (req.toLowerCase()) {
                case "form": 
                case "cdl": {
                    ncfile.setLocation(datasetPath);
                    String cdl = ncfile.toString();
                    responseHeaders.set("Content-Type", ContentType.text.getContentHeader());
                    ResponseEntity responseEntity = new ResponseEntity((Object)cdl, (MultiValueMap)responseHeaders, HttpStatus.OK);
                    return responseEntity;
                }
                case "ncml": {
                    String ncml = ncfile.toNcML(absPath);
                    responseHeaders.set("Content-Type", ContentType.xml.getContentHeader());
                    ResponseEntity responseEntity = new ResponseEntity((Object)ncml, (MultiValueMap)responseHeaders, HttpStatus.OK);
                    return responseEntity;
                }
            }
            ResponseEntity responseEntity = new ResponseEntity((Object)"Unrecognized request", null, HttpStatus.BAD_REQUEST);
            return responseEntity;
        }
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET}, params={"req=capabilities"})
    public ModelAndView handleCapabilitiesRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.allowedServices.isAllowed(StandardService.cdmRemote)) {
            throw new ServiceNotAllowed(StandardService.cdmRemote.toString());
        }
        String datasetPath = TdsPathUtils.extractPath(request, "/cdmremote");
        String absPath = this.getAbsolutePath(request);
        try (NetcdfFile ncfile = TdsRequestedDataset.getNetcdfFile(request, response, datasetPath);){
            if (ncfile == null) {
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            Element rootElem = new Element("cdmRemoteCapabilities");
            Document doc = new Document(rootElem);
            rootElem.setAttribute("location", absPath);
            Element elem = new Element("featureDataset");
            FeatureType ftFromMetadata = FeatureDatasetFactoryManager.findFeatureType((NetcdfFile)ncfile);
            if (ftFromMetadata != null) {
                elem.setAttribute("type", ftFromMetadata.toString());
            }
            elem.setAttribute("url", absPath);
            rootElem.addContent((Content)elem);
            ModelAndView modelAndView = new ModelAndView("threddsXmlView", "Document", (Object)doc);
            return modelAndView;
        }
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET}, params={"req=header"})
    public void handleHeaderRequest(HttpServletRequest request, HttpServletResponse response, OutputStream out) throws IOException {
        if (!this.allowedServices.isAllowed(StandardService.cdmRemote)) {
            throw new ServiceNotAllowed(StandardService.cdmRemote.toString());
        }
        String datasetPath = TdsPathUtils.extractPath(request, "/cdmremote");
        String absPath = this.getAbsolutePath(request);
        try (NetcdfFile ncfile = TdsRequestedDataset.getNetcdfFile(request, response, datasetPath);){
            if (ncfile == null) {
                return;
            }
            response.setContentType(ContentType.binary.getContentHeader());
            response.setHeader("Content-Description", "ncstream");
            response.addDateHeader("Last-Modified", TdsRequestedDataset.getLastModified(datasetPath));
            NcStreamWriter ncWriter = new NcStreamWriter(ncfile, ServletUtil.getRequestBase(request));
            long size = ncWriter.sendHeader(out);
            out.flush();
        }
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET}, params={"req=data"})
    public void handleDataRequest(HttpServletRequest request, HttpServletResponse response, @Valid CdmRemoteQueryBean qb, BindingResult validationResult, OutputStream out) throws IOException, BindException, InvalidRangeException {
        if (!this.allowedServices.isAllowed(StandardService.cdmRemote)) {
            throw new ServiceNotAllowed(StandardService.cdmRemote.toString());
        }
        if (validationResult.hasErrors()) {
            throw new BindException(validationResult);
        }
        String datasetPath = TdsPathUtils.extractPath(request, "/cdmremote");
        String absPath = this.getAbsolutePath(request);
        long start = System.currentTimeMillis();
        try (NetcdfFile ncfile = TdsRequestedDataset.getNetcdfFile(request, response, datasetPath);){
            if (ncfile == null) {
                return;
            }
            response.setContentType(ContentType.binary.getContentHeader());
            response.setHeader("Content-Description", "ncstream");
            long size = 0L;
            NcStreamWriter ncWriter = new NcStreamWriter(ncfile, ServletUtil.getRequestBase(request));
            String query = qb.getVar() != null ? qb.getVar() : request.getQueryString();
            if (query == null || query.length() == 0) {
                response.sendError(400, "must have query string");
                return;
            }
            StringTokenizer stoke = new StringTokenizer(query, ";");
            while (stoke.hasMoreTokens()) {
                ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)ncfile, (String)stoke.nextToken());
                size += ncWriter.sendData2(cer.v, cer.section, out, qb.getCompression());
            }
            out.flush();
        }
    }

    private String getAbsolutePath(HttpServletRequest req) {
        return ServletUtil.getRequestServer(req) + req.getContextPath() + req.getServletPath();
    }
}

