/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import thredds.core.AllowedServices;
import thredds.core.StandardService;
import thredds.core.TdsRequestedDataset;
import thredds.server.config.ThreddsConfig;
import thredds.server.exception.RequestTooLargeException;
import thredds.server.exception.ServiceNotAllowed;
import thredds.server.ncss.controller.AbstractNcssController;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.exception.VariableNotContainedInDatasetException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.format.SupportedOperation;
import thredds.server.ncss.params.NcssGridParamsBean;
import thredds.server.ncss.view.dsg.DsgSubsetWriter;
import thredds.server.ncss.view.dsg.DsgSubsetWriterFactory;
import thredds.util.Constants;
import thredds.util.TdsPathUtils;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.writer.CFGridCoverageWriter2;
import ucar.nc2.ft2.coverage.writer.CoverageAsPoint;
import ucar.nc2.util.IO;
import ucar.nc2.util.Optional;

@Controller
@RequestMapping(value={"/ncss/grid"})
public class NcssGridController
extends AbstractNcssController {
    private static final short ESTIMATED_COMPRESION_RATE = 4;
    @Autowired
    private AllowedServices allowedServices;

    @Override
    protected String getBase() {
        return StandardService.netcdfSubsetGrid.getBase();
    }

    @RequestMapping(value={"**"})
    public void handleRequest(HttpServletRequest req, HttpServletResponse res, @Valid NcssGridParamsBean params, BindingResult validationResult) throws Exception {
        if (!this.allowedServices.isAllowed(StandardService.netcdfSubsetGrid)) {
            throw new ServiceNotAllowed(StandardService.netcdfSubsetGrid.toString());
        }
        if (validationResult.hasErrors()) {
            throw new BindException(validationResult);
        }
        String datasetPath = this.getDatasetPath(req);
        try (CoverageCollection gcd = TdsRequestedDataset.getCoverageCollection(req, res, datasetPath);){
            if (gcd == null) {
                return;
            }
            Formatter errs = new Formatter();
            if (!params.intersectsTime(gcd.getCalendarDateRange(), errs)) {
                this.handleValidationErrorMessage(res, 400, errs.toString());
                return;
            }
            this.checkRequestedVars(gcd, params);
            if (params.hasLatLonPoint()) {
                this.handleRequestGridAsPoint(res, params, datasetPath, gcd);
            } else {
                this.handleRequestGrid(res, params, datasetPath, gcd);
            }
        }
    }

    private void handleRequestGrid(HttpServletResponse res, NcssGridParamsBean params, String datasetPath, CoverageCollection gcd) throws IOException, NcssException, ParseException, InvalidRangeException {
        String filename;
        NetcdfFileWriter.Version version;
        SupportedFormat sf = SupportedOperation.GRID_REQUEST.getSupportedFormat(params.getAccept());
        NetcdfFileWriter.Version version2 = version = sf == SupportedFormat.NETCDF3 ? NetcdfFileWriter.Version.netcdf3 : NetcdfFileWriter.Version.netcdf4;
        if (params.getVertCoord() != null && !this.checkVarsHaveSameVertAxis(gcd, params)) {
            throw new NcssException("The variables requested: " + params.getVar() + " have different vertical levels. Grid requests with vertCoord must have variables with same vertical levels.");
        }
        String responseFile = this.getResponseFileName(datasetPath, version);
        File netcdfResult = this.makeCFNetcdfFile(gcd, responseFile, params, version);
        String suffix = version.getSuffix();
        int pos = datasetPath.lastIndexOf("/");
        String string = filename = pos >= 0 ? datasetPath.substring(pos + 1) : datasetPath;
        if (!filename.endsWith(suffix)) {
            filename = filename + suffix;
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("Content-Type", sf.getMimeType());
        httpHeaders.set("Content-Disposition", Constants.setContentDispositionValue((String)filename));
        httpHeaders.set("Content-Length", Constants.getContentLengthValue((File)netcdfResult));
        this.setResponseHeaders(res, httpHeaders);
        IO.copyFileB((File)netcdfResult, (OutputStream)res.getOutputStream(), (int)60000);
        res.flushBuffer();
        res.getOutputStream().close();
        res.setStatus(200);
    }

    File makeCFNetcdfFile(CoverageCollection gcd, String responseFilename, NcssGridParamsBean params, NetcdfFileWriter.Version version) throws NcssException, InvalidRangeException, ParseException, IOException {
        Optional estimatedSizeo;
        NetcdfFileWriter writer = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)version, (String)responseFilename, null);
        SubsetParams subset = params.makeSubset(gcd);
        long maxFileDownloadSize = ThreddsConfig.getBytes("NetcdfSubsetService.maxFileDownloadSize", -1L);
        if (maxFileDownloadSize > 0L) {
            estimatedSizeo = CFGridCoverageWriter2.writeOrTestSize((CoverageCollection)gcd, params.getVar(), (SubsetParams)subset, (boolean)params.isAddLatLon(), (boolean)true, (NetcdfFileWriter)writer);
            if (!estimatedSizeo.isPresent()) {
                throw new InvalidRangeException("Request contains no data: " + estimatedSizeo.getErrorMessage());
            }
            long estimatedSize = (Long)estimatedSizeo.get();
            if (version == NetcdfFileWriter.Version.netcdf4) {
                estimatedSize /= 4L;
            }
            if (estimatedSize > maxFileDownloadSize) {
                throw new RequestTooLargeException("NCSS response too large = " + estimatedSize + " max = " + maxFileDownloadSize);
            }
        }
        if (!(estimatedSizeo = CFGridCoverageWriter2.writeOrTestSize((CoverageCollection)gcd, params.getVar(), (SubsetParams)subset, (boolean)params.isAddLatLon(), (boolean)false, (NetcdfFileWriter)writer)).isPresent()) {
            throw new InvalidRangeException("Request contains no data: " + estimatedSizeo.getErrorMessage());
        }
        return new File(responseFilename);
    }

    private String getResponseFileName(String requestPathInfo, NetcdfFileWriter.Version version) {
        Random random = new Random(System.currentTimeMillis());
        int randomInt = random.nextInt();
        String filename = TdsPathUtils.getFileNameForResponse(requestPathInfo, version);
        String pathname = Integer.toString(randomInt) + "/" + filename;
        File ncFile = this.ncssDiskCache.getDiskCache().getCacheFile(pathname);
        if (ncFile == null) {
            throw new IllegalStateException("NCSS misconfigured cache");
        }
        return ncFile.getPath();
    }

    private void handleRequestGridAsPoint(HttpServletResponse res, NcssGridParamsBean params, String datasetPath, CoverageCollection gcd) throws Exception {
        SupportedFormat sf = SupportedOperation.POINT_REQUEST.getSupportedFormat(params.getAccept());
        CoverageAsPoint covp = new CoverageAsPoint(gcd, params.getVar(), params.makeSubset(gcd));
        try (FeatureDatasetPoint fd = covp.asFeatureDatasetPoint();){
            SubsetParams ncssParams = new SubsetParams().set("timeAll", (Object)true).set("var", params.getVar());
            DsgSubsetWriter pds = DsgSubsetWriterFactory.newInstance(fd, ncssParams, this.ncssDiskCache, (OutputStream)res.getOutputStream(), sf);
            this.setResponseHeaders(res, pds.getHttpHeaders(datasetPath, sf.isStream()));
            pds.respond(res, (FeatureDataset)fd, datasetPath, ncssParams, sf);
        }
    }

    @RequestMapping(value={"**/dataset.html", "**/dataset.xml", "**/pointDataset.html", "**/pointDataset.xml"})
    public ModelAndView getDatasetDescription(HttpServletRequest req, HttpServletResponse res) throws IOException, NcssException {
        if (!this.allowedServices.isAllowed(StandardService.netcdfSubsetGrid)) {
            throw new ServiceNotAllowed(StandardService.netcdfSubsetGrid.toString());
        }
        if (!req.getParameterMap().isEmpty()) {
            throw new NcssException("Invalid info request.");
        }
        String path = req.getServletPath();
        boolean wantXML = path.endsWith("/dataset.xml") || path.endsWith("/pointDataset.xml");
        boolean showPointForm = path.endsWith("/pointDataset.html");
        String datasetPath = this.getDatasetPath(req);
        try (CoverageCollection gcd = TdsRequestedDataset.getCoverageCollection(req, res, datasetPath);){
            if (gcd == null) {
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            ModelAndView modelAndView = this.ncssShowDatasetInfo.showGridFormTh(gcd, this.buildDatasetUrl(datasetPath), wantXML);
            return modelAndView;
        }
    }

    private void checkRequestedVars(CoverageCollection gcd, NcssGridParamsBean params) throws VariableNotContainedInDatasetException {
        if (params.getVar().get(0).equalsIgnoreCase("all")) {
            params.setVar(this.getAllGridNames(gcd));
            return;
        }
        for (String gridName : params.getVar()) {
            Coverage grid = gcd.findCoverage(gridName);
            if (grid != null) continue;
            throw new VariableNotContainedInDatasetException("Variable: " + gridName + " is not contained in the requested dataset");
        }
    }

    private List<String> getAllGridNames(CoverageCollection gcd) {
        ArrayList<String> result = new ArrayList<String>();
        for (Coverage var : gcd.getCoverages()) {
            result.add(var.getName());
        }
        return result;
    }

    protected boolean checkVarsHaveSameVertAxis(CoverageCollection gcd, NcssGridParamsBean params) throws VariableNotContainedInDatasetException {
        String zaxisName = null;
        for (String gridName : params.getVar()) {
            Coverage grid = gcd.findCoverage(gridName);
            CoverageCoordAxis zaxis = grid.getCoordSys().getZAxis();
            if (zaxis == null) continue;
            if (zaxisName == null) {
                zaxisName = zaxis.getName();
                continue;
            }
            if (zaxisName.equals(zaxis.getName())) continue;
            return false;
        }
        return true;
    }
}

