/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.ModelAndView;
import thredds.server.config.TdsContext;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.format.SupportedOperation;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.writer.FeatureDatasetCapabilitiesWriter;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.writer.CoverageBoundariesExtractor;
import ucar.nc2.ft2.coverage.writer.CoverageDatasetCapabilities;

@Service
public class NcssShowFeatureDatasetInfo {
    @Autowired
    TdsContext tdsContext;

    public ModelAndView showForm(FeatureDataset fd, String datasetUrlPath, boolean wantXml, boolean isPoint) throws IOException {
        FeatureType ft = fd.getFeatureType();
        switch (ft) {
            case STATION: {
                return this.showPointForm((FeatureDatasetPoint)fd, SupportedOperation.STATION_REQUEST, datasetUrlPath, wantXml, "ncss/ncssSobs.xsl");
            }
            case POINT: {
                return this.showPointForm((FeatureDatasetPoint)fd, SupportedOperation.POINT_REQUEST, datasetUrlPath, wantXml, "ncss/ncssPobs.xsl");
            }
        }
        throw new IllegalStateException("Unsupported feature type " + ft);
    }

    private ModelAndView showPointForm(FeatureDatasetPoint fp, SupportedOperation ops, String datasetUrlPath, boolean wantXml, String xslt) throws IOException {
        FeatureDatasetCapabilitiesWriter xmlWriter = new FeatureDatasetCapabilitiesWriter(fp, datasetUrlPath);
        Document doc = xmlWriter.getCapabilitiesDocument();
        Element root = doc.getRootElement();
        root.setAttribute("location", datasetUrlPath);
        root.addContent((Content)this.makeAcceptXML(ops));
        if (wantXml) {
            return new ModelAndView("threddsXmlView", "Document", (Object)doc);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("Document", doc);
        model.put("Transform", xslt);
        return new ModelAndView("threddsXsltView", model);
    }

    public ModelAndView showGridFormTh(CoverageCollection gcd, String datasetUrlPath, boolean wantXml) throws IOException {
        if (wantXml) {
            CoverageDatasetCapabilities writer = new CoverageDatasetCapabilities(gcd, "path");
            Document doc = writer.makeDatasetDescription();
            Element root = doc.getRootElement();
            root.setAttribute("location", datasetUrlPath);
            root.addContent((Content)this.makeAcceptXML(SupportedOperation.GRID_REQUEST));
            return new ModelAndView("threddsXmlView", "Document", (Object)doc);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("gcd", gcd);
        model.put("datasetPath", datasetUrlPath);
        model.put("gridWKT", CoverageBoundariesExtractor.getDatasetBoundariesWKT((CoverageCollection)gcd));
        model.put("accept", this.makeAcceptList(SupportedOperation.GRID_REQUEST));
        return new ModelAndView("templates/ncssGridth", model);
    }

    public ModelAndView showGridForm(CoverageCollection gcd, String datasetUrlPath, boolean wantXml, boolean isPoint) throws IOException {
        CoverageDatasetCapabilities writer = new CoverageDatasetCapabilities(gcd, "path");
        Document doc = writer.makeDatasetDescription();
        Element root = doc.getRootElement();
        root.setAttribute("location", datasetUrlPath);
        root.addContent((Content)this.makeAcceptXML(SupportedOperation.GRID_REQUEST));
        if (wantXml) {
            return new ModelAndView("threddsXmlView", "Document", (Object)doc);
        }
        String xslt = isPoint ? "ncss/ncssGridAsPoint.xsl" : "ncss/ncssGrid.xsl";
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("Document", doc);
        model.put("Transform", xslt);
        return new ModelAndView("threddsXsltView", model);
    }

    private Element makeAcceptXML(SupportedOperation ops) {
        Element acceptList = new Element("AcceptList");
        for (SupportedFormat sf : ops.getSupportedFormats()) {
            Element accept = new Element("accept").addContent(sf.getFormatName()).setAttribute("displayName", sf.getFormatName());
            acceptList.addContent((Content)accept);
        }
        return acceptList;
    }

    private List<String> makeAcceptList(SupportedOperation ops) {
        ArrayList<String> result = new ArrayList<String>();
        for (SupportedFormat sf : ops.getSupportedFormats()) {
            result.add(sf.getFormatName());
        }
        return result;
    }
}

