/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.viewer;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import thredds.server.config.TdsContext;
import thredds.server.viewer.ViewerRequestParamsBean;
import thredds.server.viewer.ViewerService;
import thredds.servlet.ServletUtil;
import thredds.util.ContentType;
import thredds.util.StringValidateEncodeUtils;
import ucar.unidata.util.StringUtil2;

@Controller
@RequestMapping(value={"/view"})
public class ViewerController {
    private static Logger log = LoggerFactory.getLogger(ViewerController.class);
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    ViewerService viewerService;

    @RequestMapping(value={"{viewer}.jnlp"}, method={RequestMethod.GET})
    public void launchViewer(@Valid ViewerRequestParamsBean params, BindingResult result, HttpServletResponse res, HttpServletRequest req) throws IOException {
        block6: {
            if (result.hasErrors()) {
                res.sendError(400);
                return;
            }
            if (!StringValidateEncodeUtils.validAlphanumericString(params.getViewer())) {
                res.sendError(400);
                return;
            }
            String viewerName = StringUtil2.filter7bits((String)params.getViewer()) + ".jnlp";
            File viewPath = new File(this.tdsContext.getServletRootDirectory(), "/WEB-INF/views/" + viewerName);
            String template = this.viewerService.getViewerTemplate(viewPath.getPath());
            if (template == null) {
                viewPath = new File(this.tdsContext.getContentRootDir(), "views/" + viewerName);
                template = this.viewerService.getViewerTemplate(viewPath.getPath());
            }
            if (template == null) {
                res.sendError(404);
                return;
            }
            String strResp = this.fillTemplate(req, template);
            try {
                res.setContentType(ContentType.jnlp.getContentHeader());
                ServletUtil.returnString(strResp, res);
            }
            catch (Throwable t) {
                log.error(" jnlp=" + strResp, t);
                if (res.isCommitted()) break block6;
                res.sendError(500);
            }
        }
    }

    private String fillTemplate(HttpServletRequest req, String template) {
        StringBuilder sbuff = new StringBuilder(template);
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            String[] values = req.getParameterValues(name);
            if (values == null) continue;
            String sname = "{" + name + "}";
            for (String value : values) {
                String filteredValue = StringUtil2.filter7bits((String)value);
                StringUtil2.substitute((StringBuilder)sbuff, (String)sname, (String)filteredValue);
            }
        }
        return sbuff.toString();
    }
}

