/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.core.StandardService;
import thredds.server.admin.DebugCommands;
import thredds.server.catalog.AllowedServicesIF;
import thredds.server.config.TdsContext;
import ucar.nc2.constants.FeatureType;

@Component
public class AllowedServices
implements AllowedServicesIF {
    private static final Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    private static Logger logCatalogInit = LoggerFactory.getLogger((String)"catalogInit");
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private DebugCommands debugCommands;
    private Map<StandardService, AllowedService> allowed = new HashMap<StandardService, AllowedService>();
    private List<String> allowedGridServiceNames;
    private List<String> allowedPointServiceNames;
    private List<String> allowedPointCollectionServiceNames;
    private List<String> allowedRadialServiceNames;
    private List<Service> allowedGridServices = new ArrayList<Service>();
    private List<Service> allowedPointServices = new ArrayList<Service>();
    private List<Service> allowedPointCollectionServices = new ArrayList<Service>();
    private List<Service> allowedRadialServices = new ArrayList<Service>();
    private Map<String, Service> globalServices = new HashMap<String, Service>();
    private List<String> isAThreddsDataset;
    private List<String> isNotAThreddsDataset;

    public void setAllow(Map<String, Boolean> map) {
        for (Map.Entry<String, Boolean> s : map.entrySet()) {
            StandardService service = StandardService.getStandardServiceIgnoreCase(s.getKey());
            if (service == null) {
                logServerStartup.error("No service named " + s.getKey());
                continue;
            }
            this.allowed.put(service, new AllowedService(service, s.getValue()));
        }
    }

    public void setAllowService(StandardService service, Boolean allow) {
        if (allow == null) {
            return;
        }
        AllowedService as = this.allowed.get((Object)service);
        if (as == null) {
            logServerStartup.error("AllowedService cant find StandardService " + (Object)((Object)service));
        } else {
            as.allowed = allow;
        }
    }

    public void setGridServices(List<String> list) {
        this.allowedGridServiceNames = list;
    }

    public void setPointServices(List<String> list) {
        this.allowedPointServiceNames = list;
    }

    public void setPointCollectionServices(List<String> list) {
        this.allowedPointCollectionServiceNames = list;
    }

    public void setRadialServices(List<String> list) {
        this.allowedRadialServiceNames = list;
    }

    public void finish() {
        AllowedService as;
        StandardService service;
        ArrayList<Service> result = new ArrayList<Service>();
        for (String s : this.allowedGridServiceNames) {
            service = StandardService.getStandardServiceIgnoreCase(s);
            if (service == null) {
                logServerStartup.error("No service named " + s);
                continue;
            }
            as = this.allowed.get((Object)service);
            if (as == null || !as.allowed) continue;
            result.add(this.makeService(as.ss));
        }
        this.allowedGridServices = Collections.unmodifiableList(result);
        result = new ArrayList();
        for (String s : this.allowedPointCollectionServiceNames) {
            service = StandardService.getStandardServiceIgnoreCase(s);
            if (service == null) {
                logServerStartup.error("No service named " + s);
                continue;
            }
            as = this.allowed.get((Object)service);
            if (as == null || !as.allowed) continue;
            result.add(this.makeService(as.ss));
        }
        this.allowedPointCollectionServices = Collections.unmodifiableList(result);
        result = new ArrayList();
        for (String s : this.allowedPointServiceNames) {
            service = StandardService.getStandardServiceIgnoreCase(s);
            if (service == null) {
                logServerStartup.error("No service named " + s);
                continue;
            }
            as = this.allowed.get((Object)service);
            if (as == null || !as.allowed) continue;
            result.add(this.makeService(as.ss));
        }
        this.allowedPointServices = Collections.unmodifiableList(result);
        result = new ArrayList();
        for (String s : this.allowedRadialServiceNames) {
            service = StandardService.getStandardServiceIgnoreCase(s);
            if (service == null) {
                logServerStartup.error("No service named " + s);
                continue;
            }
            as = this.allowed.get((Object)service);
            if (as == null || !as.allowed) continue;
            result.add(this.makeService(as.ss));
        }
        this.allowedRadialServices = Collections.unmodifiableList(result);
    }

    private Service makeService(StandardService ss) {
        String path = ss.base.startsWith("/") ? this.tdsContext.getContextPath() + ss.base : ss.base;
        return new Service(ss.type.toString(), path, ss.type.toString(), null, null, null, null);
    }

    public Service getStandardServices(String featTypeName) {
        FeatureType ft = FeatureType.getType((String)featTypeName);
        return ft == null ? null : this.getStandardServices(ft);
    }

    public Service getStandardServices(FeatureType featType) {
        if (featType.isCoverageFeatureType()) {
            return new Service("GridServices", "", ServiceType.Compound.toString(), null, null, this.allowedGridServices, null);
        }
        if (featType.isPointFeatureType()) {
            return new Service("PointServices", "", ServiceType.Compound.toString(), null, null, this.allowedPointServices, null);
        }
        if (featType == FeatureType.RADIAL) {
            return new Service("RadialServices", "", ServiceType.Compound.toString(), null, null, this.allowedRadialServices, null);
        }
        return null;
    }

    public Service getStandardCollectionServices(FeatureType featType) {
        if (featType.isCoverageFeatureType()) {
            return new Service("GridCollectionServices", "", ServiceType.Compound.toString(), null, null, this.allowedGridServices, null);
        }
        if (featType.isPointFeatureType()) {
            return new Service("PointCollectionServices", "", ServiceType.Compound.toString(), null, null, this.allowedPointCollectionServices, null);
        }
        return null;
    }

    public boolean isAllowed(StandardService type) {
        AllowedService s = this.allowed.get((Object)type);
        return s != null && s.allowed;
    }

    @Nullable
    public Service getStandardService(StandardService type) {
        AllowedService s = this.allowed.get((Object)type);
        if (s == null) {
            return null;
        }
        return !s.allowed ? null : this.makeService(s.ss);
    }

    public void clearGlobalServices() {
        this.globalServices = new HashMap<String, Service>();
    }

    public void addGlobalServices(List<Service> services) {
        for (Service s : services) {
            Service got = this.globalServices.get(s.getName());
            if (got != null) {
                logCatalogInit.error("Already have a global service {} trying to add {}", (Object)got, (Object)s);
                continue;
            }
            this.globalServices.put(s.getName(), s);
            logCatalogInit.info("Added global service {}", (Object)s);
        }
    }

    public Service findGlobalService(String name) {
        if (name == null) {
            return null;
        }
        return this.globalServices.get(name);
    }

    public Collection<Service> getGlobalServices() {
        return this.globalServices.values();
    }

    public List<String> getDisallowedServices(List<Service> services) {
        ArrayList<String> disallowedServices = new ArrayList<String>();
        for (Service s : services) {
            this.checkService(s, disallowedServices);
        }
        return disallowedServices;
    }

    private void checkService(Service service, List<String> disallowedServices) {
        if (service.getType() == ServiceType.Compound) {
            for (Service nested : service.getNestedServices()) {
                this.checkService(nested, disallowedServices);
            }
        } else {
            AllowedService as = this.findByService(service);
            if (as != null && !as.allowed) {
                disallowedServices.add(service.getName());
            }
        }
    }

    private AllowedService findByService(Service service) {
        for (AllowedService entry : this.allowed.values()) {
            if (entry.ss.type != service.getType() || entry.ss.type == ServiceType.NetcdfSubset && !service.getBase().startsWith(entry.ss.base)) continue;
            return entry;
        }
        return null;
    }

    public void makeDebugActions() {
        DebugCommands.Category debugHandler = this.debugCommands.findCategory("Catalogs");
        DebugCommands.Action act = new DebugCommands.Action("showServices", "Show standard and global services"){

            @Override
            public void doAction(DebugCommands.Event e) {
                e.pw.printf("%n<h3>Global Services</h3>%n", new Object[0]);
                for (Service s : AllowedServices.this.getGlobalServices()) {
                    if (s.getType() == ServiceType.Compound) {
                        e.pw.printf(" <b>%s </b>(Compound):%n", s.getName());
                        for (Service sn : s.getNestedServices()) {
                            e.pw.printf("   <b>%s:</b> %s%n", sn.getName(), sn.toString());
                        }
                        e.pw.printf("%n", new Object[0]);
                        continue;
                    }
                    e.pw.printf(" <b>%s:</b> %s%n", s.getName(), s.toString());
                }
                e.pw.printf("%n<h3>Grid Services</h3>%n", new Object[0]);
                for (Service s : AllowedServices.this.allowedGridServices) {
                    e.pw.printf(" <b>%s:</b> %s%n", s.getName(), s.toString());
                }
                e.pw.printf("%n<h3>Point Services</h3>%n", new Object[0]);
                for (Service s : AllowedServices.this.allowedPointServices) {
                    e.pw.printf(" <b>%s:</b> %s%n", s.getName(), s.toString());
                }
                e.pw.printf("%n<h3>Point Collection Services</h3>%n", new Object[0]);
                for (Service s : AllowedServices.this.allowedPointCollectionServices) {
                    e.pw.printf(" <b>%s:</b> %s%n", s.getName(), s.toString());
                }
                e.pw.printf("%n<h3>Radial Services</h3>%n", new Object[0]);
                for (Service s : AllowedServices.this.allowedRadialServices) {
                    e.pw.printf(" <b>%s:</b> %s%n", s.getName(), s.toString());
                }
            }
        };
        debugHandler.addAction(act);
    }

    public void setIsAThreddsDataset(List<String> list) {
        this.isAThreddsDataset = list;
    }

    public void setIsNotAThreddsDataset(List<String> list) {
        this.isNotAThreddsDataset = list;
    }

    public boolean isAThreddsDataset(String filename) {
        if (this.isAThreddsDataset != null) {
            for (String suffix : this.isAThreddsDataset) {
                if (!filename.endsWith(suffix)) continue;
                return true;
            }
        }
        if (this.isNotAThreddsDataset != null) {
            for (String suffix : this.isNotAThreddsDataset) {
                if (!filename.endsWith(suffix)) continue;
                return false;
            }
        }
        return true;
    }

    private static class AllowedService {
        StandardService ss;
        boolean allowed;

        private AllowedService(StandardService ss, boolean allowed) {
            this.ss = ss;
            this.allowed = allowed;
        }
    }
}

