/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.util.Log4jWebConfigurer;
import thredds.featurecollection.InvDatasetFeatureCollection;
import thredds.util.filesource.BasicDescendantFileSource;
import thredds.util.filesource.FileSource;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

@Component(value="TdsContext")
public final class TdsContext
implements ServletContextAware,
InitializingBean,
DisposableBean {
    private final Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    @Value(value="${tds.version}")
    private String tdsVersion;
    @Value(value="${tds.version.builddate}")
    private String tdsVersionBuildDate;
    @Value(value="${tds.content.path}")
    private String contentPathProperty;
    @Value(value="${tds.content.startup.path}")
    private String contentStartupPathProperty;
    @Value(value="${tds.config.file}")
    private String configFileProperty;
    @Value(value="${tds.content.root.path}")
    private String contentRootPathProperty;
    @Value(value="${tds.upload.dir}")
    private String uploadDirProperty;
    @Value(value="${tds.upload.form}")
    private String uploadFormProperty;
    @Value(value="${tds.download.dir}")
    private String downloadDirProperty;
    @Value(value="${tds.download.form}")
    private String downloadFormProperty;
    @Value(value="${tds.debug.flags:}")
    private String tdsDebugFlagsProperty;
    private ServletContext servletContext;
    private String contextPath;
    private String webappDisplayName;
    private File servletRootDirectory;
    private File contentRootDir;
    private File threddsDirectory;
    private File publicContentDirectory;
    private File startupContentDirectory;
    private File tomcatLogDir;
    private File uploadDir = null;
    private File downloadDir = null;
    private File uploadForm = null;
    private File downloadForm = null;
    private FileSource publicContentDirSource;
    private RequestDispatcher defaultRequestDispatcher;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void destroy() {
        this.logServerStartup.info("TdsContext: shutdownLogging()");
        Log4jWebConfigurer.shutdownLogging((ServletContext)this.servletContext);
    }

    public void afterPropertiesSet() {
        String msg;
        if (this.servletContext == null) {
            throw new IllegalArgumentException("ServletContext must not be null.");
        }
        this.webappDisplayName = this.servletContext.getServletContextName();
        this.contextPath = this.servletContext.getContextPath();
        InvDatasetFeatureCollection.setContextName(this.contextPath);
        String rootPath = this.servletContext.getRealPath("/");
        if (rootPath == null) {
            String msg2 = "Webapp [" + this.webappDisplayName + "] must run with exploded deployment directory (not from .war).";
            this.logServerStartup.error("TdsContext.init(): " + msg2);
            throw new IllegalStateException(msg2);
        }
        this.servletRootDirectory = new File(rootPath);
        this.startupContentDirectory = new File(this.servletRootDirectory, this.contentStartupPathProperty);
        BasicDescendantFileSource startupContentDirSource = new BasicDescendantFileSource(this.startupContentDirectory);
        this.startupContentDirectory = startupContentDirSource.getRootDirectory();
        try {
            String base = System.getProperty("catalina.base");
            if (base != null) {
                this.tomcatLogDir = new File(base, "logs").getCanonicalFile();
                if (!this.tomcatLogDir.exists()) {
                    msg = "'catalina.base' directory not found: " + this.tomcatLogDir;
                    this.logServerStartup.error("TdsContext.init(): " + msg);
                }
            } else {
                msg = "'catalina.base' property not found - probably not a tomcat server";
                this.logServerStartup.warn("TdsContext.init(): " + msg);
            }
        }
        catch (IOException e) {
            msg = "tomcatLogDir could not be created";
            this.logServerStartup.error("TdsContext.init(): " + msg);
        }
        String contentRootPathKey = "tds.content.root.path";
        if (this.contentRootPathProperty.equals("${tds.content.root.path}")) {
            String message = String.format("\"%s\" property isn't defined.", contentRootPathKey);
            this.logServerStartup.error(message);
            throw new IllegalStateException(message);
        }
        this.contentRootPathProperty = StringUtil2.replace((String)this.contentRootPathProperty, (String)"\\", (String)"/");
        if (!this.contentRootPathProperty.endsWith("/")) {
            this.contentRootPathProperty = this.contentRootPathProperty + "/";
        }
        this.contentRootDir = new File(this.contentRootPathProperty);
        if (!this.contentRootDir.isAbsolute()) {
            this.threddsDirectory = new File(new File(this.servletRootDirectory, this.contentRootPathProperty), this.contentPathProperty);
        } else if (this.contentRootDir.isDirectory()) {
            this.threddsDirectory = new File(this.contentRootDir, this.contentPathProperty);
        } else {
            msg = "Content root directory [" + this.contentRootPathProperty + "] not a directory.";
            this.logServerStartup.error("TdsContext.init(): " + msg);
            throw new IllegalStateException(msg);
        }
        if (!this.threddsDirectory.isDirectory()) {
            String message = String.format("TdsContext.init(): Content directory is not a directory: %s", this.threddsDirectory.getAbsolutePath());
            this.logServerStartup.error(message);
            throw new IllegalStateException(message);
        }
        BasicDescendantFileSource contentDirSource = new BasicDescendantFileSource(StringUtils.cleanPath((String)this.threddsDirectory.getAbsolutePath()));
        this.threddsDirectory = contentDirSource.getRootDirectory();
        this.publicContentDirectory = new File(this.threddsDirectory, "public");
        if (!this.publicContentDirectory.exists() && !this.publicContentDirectory.mkdirs()) {
            String msg3 = "Couldn't create TDS public directory [" + this.publicContentDirectory.getPath() + "].";
            this.logServerStartup.error("TdsContext.init(): " + msg3);
            throw new IllegalStateException(msg3);
        }
        this.publicContentDirSource = new BasicDescendantFileSource(this.publicContentDirectory);
        this.defaultRequestDispatcher = this.servletContext.getNamedDispatcher("default");
        this.uploadDir = this.getPropertyDir(this.uploadDirProperty, "tds.upload.dir", true);
        this.uploadForm = this.getPropertyFile(this.uploadFormProperty, "tds.upload.form", false);
        this.downloadDir = this.getPropertyDir(this.downloadDirProperty, "tds.download.dir", true);
        this.downloadForm = this.getPropertyFile(this.downloadFormProperty, "tds.download.form", false);
        try {
            File wmsConfigXmlFile;
            File threddsConfigFile;
            File catalogFile = new File(this.threddsDirectory, "catalog.xml");
            if (!catalogFile.exists()) {
                File defaultCatalogFile = new File(this.startupContentDirectory, "catalog.xml");
                this.logServerStartup.info("TdsContext.init(): Copying default catalog file from {}.", (Object)defaultCatalogFile);
                IO.copyFile((File)defaultCatalogFile, (File)catalogFile);
                File enhancedCatalogFile = new File(this.threddsDirectory, "enhancedCatalog.xml");
                File defaultEnhancedCatalogFile = new File(this.startupContentDirectory, "enhancedCatalog.xml");
                this.logServerStartup.info("TdsContext.init(): Copying default enhanced catalog file from {}.", (Object)defaultEnhancedCatalogFile);
                IO.copyFile((File)defaultEnhancedCatalogFile, (File)enhancedCatalogFile);
                File dataDir = new File(new File(this.threddsDirectory, "public"), "testdata");
                File defaultDataDir = new File(new File(this.startupContentDirectory, "public"), "testdata");
                this.logServerStartup.info("TdsContext.init(): Copying default testdata directory from {}.", (Object)defaultDataDir);
                IO.copyDirTree((String)defaultDataDir.getCanonicalPath(), (String)dataDir.getCanonicalPath());
            }
            if (!(threddsConfigFile = new File(this.threddsDirectory, "threddsConfig.xml")).exists()) {
                File defaultThreddsConfigFile = new File(this.startupContentDirectory, "threddsConfig.xml");
                this.logServerStartup.info("TdsContext.init(): Copying default THREDDS config file from {}.", (Object)defaultThreddsConfigFile);
                IO.copyFile((File)defaultThreddsConfigFile, (File)threddsConfigFile);
            }
            if (!(wmsConfigXmlFile = new File(this.threddsDirectory, "wmsConfig.xml")).exists()) {
                File defaultWmsConfigXmlFile = new File(this.startupContentDirectory, "wmsConfig.xml");
                this.logServerStartup.info("TdsContext.init(): Copying default WMS config file from {}.", (Object)defaultWmsConfigXmlFile);
                IO.copyFile((File)defaultWmsConfigXmlFile, (File)wmsConfigXmlFile);
            }
        }
        catch (IOException e) {
            String message = String.format("Could not copy default startup files to %s.", this.threddsDirectory);
            this.logServerStartup.error("TdsContext.init(): " + message);
            throw new IllegalStateException(message, e);
        }
        File logDir = new File(this.threddsDirectory, "logs");
        if (!logDir.exists() && !logDir.mkdirs()) {
            String msg4 = "Couldn't create TDS log directory [" + logDir.getPath() + "].";
            this.logServerStartup.error("TdsContext.init(): " + msg4);
            throw new IllegalStateException(msg4);
        }
        String loggingDirectory = StringUtil2.substitute((String)logDir.getPath(), (String)"\\", (String)"/");
        System.setProperty("tds.log.dir", loggingDirectory);
        this.logServerStartup.info("TdsContext version= " + this.getVersionInfo());
        this.logServerStartup.info("TdsContext intialized logging in " + logDir.getPath());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TdsContext{");
        sb.append("\n  contextPath='").append(this.contextPath).append('\'');
        sb.append("\n  webappName='").append(this.webappDisplayName).append('\'');
        sb.append("\n  webappVersion='").append(this.tdsVersion).append('\'');
        sb.append("\n  webappVersionBuildDate='").append(this.tdsVersionBuildDate).append('\'');
        sb.append("\n");
        sb.append("\n  contentPath= '").append(this.contentPathProperty).append('\'');
        sb.append("\n  contentRootPath= '").append(this.contentRootPathProperty).append('\'');
        sb.append("\n  contentStartupPath= '").append(this.contentStartupPathProperty).append('\'');
        sb.append("\n  configFile= '").append(this.configFileProperty).append('\'');
        sb.append("\n");
        sb.append("\n  servletRootDir=   ").append(this.servletRootDirectory);
        sb.append("\n  contentRootDir=   ").append(this.contentRootDir);
        if (this.uploadDir != null) {
            sb.append("\n  uploadDir=   ").append(this.uploadDir);
        }
        if (this.uploadForm != null) {
            sb.append("\n  uploadForm=   ").append(this.uploadForm);
        }
        if (this.downloadDir != null) {
            sb.append("\n  downloadDir=   ").append(this.downloadDir);
        }
        if (this.downloadForm != null) {
            sb.append("\n  downloadForm=   ").append(this.downloadForm);
        }
        sb.append("\n  threddsDirectory= ").append(this.threddsDirectory);
        sb.append("\n  publicContentDir= ").append(this.publicContentDirectory);
        sb.append("\n  startupContentDir=").append(this.startupContentDirectory);
        sb.append("\n  tomcatLogDir=     ").append(this.tomcatLogDir);
        sb.append("\n");
        sb.append("\n  publicContentDirSource= ").append(this.publicContentDirSource);
        sb.append('}');
        return sb.toString();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getWebappVersion() {
        return this.tdsVersion;
    }

    public String getTdsVersionBuildDate() {
        return this.tdsVersionBuildDate;
    }

    public String getVersionInfo() {
        Formatter f = new Formatter();
        f.format("%s", this.getWebappVersion());
        if (this.getTdsVersionBuildDate() != null) {
            f.format(" - %s", this.getTdsVersionBuildDate());
        }
        return f.toString();
    }

    public String getWebappDisplayName() {
        return this.webappDisplayName;
    }

    public File getServletRootDirectory() {
        return this.servletRootDirectory;
    }

    public File getTomcatLogDirectory() {
        return this.tomcatLogDir;
    }

    public File getThreddsDirectory() {
        return this.threddsDirectory;
    }

    public File getContentRootDir() {
        return this.contentRootDir;
    }

    public FileSource getPublicContentDirSource() {
        return this.publicContentDirSource;
    }

    public RequestDispatcher getDefaultRequestDispatcher() {
        return this.defaultRequestDispatcher;
    }

    public String getContentRootPathProperty() {
        return this.contentRootPathProperty;
    }

    public String getConfigFileProperty() {
        return this.configFileProperty;
    }

    public File getUploadDir() {
        return this.uploadDir;
    }

    public File getDownloadDir() {
        return this.downloadDir;
    }

    public File getUploadForm() {
        return this.uploadForm;
    }

    public File getDownloadForm() {
        return this.downloadForm;
    }

    public String getTdsDebugFlags() {
        return this.tdsDebugFlagsProperty;
    }

    public void setContentRootPathProperty(String contentRootPathProperty) {
        this.contentRootPathProperty = contentRootPathProperty;
    }

    public void setUploadDirProperty(String uploadDirProperty) {
        this.uploadDirProperty = uploadDirProperty;
    }

    public void setDownloadDirProperty(String downloadDirProperty) {
        this.downloadDirProperty = downloadDirProperty;
    }

    public void setUploadFormProperty(String uploadFormProperty) {
        this.uploadFormProperty = uploadFormProperty;
    }

    public void setDownloadFormProperty(String downloadFormProperty) {
        this.downloadFormProperty = downloadFormProperty;
    }

    public File getPropertyDir(String prop, String key, boolean create) {
        File dir;
        assert (prop != null && key != null);
        if (prop.equals("${" + key + "}")) {
            String msg = String.format("\"%s\" property isn't defined.", key);
            this.logServerStartup.warn("TdsContext.init(): " + msg);
            return null;
        }
        if (!(prop = StringUtil2.replace((String)prop, (String)"\\", (String)"/")).endsWith("/")) {
            prop = prop + "/";
        }
        if (!(dir = new File(prop)).isAbsolute()) {
            String msg = String.format("\"%s=%s\" value must be an absolutepath.", key, prop);
            this.logServerStartup.warn("TdsContext.init(): " + msg);
            return null;
        }
        if (!dir.exists() && create && !dir.mkdirs()) {
            this.logServerStartup.warn("TdsContext.init(): " + String.format("Directory: %s=%s could not be created.", key, prop));
        }
        if (!dir.exists()) {
            this.logServerStartup.warn("TdsContext.init(): " + String.format("Directory: %s=%s does not exist.", key, prop));
            return null;
        }
        if (!dir.isDirectory()) {
            this.logServerStartup.warn("TdsContext.init(): " + String.format("Directory: %s=%s is not a directory.", key, prop));
            return null;
        }
        if (!dir.canRead() || !dir.canWrite()) {
            this.logServerStartup.warn("TdsContext.init(): " + String.format("Directory: %s=%s must be readable and writeable.", key, prop));
            return null;
        }
        return dir;
    }

    public File getPropertyFile(String prop, String key, boolean writeable) {
        File file;
        assert (prop != null && key != null);
        if (prop.equals("${" + key + "}")) {
            String msg = String.format("\"%s\" property isn't defined.", key);
            this.logServerStartup.warn("TdsContext.init(): " + msg);
            return null;
        }
        if (!(prop = StringUtil2.replace((String)prop, (String)"\\", (String)"/")).endsWith("/")) {
            prop = prop + "/";
        }
        if (!(file = new File(prop)).isAbsolute()) {
            String msg = String.format("\"%s=%s\" value must be an absolutepath.", key, prop);
            this.logServerStartup.warn("TdsContext.init(): " + msg);
            return null;
        }
        if (!file.exists()) {
            this.logServerStartup.warn("TdsContext.init(): " + String.format("Directory: %s=%s does not exist.", key, prop));
            return null;
        }
        if (!file.isFile()) {
            this.logServerStartup.warn("TdsContext.init(): " + String.format("File: %s=%s is not a file.", key, prop));
            return null;
        }
        if (!file.canRead()) {
            this.logServerStartup.warn("TdsContext.init(): " + String.format("File: %s=%s must be readable.", key, prop));
            return null;
        }
        if (writeable && !file.canWrite()) {
            this.logServerStartup.warn("TdsContext.init(): " + String.format("File: %s=%s must be writeable.", key, prop));
            return null;
        }
        return file;
    }
}

