/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Formatter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.jdom2.Document;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import thredds.core.StandardService;
import thredds.core.TdsRequestedDataset;
import thredds.server.ncss.controller.AbstractNcssController;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.format.SupportedOperation;
import thredds.server.ncss.params.NcssPointParamsBean;
import thredds.server.ncss.view.dsg.DsgSubsetWriter;
import thredds.server.ncss.view.dsg.DsgSubsetWriterFactory;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.writer.FeatureDatasetCapabilitiesWriter;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

@Controller
@RequestMapping(value={"/ncss/point"})
public class NcssPointController
extends AbstractNcssController {
    @Override
    protected String getBase() {
        return StandardService.netcdfSubsetPoint.getBase();
    }

    @RequestMapping(value={"**"})
    public void handleRequest(HttpServletRequest req, HttpServletResponse res, @Valid NcssPointParamsBean params, BindingResult validationResult) throws Exception {
        block23: {
            if (validationResult.hasErrors()) {
                throw new BindException(validationResult);
            }
            String datasetPath = this.getDatasetPath(req);
            try (FeatureDatasetPoint fd = TdsRequestedDataset.getPointDataset(req, res, datasetPath);){
                if (fd == null) {
                    return;
                }
                Formatter errs = new Formatter();
                if (!params.intersectsTime(fd.getCalendarDateRange(), errs)) {
                    this.handleValidationErrorMessage(res, 400, errs.toString());
                    return;
                }
                FeatureType ft = fd.getFeatureType();
                if (ft == FeatureType.POINT) {
                    this.handleRequestDsg(res, params, datasetPath, (FeatureDataset)fd);
                    break block23;
                }
                if (ft == FeatureType.STATION) {
                    this.handleRequestDsg(res, params, datasetPath, (FeatureDataset)fd);
                    break block23;
                }
                throw new NcssException("Dataset Feature Type is " + ft.toString() + " but request is for Points or Stations");
            }
        }
    }

    void handleRequestDsg(HttpServletResponse res, NcssPointParamsBean params, String datasetPath, FeatureDataset fd) throws Exception {
        SupportedOperation supportedOp;
        switch (fd.getFeatureType()) {
            case POINT: {
                supportedOp = SupportedOperation.POINT_REQUEST;
                break;
            }
            case STATION: {
                supportedOp = SupportedOperation.STATION_REQUEST;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("%s format not currently supported for DSG subset writing.", fd.getFeatureType()));
            }
        }
        SubsetParams ncssParams = params.makeSubset();
        SupportedFormat format = supportedOp.getSupportedFormat(params.getAccept());
        DsgSubsetWriter pds = DsgSubsetWriterFactory.newInstance((FeatureDatasetPoint)fd, ncssParams, this.ncssDiskCache, (OutputStream)res.getOutputStream(), format);
        this.setResponseHeaders(res, pds.getHttpHeaders(datasetPath, format.isStream()));
        pds.respond(res, fd, datasetPath, ncssParams, format);
    }

    @RequestMapping(value={"**/dataset.html", "**/dataset.xml", "**/pointDataset.html", "**/pointDataset.xml"})
    public ModelAndView getDatasetDescription(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String path = req.getServletPath();
        boolean wantXML = path.endsWith("/dataset.xml") || path.endsWith("/pointDataset.xml");
        boolean showPointForm = path.endsWith("/pointDataset.html");
        String datasetPath = this.getDatasetPath(req);
        try (FeatureDatasetPoint fd = TdsRequestedDataset.getPointDataset(req, res, datasetPath);){
            if (fd == null) {
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            ModelAndView modelAndView = this.ncssShowDatasetInfo.showForm((FeatureDataset)fd, this.buildDatasetUrl(datasetPath), wantXML, showPointForm);
            return modelAndView;
        }
    }

    @RequestMapping(value={"**/station.xml"})
    ModelAndView getStations(HttpServletRequest req, HttpServletResponse res, NcssPointParamsBean params) throws IOException {
        String datasetPath = this.getDatasetPath(req);
        try (FeatureDatasetPoint fd = TdsRequestedDataset.getPointDataset(req, res, datasetPath);){
            if (fd == null) {
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            if (fd.getFeatureType() != FeatureType.STATION) {
                throw new UnsupportedOperationException("Station list request is only supported for Station features");
            }
            FeatureDatasetCapabilitiesWriter xmlWriter = new FeatureDatasetCapabilitiesWriter(fd, this.buildDatasetUrl(datasetPath));
            Object stnsList = new String[]{};
            stnsList = params.getStns() != null ? params.getStns().toArray((T[])stnsList) : null;
            LatLonRect llrect = null;
            if (params.getNorth() != null && params.getSouth() != null && params.getEast() != null && params.getWest() != null) {
                llrect = new LatLonRect((LatLonPoint)new LatLonPointImpl(params.getSouth().doubleValue(), params.getWest().doubleValue()), (LatLonPoint)new LatLonPointImpl(params.getNorth().doubleValue(), params.getEast().doubleValue()));
            }
            Document doc = xmlWriter.makeStationCollectionDocument(llrect, stnsList);
            ModelAndView modelAndView = new ModelAndView("threddsXmlView", "Document", (Object)doc);
            return modelAndView;
        }
    }
}

