/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin;

import java.io.IOException;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import thredds.core.AllowedServices;
import thredds.core.ConfigCatalogInitialization;
import thredds.server.admin.DebugCommands;
import thredds.server.catalog.tracker.DatasetTracker;
import thredds.server.catalog.tracker.DatasetTrackerNoop;
import thredds.server.config.TdsContext;
import thredds.util.ContentType;

@Controller
@RequestMapping(value={"/admin/trigger"})
public class AdminTriggerController {
    private static final Logger log = LoggerFactory.getLogger(AdminTriggerController.class);
    @Autowired
    DebugCommands debugCommands;
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private ConfigCatalogInitialization catInit;

    @PostConstruct
    public void afterPropertiesSet() {
        DebugCommands.Category debugHandler = this.debugCommands.findCategory("Catalogs");
        DebugCommands.Action act = new DebugCommands.Action("reportStats", "Make Catalog Report"){

            @Override
            public void doAction(DebugCommands.Event e) {
                e.pw.printf("%n%s%n", AdminTriggerController.this.makeReport());
            }
        };
        debugHandler.addAction(act);
        act = new DebugCommands.Action("reinit", "Read all catalogs"){

            @Override
            public void doAction(DebugCommands.Event e) {
                boolean ok = AdminTriggerController.this.catInit.reread(ConfigCatalogInitialization.ReadMode.always, false);
                e.pw.printf("<p/>Reading all catalogs%n", new Object[0]);
                if (ok) {
                    e.pw.printf("reinit ok%n", new Object[0]);
                } else {
                    e.pw.printf("reinit failed%n", new Object[0]);
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugCommands.Action("recheck", "Read changed catalogs"){

            @Override
            public void doAction(DebugCommands.Event e) {
                boolean ok = AdminTriggerController.this.catInit.reread(ConfigCatalogInitialization.ReadMode.check, false);
                e.pw.printf("<p/>Reading changed catalogs%n", new Object[0]);
                if (ok) {
                    e.pw.printf("reinit ok%n", new Object[0]);
                }
            }
        };
        debugHandler.addAction(act);
    }

    @RequestMapping(value={"/catalog"}, method={RequestMethod.GET}, params={"req=readAll"})
    protected ResponseEntity<String> handleReadAll() throws Exception {
        this.catInit.reread(ConfigCatalogInitialization.ReadMode.always, false);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Content-Type", ContentType.text.getContentHeader());
        String result = "Reading all catalogs";
        return new ResponseEntity((Object)result, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/catalog"}, method={RequestMethod.GET}, params={"req=readChanged"})
    protected ResponseEntity<String> handleReadChanged() throws Exception {
        this.catInit.reread(ConfigCatalogInitialization.ReadMode.check, false);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Content-Type", ContentType.text.getContentHeader());
        String result = "Reading changed catalogs";
        return new ResponseEntity((Object)result, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private String makeReport() {
        DatasetTrackerNoop tracker = new DatasetTrackerNoop();
        AllowedServices allowedServices = new AllowedServices();
        ConfigCatalogInitialization.StatCallback callback = new ConfigCatalogInitialization.StatCallback(ConfigCatalogInitialization.ReadMode.always);
        try {
            ConfigCatalogInitialization ccInit = new ConfigCatalogInitialization(ConfigCatalogInitialization.ReadMode.always, this.tdsContext.getThreddsDirectory(), null, (DatasetTracker)tracker, allowedServices, callback, -1L);
            callback.finish();
            return ((Object)callback).toString();
        }
        catch (IOException e) {
            log.error("AdminTrigerController makeReport failed", (Throwable)e);
            return e.getMessage();
        }
    }
}

