/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.views;

import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractView;
import thredds.util.ContentType;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;

public class FileView
extends AbstractView {
    protected void renderMergedOutputModel(Map model, HttpServletRequest req, HttpServletResponse res) throws Exception {
        long fileSize;
        int pos2;
        int pos;
        if (model == null || model.isEmpty()) {
            throw new IllegalArgumentException("Model must not be null or empty.");
        }
        if (!model.containsKey("file")) {
            throw new IllegalArgumentException("Model must contain \"file\" key.");
        }
        Object o = model.get("file");
        if (!(o instanceof File)) {
            throw new IllegalArgumentException("Object mapped by \"file\" key  must be a File.");
        }
        File file = (File)o;
        if (!file.isFile()) {
            throw new IllegalArgumentException();
        }
        String contentType = null;
        if (model.containsKey("contentType") && (o = model.get("contentType")) instanceof String) {
            contentType = (String)o;
        }
        String characterEncoding = null;
        if (model.containsKey("characterEncoding") && (o = model.get("characterEncoding")) instanceof String) {
            characterEncoding = (String)o;
        }
        String filename = file.getPath();
        if (null == contentType) {
            ContentType type = ContentType.findContentTypeFromFilename((String)filename);
            if (type == null && null == (contentType = this.getServletContext().getMimeType(filename))) {
                type = ContentType.binary;
            }
            if (null == contentType) {
                contentType = type.toString();
            }
        }
        res.setContentType(contentType);
        if (characterEncoding != null) {
            res.setCharacterEncoding(characterEncoding);
        }
        boolean isRangeRequest = false;
        long startPos = 0L;
        long endPos = Long.MAX_VALUE;
        String rangeRequest = req.getHeader("Range");
        if (rangeRequest != null && (pos = rangeRequest.indexOf("=")) > 0 && (pos2 = rangeRequest.indexOf("-")) > 0) {
            String startString = rangeRequest.substring(pos + 1, pos2);
            String endString = rangeRequest.substring(pos2 + 1);
            startPos = Long.parseLong(startString);
            if (endString.length() > 0) {
                endPos = Long.parseLong(endString) + 1L;
            }
            isRangeRequest = true;
        }
        long contentLength = fileSize = file.length();
        if (isRangeRequest) {
            endPos = Math.min(endPos, fileSize);
            contentLength = endPos - startPos;
        }
        res.setContentLength((int)contentLength);
        if (!isRangeRequest) {
            res.addHeader("Accept-Ranges", "bytes");
        }
        if (req.getMethod().equals("HEAD")) {
            return;
        }
        if (isRangeRequest) {
            res.addHeader("Content-Range", "bytes " + startPos + "-" + (endPos - 1L) + "/" + fileSize);
            res.setStatus(206);
            try (RandomAccessFile craf = RandomAccessFile.acquire((String)filename);){
                IO.copyRafB((RandomAccessFile)craf, (long)startPos, (long)contentLength, (OutputStream)res.getOutputStream(), (byte[])new byte[60000]);
                return;
            }
        }
        ServletOutputStream out = res.getOutputStream();
        IO.copyFileB((File)file, (OutputStream)out, (int)60000);
        res.flushBuffer();
        out.close();
    }
}

