/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import com.coverity.security.Escape;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import thredds.core.DataRootManager;
import thredds.core.TdsRequestedDataset;
import thredds.featurecollection.FeatureCollectionCache;
import thredds.featurecollection.InvDatasetFeatureCollection;
import thredds.server.admin.DebugCommands;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.catalog.tracker.DatasetTracker;
import thredds.servlet.DatasetSource;
import thredds.servlet.restrict.Authorizer;
import thredds.util.TdsPathUtils;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageDatasetFactory;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Optional;
import ucar.nc2.util.cache.FileFactory;

@Component
public class DatasetManager
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DatasetManager.class);
    static final boolean debugResourceControl = false;
    @Autowired
    private DataRootManager dataRootManager;
    @Autowired
    private FeatureCollectionCache featureCollectionCache;
    @Autowired
    @Qualifier(value="restrictedDatasetAuthorizer")
    private Authorizer restrictedDatasetAuthorizer;
    @Autowired
    private DebugCommands debugCommands;
    private DatasetTracker datasetTracker;
    private ArrayList<DatasetSource> datasetSources = new ArrayList();

    public void afterPropertiesSet() throws Exception {
        TdsRequestedDataset.setDatasetManager(this);
        this.makeDebugActions();
    }

    public void setDatasetTracker(DatasetTracker datasetTracker) {
        if (this.datasetTracker != null) {
            try {
                this.datasetTracker.close();
            }
            catch (IOException e) {
                log.error("Cant close datasetTracker ", (Throwable)e);
            }
        }
        this.datasetTracker = datasetTracker;
    }

    public String getLocationFromRequestPath(String reqPath) {
        return this.dataRootManager.getLocationFromRequestPath(reqPath);
    }

    public NetcdfFile openNetcdfFile(HttpServletRequest req, HttpServletResponse res, String reqPath) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("DatasetHandler wants " + reqPath);
        }
        if (reqPath == null) {
            return null;
        }
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if (!this.resourceControlOk(req, res, reqPath)) {
            return null;
        }
        String ncml = this.datasetTracker.findNcml(reqPath);
        if (ncml != null) {
            NetcdfFile ncfile = NetcdfDataset.acquireFile((FileFactory)new NcmlFileFactory(ncml), null, (DatasetUrl)DatasetUrl.findDatasetUrl((String)reqPath), (int)-1, null, null);
            if (ncfile == null) {
                throw new FileNotFoundException(reqPath);
            }
            return ncfile;
        }
        DataRootManager.DataRootMatch match = this.dataRootManager.findDataRootMatch(reqPath);
        if (match != null && match.dataRoot.getFeatureCollection() != null) {
            InvDatasetFeatureCollection fc;
            NetcdfDataset ncfile;
            FeatureCollectionRef featCollection = match.dataRoot.getFeatureCollection();
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found FeatureCollection= " + featCollection);
            }
            if ((ncfile = (fc = this.featureCollectionCache.get(featCollection)).getNetcdfDataset(match.remaining)) == null) {
                throw new FileNotFoundException(reqPath);
            }
            return ncfile;
        }
        NetcdfFile ncfile = null;
        for (DatasetSource datasetSource : this.datasetSources) {
            if (!datasetSource.isMine(req) || (ncfile = datasetSource.getNetcdfFile(req, res)) == null) continue;
            return ncfile;
        }
        if (match != null) {
            String location;
            DatasetScan dscan;
            Element netcdfElem = null;
            if (match.dataRoot != null && (dscan = match.dataRoot.getDatasetScan()) != null) {
                netcdfElem = dscan.getNcmlElement();
            }
            if ((location = this.dataRootManager.getLocationFromRequestPath(reqPath)) == null) {
                throw new FileNotFoundException(reqPath);
            }
            if (netcdfElem != null) {
                String ncmlLocation = "DatasetScan#" + location;
                NetcdfDataset ncd = NcMLReader.readNcML((String)ncmlLocation, (Element)netcdfElem, (String)("file:" + location), null);
                return ncd;
            }
            DatasetUrl durl = DatasetUrl.findDatasetUrl((String)location);
            ncfile = NetcdfDataset.acquireFile((DatasetUrl)durl, null);
        }
        if (ncfile == null) {
            throw new FileNotFoundException(reqPath);
        }
        return ncfile;
    }

    public GridDataset openGridDataset(HttpServletRequest req, HttpServletResponse res, String reqPath) throws IOException {
        DataRootManager.DataRootMatch match = this.dataRootManager.findDataRootMatch(reqPath);
        if (match != null && match.dataRoot.getFeatureCollection() != null) {
            InvDatasetFeatureCollection fc;
            GridDataset gds;
            if (!this.resourceAuthorized(req, res, match.dataRoot.getRestrict())) {
                return null;
            }
            FeatureCollectionRef featCollection = match.dataRoot.getFeatureCollection();
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found FeatureCollection= " + featCollection);
            }
            if ((gds = (fc = this.featureCollectionCache.get(featCollection)).getGridDataset(match.remaining)) == null) {
                throw new FileNotFoundException(reqPath);
            }
            return gds;
        }
        NetcdfFile ncfile = this.openNetcdfFile(req, res, reqPath);
        if (ncfile == null) {
            return null;
        }
        NetcdfDataset ncd = null;
        try {
            ncd = NetcdfDataset.wrap((NetcdfFile)ncfile, (Set)NetcdfDataset.getDefaultEnhanceMode());
            return new GridDataset(ncd);
        }
        catch (Throwable t) {
            if (ncd == null) {
                ncfile.close();
            } else {
                ncd.close();
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            String msg = ncd == null ? "Problem wrapping NetcdfFile in NetcdfDataset" : "Problem creating GridDataset from NetcdfDataset";
            log.error("openGridDataset(): " + msg, t);
            throw new IOException(msg + t.getMessage());
        }
    }

    public FeatureDatasetPoint openPointDataset(HttpServletRequest req, HttpServletResponse res, String reqPath) throws IOException {
        DataRootManager.DataRootMatch match = this.dataRootManager.findDataRootMatch(reqPath);
        if (match != null && match.dataRoot.getFeatureCollection() != null) {
            InvDatasetFeatureCollection fc;
            FeatureDatasetPoint fd;
            if (!this.resourceAuthorized(req, res, match.dataRoot.getRestrict())) {
                return null;
            }
            FeatureCollectionRef featCollection = match.dataRoot.getFeatureCollection();
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found FeatureCollection= " + featCollection);
            }
            if ((fd = (fc = this.featureCollectionCache.get(featCollection)).getPointDataset(match.remaining)) == null) {
                throw new IllegalArgumentException("Not a Point Dataset " + fc.getName());
            }
            return fd;
        }
        NetcdfFile ncfile = this.openNetcdfFile(req, res, reqPath);
        if (ncfile == null) {
            return null;
        }
        Formatter errlog = new Formatter();
        NetcdfDataset ncd = null;
        try {
            ncd = NetcdfDataset.wrap((NetcdfFile)ncfile, (Set)NetcdfDataset.getDefaultEnhanceMode());
            return (FeatureDatasetPoint)FeatureDatasetFactoryManager.wrap((FeatureType)FeatureType.ANY_POINT, (NetcdfDataset)ncd, null, (Formatter)errlog);
        }
        catch (Throwable t) {
            if (ncd == null) {
                ncfile.close();
            } else {
                ncd.close();
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            String msg = ncd == null ? "Problem wrapping NetcdfFile in NetcdfDataset; " : "Problem calling FeatureDatasetFactoryManager; ";
            msg = msg + errlog.toString();
            log.error("openGridDataset(): " + msg, t);
            throw new IOException(msg + t.getMessage());
        }
    }

    public CoverageCollection openCoverageDataset(HttpServletRequest req, HttpServletResponse res, String reqPath) throws IOException {
        if (reqPath == null) {
            return null;
        }
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if (!this.resourceControlOk(req, res, reqPath)) {
            return null;
        }
        DataRootManager.DataRootMatch match = this.dataRootManager.findDataRootMatch(reqPath);
        if (match != null && match.dataRoot.getFeatureCollection() != null) {
            InvDatasetFeatureCollection fc;
            CoverageCollection gds;
            FeatureCollectionRef featCollection = match.dataRoot.getFeatureCollection();
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found FeatureCollection= " + featCollection);
            }
            if ((gds = (fc = this.featureCollectionCache.get(featCollection)).getGridCoverage(match.remaining)) == null) {
                throw new FileNotFoundException(reqPath);
            }
            return gds;
        }
        String location = this.getLocationFromRequestPath(reqPath);
        if (location != null) {
            Optional opt = CoverageDatasetFactory.openCoverageDataset((String)location);
            if (!opt.isPresent()) {
                throw new FileNotFoundException("Not a Grid Dataset " + reqPath + " err=" + opt.getErrorMessage());
            }
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found FeatureCollection from file= " + location);
            }
            return ((FeatureDatasetCoverage)opt.get()).getSingleCoverageCollection();
        }
        String ncml = this.datasetTracker.findNcml(reqPath);
        if (ncml != null) {
            Optional opt = CoverageDatasetFactory.openNcmlString((String)ncml);
            if (!opt.isPresent()) {
                throw new FileNotFoundException("NcML is not a Grid Dataset " + reqPath + " err=" + opt.getErrorMessage());
            }
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found FeatureCollection from NcML");
            }
            return ((FeatureDatasetCoverage)opt.get()).getSingleCoverageCollection();
        }
        return null;
    }

    public boolean resourceControlOk(HttpServletRequest req, HttpServletResponse res, String reqPath) {
        if (null == reqPath) {
            reqPath = TdsPathUtils.extractPath(req, null);
        }
        String rc = null;
        DataRootManager.DataRootMatch match = this.dataRootManager.findDataRootMatch(reqPath);
        if (match != null) {
            rc = match.dataRoot.getRestrict();
        }
        if (rc == null) {
            rc = this.datasetTracker.findResourceControl(reqPath);
        }
        return this.resourceAuthorized(req, res, rc);
    }

    private boolean resourceAuthorized(HttpServletRequest req, HttpServletResponse res, String rc) {
        if (rc == null) {
            return true;
        }
        try {
            if (!this.restrictedDatasetAuthorizer.authorize(req, res, rc)) {
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return true;
    }

    public void registerDatasetSource(String className) {
        Object instance;
        Class<?> vClass;
        try {
            vClass = DatasetManager.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            log.error("Attempt to load DatasetSource class " + className + " not found");
            return;
        }
        if (!DatasetSource.class.isAssignableFrom(vClass)) {
            log.error("Attempt to load class " + className + " does not implement " + DatasetSource.class.getName());
            return;
        }
        try {
            instance = vClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error("Attempt to load Viewer class " + className + " cannot instantiate, probably need default Constructor.");
            return;
        }
        catch (IllegalAccessException e) {
            log.error("Attempt to load Viewer class " + className + " is not accessible.");
            return;
        }
        this.registerDatasetSource((DatasetSource)instance);
    }

    public void registerDatasetSource(DatasetSource v) {
        this.datasetSources.add(v);
    }

    public InvDatasetFeatureCollection openFeatureCollection(FeatureCollectionRef ftCollection) throws IOException {
        return this.featureCollectionCache.get(ftCollection);
    }

    void makeDebugActions() {
        DebugCommands.Category debugHandler = this.debugCommands.findCategory("Catalogs");
        DebugCommands.Action act = new DebugCommands.Action("showDatasetTrackerDB", "Show DatasetTracker database"){

            @Override
            public void doAction(DebugCommands.Event e) {
                Formatter f = new Formatter();
                DatasetManager.this.datasetTracker.showDB(f);
                e.pw.println(Escape.html((String)f.toString()));
            }
        };
        debugHandler.addAction(act);
    }

    private static class NcmlFileFactory
    implements FileFactory {
        private String ncml;

        NcmlFileFactory(String ncml) {
            this.ncml = ncml;
        }

        public NetcdfFile open(DatasetUrl durl, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            return NcMLReader.readNcML((Reader)new StringReader(this.ncml), (String)durl.trueurl, (CancelTask)cancelTask);
        }
    }
}

