/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.notebook;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.core.AllowedServices;
import thredds.core.CatalogManager;
import thredds.core.StandardService;
import thredds.core.TdsRequestedDataset;
import thredds.server.config.TdsContext;
import thredds.server.exception.ServiceNotAllowed;
import thredds.server.notebook.JupyterNotebookServiceCache;
import thredds.server.notebook.NotebookParamsBean;
import thredds.util.Constants;

@Controller
@RequestMapping(value={"/notebook"})
public class NotebookController {
    private final String DS_REPLACE_TEXT = "{{datasetName}}";
    private final String CAT_REPLACE_TEXT = "{{catUrl}}";
    @Autowired
    TdsContext tdsContext;
    @Autowired
    CatalogManager catalogManager;
    @Autowired
    AllowedServices allowedServices;
    @Autowired
    JupyterNotebookServiceCache jupyterNotbooks;

    @RequestMapping(value={"**"})
    public void getNotebookForDataset(HttpServletRequest req, HttpServletResponse res, @Valid NotebookParamsBean params, BindingResult validationResult) throws Exception {
        if (!this.allowedServices.isAllowed(StandardService.jupyterNotebook)) {
            throw new ServiceNotAllowed(StandardService.jupyterNotebook.toString());
        }
        TdsRequestedDataset reqD = new TdsRequestedDataset(req, this.getBase());
        String datasetId = reqD.getPath();
        String catalogName = params.catalog;
        if (catalogName == null) {
            throw new IllegalArgumentException("Argument 'catalog' cannot be null.");
        }
        Catalog catalog = this.getCatalog(catalogName, req);
        Dataset dataset = catalog.findDatasetByID(datasetId);
        File responseFile = this.getNotebookFile(dataset, catalog);
        if (responseFile == null) {
            throw new ServiceNotAllowed(StandardService.jupyterNotebook.toString());
        }
        String fileContents = new String(Files.readAllBytes(Paths.get(responseFile.getAbsolutePath(), new String[0])));
        String catUrlString = req.getRequestURL().toString();
        catUrlString = catUrlString.substring(0, catUrlString.indexOf(this.getBase())) + StandardService.catalogRemote.getBase() + catalogName;
        fileContents = fileContents.replace("{{datasetName}}", dataset.getName()).replace("{{catUrl}}", catUrlString);
        res.setHeader("Content-Disposition", Constants.setContentDispositionValue((String)responseFile.getName()));
        res.setHeader("Content-Length", Integer.toString(fileContents.length()));
        String mimeType = "application/x-ipynb+json";
        res.setContentType(mimeType);
        res.getOutputStream().write(fileContents.getBytes());
        res.flushBuffer();
        res.getOutputStream().close();
        res.setStatus(200);
    }

    protected String getBase() {
        return StandardService.jupyterNotebook.getBase();
    }

    private Catalog getCatalog(String catalogName, HttpServletRequest req) throws URISyntaxException, IOException {
        Catalog catalog;
        String catalogReqBase = StandardService.catalogRemote.getBase();
        String baseUriString = req.getRequestURL().toString().replace(this.getBase(), catalogReqBase);
        baseUriString = baseUriString.substring(0, baseUriString.indexOf(catalogReqBase) + catalogReqBase.length());
        try {
            URI baseUri = new URI(baseUriString);
            catalog = this.catalogManager.getCatalog(catalogName, baseUri);
        }
        catch (URISyntaxException e) {
            String msg = "Bad URI syntax [" + baseUriString + "]: " + e.getMessage();
            throw new URISyntaxException(msg, e.getReason());
        }
        if (catalog == null) {
            throw new FileNotFoundException(baseUriString + catalogName);
        }
        return catalog;
    }

    private File getNotebookFile(Dataset ds, Catalog cat) {
        String filename = this.jupyterNotbooks.getNotebookFilename(ds);
        if (filename == null) {
            return null;
        }
        File notebooksDir = new File(this.tdsContext.getThreddsDirectory(), "notebooks");
        if (notebooksDir.exists() && notebooksDir.isDirectory()) {
            File jupyterViewer = new File(notebooksDir, filename);
            return jupyterViewer.exists() ? jupyterViewer : null;
        }
        return null;
    }
}

