/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.viewer;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Property;
import thredds.client.catalog.ServiceType;
import thredds.core.AllowedServices;
import thredds.core.StandardService;
import thredds.server.config.TdsContext;
import thredds.server.notebook.JupyterNotebookServiceCache;
import thredds.server.viewer.Viewer;
import thredds.server.viewer.ViewerLinkProvider;
import thredds.server.viewer.ViewerService;
import thredds.server.wms.Godiva3Viewer;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

@Component
public class ViewerServiceImpl
implements ViewerService {
    private static Logger logger = LoggerFactory.getLogger(ViewerServiceImpl.class);
    private List<Viewer> viewers = new ArrayList<Viewer>();
    private HashMap<String, String> templates = new HashMap();
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private JupyterNotebookServiceCache jupyterNotebooks;
    @Autowired
    private AllowedServices allowedServices;
    private static final String propertyNamePrefix = "viewer";

    public static ViewerLinkProvider getStaticView() {
        return new StaticView();
    }

    @Override
    public List<Viewer> getViewers() {
        return null;
    }

    @Override
    public Viewer getViewer(String viewer) {
        return null;
    }

    @Override
    public boolean registerViewer(Viewer v) {
        return this.viewers.add(v);
    }

    @Override
    public String getViewerTemplate(String path) {
        String template = this.templates.get(path);
        if (template != null) {
            return template;
        }
        try {
            template = IO.readFile((String)path);
        }
        catch (IOException ioe) {
            return null;
        }
        this.templates.put(path, template);
        return template;
    }

    @Override
    public void showViewers(Formatter out, Dataset dataset, HttpServletRequest req) {
        int count = 0;
        for (Viewer viewer : this.viewers) {
            if (!viewer.isViewable(dataset)) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        out.format("<h3>Viewers:</h3><ul>\r\n", new Object[0]);
        for (Viewer viewer : this.viewers) {
            if (!viewer.isViewable(dataset)) continue;
            if (viewer instanceof ViewerLinkProvider) {
                List<ViewerLinkProvider.ViewerLink> sp = ((ViewerLinkProvider)viewer).getViewerLinks(dataset, req);
                for (ViewerLinkProvider.ViewerLink vl : sp) {
                    if (vl.getUrl() == null || vl.getUrl().equals("")) continue;
                    out.format("<li><a href='%s'>%s</a></li>\r\n", vl.getUrl(), vl.getTitle() != null ? vl.getTitle() : vl.getUrl());
                }
                continue;
            }
            String viewerLinkHtml = viewer.getViewerLinkHtml(dataset, req);
            if (viewerLinkHtml == null) continue;
            out.format("  <li> %s</li>\r\n", viewerLinkHtml);
        }
        out.format("</ul>\r\n", new Object[0]);
    }

    @Override
    public List<ViewerLinkProvider.ViewerLink> getViewerLinks(Dataset dataset, HttpServletRequest req) {
        ArrayList<ViewerLinkProvider.ViewerLink> viewerLinks = new ArrayList<ViewerLinkProvider.ViewerLink>();
        for (Viewer viewer : this.viewers) {
            if (!viewer.isViewable(dataset)) continue;
            if (viewer instanceof ViewerLinkProvider) {
                viewerLinks.addAll(((ViewerLinkProvider)viewer).getViewerLinks(dataset, req));
                continue;
            }
            viewerLinks.add(viewer.getViewerLink(dataset, req));
        }
        return viewerLinks;
    }

    @PostConstruct
    private void registerViewers() {
        this.registerViewer(new Godiva3Viewer());
        this.registerViewer(new ToolsUI());
        this.registerViewer(new IDV());
        this.registerViewer(new StaticView());
        this.registerViewer(new JupyterNotebookViewer(this.jupyterNotebooks, this.allowedServices, this.tdsContext.getContentRootPathProperty()));
    }

    private static class StaticView
    implements ViewerLinkProvider {
        private StaticView() {
        }

        @Override
        public boolean isViewable(Dataset ds) {
            return this.hasViewerProperties(ds);
        }

        @Override
        public String getViewerLinkHtml(Dataset ds, HttpServletRequest req) {
            List<ViewerLinkProvider.ViewerLink> viewerLinks = this.getViewerLinks(ds, req);
            if (viewerLinks.isEmpty()) {
                return null;
            }
            ViewerLinkProvider.ViewerLink firstLink = viewerLinks.get(0);
            return "<a href='" + firstLink.getUrl() + "'>" + firstLink.getTitle() + "</a>";
        }

        @Override
        public ViewerLinkProvider.ViewerLink getViewerLink(Dataset ds, HttpServletRequest req) {
            List<ViewerLinkProvider.ViewerLink> viewerLinks = this.getViewerLinks(ds, req);
            if (viewerLinks.isEmpty()) {
                return null;
            }
            return viewerLinks.get(0);
        }

        @Override
        public List<ViewerLinkProvider.ViewerLink> getViewerLinks(Dataset ds, HttpServletRequest req) {
            List<Property> viewerProperties = this.findViewerProperties(ds);
            if (viewerProperties.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ViewerLinkProvider.ViewerLink> result = new ArrayList<ViewerLinkProvider.ViewerLink>();
            for (Property p : viewerProperties) {
                ViewerLinkProvider.ViewerLink viewerLink = this.parseViewerPropertyValue(p.getName(), p.getValue(), ds);
                if (viewerLink == null) continue;
                result.add(viewerLink);
            }
            return result;
        }

        private ViewerLinkProvider.ViewerLink parseViewerPropertyValue(String viewerName, String viewerValue, Dataset ds) {
            String viewerTitle;
            String viewerUrl;
            int lastCommaLocation = viewerValue.lastIndexOf(",");
            if (lastCommaLocation != -1) {
                viewerUrl = viewerValue.substring(0, lastCommaLocation);
                viewerTitle = viewerValue.substring(lastCommaLocation + 1);
                if (viewerUrl.equals("")) {
                    return null;
                }
                if (viewerTitle.equals("")) {
                    viewerTitle = viewerName;
                }
            } else {
                viewerUrl = viewerValue;
                viewerTitle = viewerName;
            }
            viewerUrl = this.sub(viewerUrl, ds);
            return new ViewerLinkProvider.ViewerLink(viewerTitle, viewerUrl);
        }

        private boolean hasViewerProperties(Dataset ds) {
            for (Property p : ds.getProperties()) {
                if (!p.getName().startsWith(ViewerServiceImpl.propertyNamePrefix)) continue;
                return true;
            }
            return false;
        }

        private List<Property> findViewerProperties(Dataset ds) {
            ArrayList<Property> result = new ArrayList<Property>();
            for (Property p : ds.getProperties()) {
                if (!p.getName().startsWith(ViewerServiceImpl.propertyNamePrefix)) continue;
                result.add(p);
            }
            return result;
        }

        private String sub(String org, Dataset ds) {
            URI uri;
            Access acc2;
            List access = ds.getAccess();
            if (access.size() == 0) {
                return org;
            }
            for (Access acc2 : access) {
                URI uri2;
                String sname = "{" + acc2.getService().getServiceTypeName() + "}";
                if (!org.contains(sname) || (uri2 = acc2.getStandardUri()) == null) continue;
                return StringUtil2.substitute((String)org, (String)sname, (String)uri2.toString());
            }
            String sname = "{url}";
            if (org.contains(sname) && access.size() > 0 && (uri = (acc2 = (Access)access.get(0)).getStandardUri()) != null) {
                return StringUtil2.substitute((String)org, (String)sname, (String)uri.toString());
            }
            return org;
        }
    }

    private static class JupyterNotebookViewer
    implements Viewer {
        private static final String title = "Jupyter Notebook viewer";
        private JupyterNotebookServiceCache jupyterNotebooks;
        private AllowedServices allowedServices;
        private String contentDir;

        public JupyterNotebookViewer(JupyterNotebookServiceCache jupyterNotebooks, AllowedServices allowedServices, String contentDir) {
            this.jupyterNotebooks = jupyterNotebooks;
            this.allowedServices = allowedServices;
            this.contentDir = contentDir;
        }

        @Override
        public boolean isViewable(Dataset ds) {
            return this.allowedServices.isAllowed(StandardService.jupyterNotebook) && this.jupyterNotebooks.getNotebookFilename(ds) != null;
        }

        @Override
        public String getViewerLinkHtml(Dataset ds, HttpServletRequest req) {
            ViewerLinkProvider.ViewerLink viewerLink = this.getViewerLink(ds, req);
            return "<a href='" + viewerLink.getUrl() + "'>" + viewerLink.getTitle() + "</a>";
        }

        @Override
        public ViewerLinkProvider.ViewerLink getViewerLink(Dataset ds, HttpServletRequest req) {
            String catUrl = ds.getCatalogUrl();
            if (catUrl.indexOf(35) > 0) {
                catUrl = catUrl.substring(0, catUrl.lastIndexOf(35));
            }
            if (catUrl.indexOf(this.contentDir) > -1) {
                catUrl = catUrl.substring(catUrl.indexOf(this.contentDir) + this.contentDir.length());
            }
            String catalogServiceBase = StandardService.catalogRemote.getBase();
            catUrl = catUrl.substring(catUrl.indexOf(catalogServiceBase) + catalogServiceBase.length()).replace("html", "xml");
            String url = req.getContextPath() + StandardService.jupyterNotebook.getBase() + ds.getID() + "?catalog=" + catUrl;
            return new ViewerLinkProvider.ViewerLink(title, url);
        }
    }

    private static class IDV
    implements Viewer {
        private static final String title = "Integrated Data Viewer (IDV) (webstart)";

        private IDV() {
        }

        @Override
        public boolean isViewable(Dataset ds) {
            Access access = this.getOpendapAccess(ds);
            if (access == null) {
                return false;
            }
            FeatureType dt = ds.getFeatureType();
            return dt == FeatureType.GRID;
        }

        @Override
        public String getViewerLinkHtml(Dataset ds, HttpServletRequest req) {
            ViewerLinkProvider.ViewerLink viewerLink = this.getViewerLink(ds, req);
            return "<a href='" + viewerLink.getUrl() + "'>" + viewerLink.getTitle() + "</a>";
        }

        @Override
        public ViewerLinkProvider.ViewerLink getViewerLink(Dataset ds, HttpServletRequest req) {
            Access access = this.getOpendapAccess(ds);
            if (access == null) {
                return null;
            }
            URI dataURI = access.getStandardUri();
            if (dataURI == null) {
                logger.warn("IDVViewer access URL failed on {}", (Object)ds.getName());
                return null;
            }
            if (!dataURI.isAbsolute()) {
                try {
                    URI base = new URI(req.getRequestURL().toString());
                    dataURI = base.resolve(dataURI);
                }
                catch (URISyntaxException e) {
                    logger.error("Resolve URL with " + req.getRequestURL(), (Throwable)e);
                }
            }
            String url = req.getContextPath() + "/view/idv.jnlp?url=" + dataURI.toString();
            return new ViewerLinkProvider.ViewerLink(title, url);
        }

        private Access getOpendapAccess(Dataset ds) {
            Access access = ds.getAccess(ServiceType.DODS);
            if (access == null) {
                access = ds.getAccess(ServiceType.OPENDAP);
            }
            return access;
        }
    }

    private static class ToolsUI
    implements Viewer {
        private static final String title = "NetCDF-Java ToolsUi (webstart)";

        private ToolsUI() {
        }

        @Override
        public boolean isViewable(Dataset ds) {
            String id = ds.getID();
            return id != null && ds.hasAccess();
        }

        @Override
        public String getViewerLinkHtml(Dataset ds, HttpServletRequest req) {
            ViewerLinkProvider.ViewerLink viewerLink = this.getViewerLink(ds, req);
            Formatter query = new Formatter();
            query.format("<a href='%s'>%s</a>", viewerLink.getUrl(), viewerLink.getTitle());
            return query.toString();
        }

        @Override
        public ViewerLinkProvider.ViewerLink getViewerLink(Dataset ds, HttpServletRequest req) {
            String base = ds.getParentCatalog().getUriString();
            if (base.endsWith(".html")) {
                base = base.substring(0, base.length() - 5) + ".xml";
            }
            Formatter query = new Formatter();
            query.format("%s/view/ToolsUI.jnlp?", req.getContextPath());
            query.format("catalog=%s&amp;dataset=%s", base, ds.getID());
            return new ViewerLinkProvider.ViewerLink(title, query.toString());
        }
    }
}

