/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;
import thredds.server.wms.TdsWmsDatasetFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.NetcdfDataset;
import uk.ac.rdg.resc.edal.dataset.DataSource;
import uk.ac.rdg.resc.edal.dataset.Dataset;
import uk.ac.rdg.resc.edal.dataset.DiscreteLayeredDataset;
import uk.ac.rdg.resc.edal.domain.MapDomain;
import uk.ac.rdg.resc.edal.exceptions.EdalException;
import uk.ac.rdg.resc.edal.graphics.exceptions.EdalLayerNotFoundException;
import uk.ac.rdg.resc.edal.graphics.utils.EnhancedVariableMetadata;
import uk.ac.rdg.resc.edal.graphics.utils.FeatureCatalogue;
import uk.ac.rdg.resc.edal.graphics.utils.LayerNameMapper;
import uk.ac.rdg.resc.edal.graphics.utils.PlottingDomainParams;
import uk.ac.rdg.resc.edal.graphics.utils.PlottingStyleParameters;
import uk.ac.rdg.resc.edal.graphics.utils.SldTemplateStyleCatalogue;
import uk.ac.rdg.resc.edal.graphics.utils.StyleCatalogue;
import uk.ac.rdg.resc.edal.metadata.DiscreteLayeredVariableMetadata;
import uk.ac.rdg.resc.edal.metadata.VariableMetadata;
import uk.ac.rdg.resc.edal.util.CollectionUtils;
import uk.ac.rdg.resc.edal.wms.WmsCatalogue;
import uk.ac.rdg.resc.edal.wms.util.ContactInfo;
import uk.ac.rdg.resc.edal.wms.util.ServerInfo;

public class ThreddsWmsCatalogue
implements WmsCatalogue {
    static TdsWmsDatasetFactory datasetFactory = new TdsWmsDatasetFactory();
    private DiscreteLayeredDataset<? extends DataSource, ? extends DiscreteLayeredVariableMetadata> dataset;
    private static final StyleCatalogue styleCatalogue = SldTemplateStyleCatalogue.getStyleCatalogue();
    private String datasetTitle;

    public ThreddsWmsCatalogue(NetcdfDataset ncd, String id) throws IOException, EdalException {
        Attribute datasetTitleAttr;
        datasetFactory.setNetcdfDataset(ncd);
        this.datasetTitle = ncd.getTitle();
        if (this.datasetTitle == null && (datasetTitleAttr = ncd.findGlobalAttributeIgnoreCase("title")) != null) {
            this.datasetTitle = datasetTitleAttr.getStringValue();
        }
        String location = ncd.getLocation();
        this.dataset = datasetFactory.createDataset(id, location);
    }

    public FeatureCatalogue.FeaturesAndMemberName getFeaturesForLayer(String layerName, PlottingDomainParams params) throws EdalException {
        MapDomain mapDomain = new MapDomain(params.getBbox(), params.getWidth(), params.getHeight(), params.getTargetZ(), params.getTargetT());
        List extractedFeatures = this.dataset.extractMapFeatures(CollectionUtils.setOf((Object[])new String[]{layerName}), mapDomain);
        return new FeatureCatalogue.FeaturesAndMemberName((Collection)extractedFeatures, layerName);
    }

    public Collection<Dataset> getAllDatasets() {
        ArrayList<Dataset> ret = new ArrayList<Dataset>();
        ret.add((Dataset)this.dataset);
        return ret;
    }

    public boolean allowsGlobalCapabilities() {
        return true;
    }

    public Dataset getDatasetFromId(String layerName) {
        return this.dataset;
    }

    public String getDatasetTitle(String layerName) {
        return this.datasetTitle != null ? this.datasetTitle : "Untitled Dataset";
    }

    public boolean isDisabled(String layerName) {
        return false;
    }

    public boolean isDownloadable(String layerName) {
        return false;
    }

    public boolean isQueryable(String layerName) {
        return true;
    }

    public DateTime getLastUpdateTime() {
        return new DateTime();
    }

    public ContactInfo getContactInfo() {
        return new ContactInfo(){

            public String getTelephone() {
                return "x5217";
            }

            public String getOrganisation() {
                return "ReSC";
            }

            public String getName() {
                return "Guy";
            }

            public String getEmail() {
                return "guy@reading";
            }
        };
    }

    public ServerInfo getServerInfo() {
        return new ServerInfo(){

            public String getName() {
                return "THREDDS server";
            }

            public int getMaxSimultaneousLayers() {
                return 1;
            }

            public int getMaxImageWidth() {
                return 1000;
            }

            public int getMaxImageHeight() {
                return 1000;
            }

            public List<String> getKeywords() {
                return new ArrayList<String>();
            }

            public String getAbstract() {
                return "This is a THREDDS data server";
            }

            public boolean allowsFeatureInfo() {
                return true;
            }

            public boolean allowsGlobalCapabilities() {
                return true;
            }
        };
    }

    public LayerNameMapper getLayerNameMapper() {
        return new LayerNameMapper(){

            public String getVariableIdFromLayerName(String layerName) throws EdalLayerNotFoundException {
                return layerName;
            }

            public String getLayerName(String datasetId, String varId) {
                return varId;
            }

            public String getDatasetIdFromLayerName(String layerName) throws EdalLayerNotFoundException {
                return ThreddsWmsCatalogue.this.dataset.getId();
            }
        };
    }

    public StyleCatalogue getStyleCatalogue() {
        return styleCatalogue;
    }

    public EnhancedVariableMetadata getLayerMetadata(final VariableMetadata metadata) throws EdalLayerNotFoundException {
        return new EnhancedVariableMetadata(){

            public String getId() {
                return metadata.getId();
            }

            public String getTitle() {
                return metadata.getId();
            }

            public String getDescription() {
                return null;
            }

            public String getCopyright() {
                return null;
            }

            public String getMoreInfo() {
                return null;
            }

            public PlottingStyleParameters getDefaultPlottingParameters() {
                List scaleRanges = null;
                String palette = null;
                Color aboveMaxColour = null;
                Color belowMinColour = null;
                Color noDataColour = null;
                Boolean logScaling = false;
                Integer numColourBands = null;
                Float opacity = Float.valueOf(1.0f);
                return new PlottingStyleParameters(scaleRanges, palette, aboveMaxColour, belowMinColour, noDataColour, logScaling, numColourBands, opacity);
            }

            public boolean isQueryable() {
                return false;
            }

            public boolean isDownloadable() {
                return false;
            }

            public boolean isDisabled() {
                return false;
            }
        };
    }
}

