/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HttpHeadFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (this.isHttpHead(httpServletRequest)) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            NoBodyResponseWrapper noBodyResponseWrapper = new NoBodyResponseWrapper(httpServletResponse);
            chain.doFilter((ServletRequest)new ForceGetRequestWrapper(httpServletRequest), (ServletResponse)noBodyResponseWrapper);
            noBodyResponseWrapper.setContentLength();
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private boolean isHttpHead(HttpServletRequest request) {
        return "HEAD".equals(request.getMethod());
    }

    private class NoBodyOutputStream
    extends ServletOutputStream {
        private int contentLength = 0;

        private NoBodyOutputStream() {
        }

        int getContentLength() {
            return this.contentLength;
        }

        public void write(int b) {
            ++this.contentLength;
        }

        public void write(byte[] buf, int offset, int len) throws IOException {
            this.contentLength += len;
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException("NoBodyOutputStream does not support setWriteListener");
        }
    }

    private class NoBodyResponseWrapper
    extends HttpServletResponseWrapper {
        private final NoBodyOutputStream noBodyOutputStream;
        private PrintWriter writer;

        public NoBodyResponseWrapper(HttpServletResponse response) {
            super(response);
            this.noBodyOutputStream = new NoBodyOutputStream();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.noBodyOutputStream;
        }

        public PrintWriter getWriter() throws UnsupportedEncodingException {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.noBodyOutputStream), this.getCharacterEncoding()));
            }
            return this.writer;
        }

        void setContentLength() {
            super.setContentLength(this.noBodyOutputStream.getContentLength());
        }
    }

    private class ForceGetRequestWrapper
    extends HttpServletRequestWrapper {
        public ForceGetRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getMethod() {
            return "GET";
        }
    }
}

