/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import thredds.core.StandardService;
import thredds.core.TdsRequestedDataset;
import thredds.server.ncss.controller.AbstractNcssController;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.format.SupportedOperation;
import thredds.server.ncss.params.NcssPointParamsBean;
import thredds.server.ncss.view.dsg.DsgSubsetWriter;
import thredds.server.ncss.view.dsg.DsgSubsetWriterFactory;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.writer.FeatureDatasetCapabilitiesWriter;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

@Controller
@RequestMapping(value={"/ncss/point"})
public class NcssPointController
extends AbstractNcssController {
    @Override
    protected String getBase() {
        return StandardService.netcdfSubsetPoint.getBase();
    }

    @RequestMapping(value={"**"})
    public void handleRequest(HttpServletRequest req, HttpServletResponse res, @Valid NcssPointParamsBean params, BindingResult validationResult) throws Exception {
        if (validationResult.hasErrors()) {
            throw new BindException(validationResult);
        }
        String datasetPath = this.getDatasetPath(req);
        try (FeatureDatasetPoint fdp = TdsRequestedDataset.getPointDataset(req, res, datasetPath);){
            if (fdp == null) {
                return;
            }
            Formatter errs = new Formatter();
            if (!params.intersectsTime(fdp.getCalendarDateRange(), errs)) {
                this.handleValidationErrorMessage(res, 400, errs.toString());
                return;
            }
            FeatureType ft = fdp.getFeatureType();
            if (ft != FeatureType.POINT && ft != FeatureType.STATION) {
                throw new NcssException("Dataset Feature Type is " + ft.toString() + " but request is for Points or Stations");
            }
            SubsetParams ncssParams = params.makeSubset();
            SupportedFormat format = NcssPointController.getSupportedOperation((FeatureDataset)fdp).getSupportedFormat(params.getAccept());
            DsgSubsetWriter pds = DsgSubsetWriterFactory.newInstance(fdp, ncssParams, this.ncssDiskCache, (OutputStream)res.getOutputStream(), format);
            this.setResponseHeaders(res, pds.getHttpHeaders(datasetPath, format.isStream()));
            pds.respond(res, (FeatureDataset)fdp, datasetPath, ncssParams, format);
        }
    }

    @RequestMapping(value={"**/dataset.xml", "**/pointDataset.xml"})
    public ModelAndView getDatasetDescriptionXml(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String datasetPath = this.getDatasetPath(req);
        try (FeatureDatasetPoint fdp = TdsRequestedDataset.getPointDataset(req, res, datasetPath);){
            if (fdp == null) {
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            String datasetUrlPath = this.buildDatasetUrl(datasetPath);
            SupportedOperation supportedOperation = NcssPointController.getSupportedOperation((FeatureDataset)fdp);
            FeatureDatasetCapabilitiesWriter xmlWriter = new FeatureDatasetCapabilitiesWriter(fdp, datasetUrlPath);
            Document doc = xmlWriter.getCapabilitiesDocument();
            Element root = doc.getRootElement();
            root.setAttribute("location", datasetUrlPath);
            root.addContent((Content)NcssPointController.makeAcceptXML(supportedOperation));
            ModelAndView modelAndView = new ModelAndView("threddsXmlView", "Document", (Object)doc);
            return modelAndView;
        }
    }

    @RequestMapping(value={"**/dataset.html", "**/pointDataset.html"})
    public ModelAndView getDatasetDescriptionHtml(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String datasetPath = this.getDatasetPath(req);
        try (FeatureDatasetPoint fdp = TdsRequestedDataset.getPointDataset(req, res, datasetPath);){
            ModelAndView modelAndView;
            if (fdp == null) {
                ModelAndView modelAndView2 = null;
                return modelAndView2;
            }
            String datasetUrlPath = this.buildDatasetUrl(datasetPath);
            SupportedOperation supportedOperation = NcssPointController.getSupportedOperation((FeatureDataset)fdp);
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("fdp", fdp);
            model.put("datasetPath", datasetUrlPath);
            model.put("accept", NcssPointController.makeAcceptList(supportedOperation));
            List dsgFeatCols = fdp.getPointFeatureCollectionList();
            if (dsgFeatCols.size() != 1) {
                throw new AssertionError((Object)String.format("Expected dataset to contain exactly 1 DsgFeatureCollection, but instead it has %d. We (the THREDDS developers) weren't certain that such datasets actually existed in the wild! Please tell us about it at support-thredds@unidata.ucar.edu.", dsgFeatCols.size()));
            }
            DsgFeatureCollection dsgFeatCol = (DsgFeatureCollection)dsgFeatCols.get(0);
            LatLonRect boundingBox = dsgFeatCol.getBoundingBox();
            if (boundingBox == null) {
                boundingBox = new LatLonRect((LatLonPoint)new LatLonPointImpl(-90.0, -180.0), (LatLonPoint)new LatLonPointImpl(90.0, 180.0));
            }
            model.put("boundingBox", boundingBox);
            String horizExtentWKT = String.format("POLYGON((%f %f, %f %f, %f %f, %f %f, %f %f))", boundingBox.getLonMin(), boundingBox.getLatMax(), boundingBox.getLonMax(), boundingBox.getLatMax(), boundingBox.getLonMax(), boundingBox.getLatMin(), boundingBox.getLonMin(), boundingBox.getLatMin(), boundingBox.getLonMin(), boundingBox.getLatMax());
            model.put("horizExtentWKT", horizExtentWKT);
            CalendarDateRange calendarDateRange = dsgFeatCol.getCalendarDateRange();
            if (calendarDateRange == null) {
                CalendarDate start = CalendarDate.of(null, (int)0, (int)1, (int)1, (int)0, (int)0, (int)0);
                CalendarDate end = CalendarDate.present();
                calendarDateRange = CalendarDateRange.of((CalendarDate)start, (CalendarDate)end);
            }
            model.put("calendarDateRange", calendarDateRange);
            if (supportedOperation == SupportedOperation.POINT_REQUEST) {
                modelAndView = new ModelAndView("templates/ncssPoint", model);
                return modelAndView;
            }
            modelAndView = new ModelAndView("templates/ncssStation", model);
            return modelAndView;
        }
    }

    @RequestMapping(value={"**/station.xml"})
    public ModelAndView getStations(HttpServletRequest req, HttpServletResponse res, NcssPointParamsBean params) throws IOException {
        String datasetPath = this.getDatasetPath(req);
        try (FeatureDatasetPoint fd = TdsRequestedDataset.getPointDataset(req, res, datasetPath);){
            if (fd == null) {
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            if (fd.getFeatureType() != FeatureType.STATION) {
                throw new UnsupportedOperationException("Station list request is only supported for Station features");
            }
            FeatureDatasetCapabilitiesWriter xmlWriter = new FeatureDatasetCapabilitiesWriter(fd, this.buildDatasetUrl(datasetPath));
            Object stnsList = new String[]{};
            stnsList = params.getStns() != null ? params.getStns().toArray((T[])stnsList) : null;
            LatLonRect llrect = null;
            if (params.getNorth() != null && params.getSouth() != null && params.getEast() != null && params.getWest() != null) {
                llrect = new LatLonRect((LatLonPoint)new LatLonPointImpl(params.getSouth().doubleValue(), params.getWest().doubleValue()), (LatLonPoint)new LatLonPointImpl(params.getNorth().doubleValue(), params.getEast().doubleValue()));
            }
            Document doc = xmlWriter.makeStationCollectionDocument(llrect, stnsList);
            ModelAndView modelAndView = new ModelAndView("threddsXmlView", "Document", (Object)doc);
            return modelAndView;
        }
    }

    public static SupportedOperation getSupportedOperation(FeatureDataset fd) {
        switch (fd.getFeatureType()) {
            case POINT: {
                return SupportedOperation.POINT_REQUEST;
            }
            case STATION: {
                return SupportedOperation.STATION_REQUEST;
            }
        }
        throw new UnsupportedOperationException(String.format("'%s' format not currently supported for DSG subset writing.", fd.getFeatureType()));
    }
}

