/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.params;

import java.text.ParseException;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.validation.TimeParamsConstraint;
import thredds.server.ncss.validation.VarParamConstraint;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

@TimeParamsConstraint
public class NcssParamsBean {
    private static Logger log = LoggerFactory.getLogger((String)"featureCollectionScan");
    protected String accept;
    @VarParamConstraint
    protected List<String> var;
    protected String time_start;
    protected String time_end;
    protected String time_duration;
    protected String time;
    protected String temporal;
    protected String time_window;
    protected Double north;
    protected Double south;
    protected Double east;
    protected Double west;
    protected Double latitude;
    protected Double longitude;
    protected TimeDuration timeWindow;
    protected CalendarDate date;
    protected CalendarDateRange dateRange;

    public NcssParamsBean() {
    }

    public NcssParamsBean(NcssParamsBean from) {
        this.accept = from.accept;
        this.var = from.var;
        this.time_start = from.time_start;
        this.time_end = from.time_end;
        this.time_duration = from.time_duration;
        this.time = from.time;
        this.temporal = from.temporal;
        this.north = from.north;
        this.south = from.south;
        this.east = from.east;
        this.west = from.west;
        this.latitude = from.latitude;
        this.longitude = from.longitude;
        this.date = from.date;
        this.dateRange = from.dateRange;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public List<String> getVar() {
        return this.var;
    }

    public void setVar(List<String> var) {
        this.var = var;
    }

    public String getTime_start() {
        return this.time_start;
    }

    public void setTime_start(String time_start) {
        this.time_start = time_start;
    }

    public String getTime_end() {
        return this.time_end;
    }

    public void setTime_end(String time_end) {
        this.time_end = time_end;
    }

    public String getTime_duration() {
        return this.time_duration;
    }

    public void setTime_duration(String time_duration) {
        this.time_duration = time_duration;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getTemporal() {
        return this.temporal;
    }

    public void setTemporal(String temporal) {
        this.temporal = temporal;
    }

    public String getTime_window() {
        return this.time_window;
    }

    public void setTime_window(String time_window) {
        this.time_window = time_window;
    }

    public Double getNorth() {
        return this.north;
    }

    public void setNorth(Double north) {
        this.north = north;
    }

    public Double getSouth() {
        return this.south;
    }

    public void setSouth(Double south) {
        this.south = south;
    }

    public Double getEast() {
        return this.east;
    }

    public void setEast(Double east) {
        this.east = east;
    }

    public Double getWest() {
        return this.west;
    }

    public void setWest(Double west) {
        this.west = west;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public boolean hasLatLonPoint() {
        return this.latitude != null && this.longitude != null;
    }

    public boolean hasLatLonBB() {
        return this.east != null && this.west != null && this.north != null && this.south != null;
    }

    public LatLonRect getLatLonBoundingBox() {
        if (!this.hasLatLonBB()) {
            return null;
        }
        double width = this.getEast() - this.getWest();
        double height = this.getNorth() - this.getSouth();
        return new LatLonRect((LatLonPoint)new LatLonPointImpl(this.getSouth().doubleValue(), this.getWest().doubleValue()), height, width);
    }

    public TimeDuration getTimeWindow() {
        return this.timeWindow;
    }

    public void setTimeWindow(TimeDuration timeWindow) {
        this.timeWindow = timeWindow;
    }

    public void setDate(CalendarDate date) {
        this.date = date;
    }

    public void setDateRange(CalendarDateRange dateRange) {
        this.dateRange = dateRange;
    }

    public boolean isAllTimes() {
        return this.temporal != null && this.temporal.equalsIgnoreCase("all") || this.time != null && this.time.equalsIgnoreCase("all");
    }

    public boolean isPresentTime() {
        return this.time != null && this.time.equalsIgnoreCase("present");
    }

    public CalendarDateRange getCalendarDateRange(Calendar cal) {
        if (this.dateRange == null) {
            return null;
        }
        if (cal.equals((Object)Calendar.getDefault())) {
            return this.dateRange;
        }
        return this.makeCalendarDateRange(cal);
    }

    public CalendarDateRange makeCalendarDateRange(Calendar cal) {
        try {
            DateRange dr = new DateRange(new DateType(this.time_start, null, null, cal), new DateType(this.time_end, null, null, cal), new TimeDuration(this.time_duration), null);
            return CalendarDateRange.of((CalendarDate)dr.getStart().getCalendarDate(), (CalendarDate)dr.getEnd().getCalendarDate());
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public CalendarDate getRequestedDate(Calendar cal) {
        if (this.date == null) {
            return null;
        }
        if (cal.equals((Object)Calendar.getDefault())) {
            return this.date;
        }
        return CalendarDateFormatter.isoStringToCalendarDate((Calendar)cal, (String)this.getTime());
    }

    public boolean intersectsTime(CalendarDateRange have, Formatter errs) {
        if (have == null) {
            return true;
        }
        Calendar dataCal = have.getStart().getCalendar();
        CalendarDateRange want = this.getCalendarDateRange(dataCal);
        if (want != null) {
            if (have.intersects(want)) {
                return true;
            }
            errs.format("Requested time range %s does not intersect actual time range %s", want, have);
            return false;
        }
        CalendarDate wantTime = this.getRequestedDate(dataCal);
        if (wantTime == null) {
            return true;
        }
        if (!have.includes(wantTime)) {
            errs.format("Requested time %s does not intersect actual time range %s", wantTime, have);
            return false;
        }
        return true;
    }

    public TimeDuration parseTimeDuration() throws NcssException {
        if (this.getTime_duration() == null) {
            return null;
        }
        try {
            return TimeDuration.parseW3CDuration((String)this.getTime_duration());
        }
        catch (ParseException e) {
            throw new NcssException("invalid time duration");
        }
    }
}

