/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.station;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.controller.NcssDiskCache;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.station.AbstractStationSubsetWriter;
import thredds.util.ContentType;
import thredds.util.TdsPathUtils;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.ft.point.writer.WriterCFStationCollection;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IO;
import ucar.unidata.geoloc.Station;

public class StationSubsetWriterNetcdf
extends AbstractStationSubsetWriter {
    private final OutputStream out;
    private final NetcdfFileWriter.Version version;
    private final File netcdfResult;
    private final WriterCFStationCollection cfWriter;
    private final NcssDiskCache ncssDiskCache;

    public StationSubsetWriterNetcdf(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, NcssDiskCache ncssDiskCache, OutputStream out, NetcdfFileWriter.Version version) throws NcssException, IOException {
        super(fdPoint, ncssParams);
        this.ncssDiskCache = ncssDiskCache;
        this.out = out;
        this.version = version;
        this.netcdfResult = ncssDiskCache.getDiskCache().createUniqueFile("ncssTemp", ".nc");
        ArrayList<Attribute> attribs = new ArrayList<Attribute>();
        attribs.add(new Attribute("title", "Extracted data from TDS Feature Collection " + fdPoint.getLocation()));
        assert (fdPoint.getPointFeatureCollectionList().size() > 0);
        DsgFeatureCollection fc = (DsgFeatureCollection)fdPoint.getPointFeatureCollectionList().get(0);
        CalendarDateUnit timeUnit = fc.getTimeUnit();
        String altUnit = fc.getAltUnits();
        this.cfWriter = new WriterCFStationCollection(this.netcdfResult.getAbsolutePath(), attribs, this.wantedVariables, timeUnit, altUnit, new CFPointWriterConfig(version));
    }

    @Override
    public HttpHeaders getHttpHeaders(String datasetPath, boolean isStream) {
        HttpHeaders httpHeaders = new HttpHeaders();
        String fileName = TdsPathUtils.getFileNameForResponse(datasetPath, this.version);
        String url = this.ncssDiskCache.getServletCachePath() + fileName;
        if (this.version == NetcdfFileWriter.Version.netcdf3) {
            httpHeaders.set("Content-Type", ContentType.netcdf.getContentHeader());
        } else if (this.version == NetcdfFileWriter.Version.netcdf4 || this.version == NetcdfFileWriter.Version.netcdf4_classic) {
            httpHeaders.set("Content-Type", ContentType.netcdf.getContentHeader());
        }
        httpHeaders.set("Content-Location", url);
        httpHeaders.set("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        return httpHeaders;
    }

    @Override
    protected void writeHeader(StationPointFeature stationPointFeat) throws Exception {
        this.cfWriter.writeHeader(this.wantedStations, stationPointFeat);
    }

    @Override
    protected void writeStationPointFeature(StationPointFeature stationPointFeat) throws Exception {
        StationFeature station = stationPointFeat.getStation();
        this.cfWriter.writeRecord((Station)station, (PointFeature)stationPointFeat, stationPointFeat.getFeatureData());
    }

    @Override
    protected void writeFooter() throws Exception {
        this.cfWriter.finish();
        IO.copyFileB((File)this.netcdfResult, (OutputStream)this.out, (int)60000);
        this.out.flush();
    }
}

